/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstMemberRef;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Prototype;
import com.android.dx.rop.type.Type;

public abstract class CstBaseMethodRef
extends CstMemberRef {
    private final Prototype prototype;
    private Prototype instancePrototype;

    CstBaseMethodRef(CstType definingClass, CstNat nat) {
        super(definingClass, nat);
        String descriptor = this.getNat().getDescriptor().getString();
        this.prototype = Prototype.intern(descriptor);
        this.instancePrototype = null;
    }

    public final Prototype getPrototype() {
        return this.prototype;
    }

    public final Prototype getPrototype(boolean isStatic) {
        if (isStatic) {
            return this.prototype;
        }
        if (this.instancePrototype == null) {
            Type thisType = this.getDefiningClass().getClassType();
            this.instancePrototype = this.prototype.withFirstParameter(thisType);
        }
        return this.instancePrototype;
    }

    protected final int compareTo0(Constant other) {
        int cmp = super.compareTo0(other);
        if (cmp != 0) {
            return cmp;
        }
        CstBaseMethodRef otherMethod = (CstBaseMethodRef)other;
        return this.prototype.compareTo(otherMethod.prototype);
    }

    public final Type getType() {
        return this.prototype.getReturnType();
    }

    public final int getParameterWordCount(boolean isStatic) {
        return this.getPrototype(isStatic).getParameterTypes().getWordCount();
    }

    public final boolean isInstanceInit() {
        return this.getNat().isInstanceInit();
    }

    public final boolean isClassInit() {
        return this.getNat().isClassInit();
    }
}

