/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Premium;
import org.languagetool.rules.Rule;
import org.languagetool.server.DictGroupEntry;
import org.languagetool.server.ExtendedUserInfo;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.UserInfoEntry;
import org.languagetool.server.UserLimits;

abstract class DatabaseAccess {
    private static DatabaseAccess instance;
    protected SqlSessionFactory sqlSessionFactory;

    protected DatabaseAccess(HTTPServerConfig config) {
    }

    static synchronized void init(HTTPServerConfig config) {
        if (instance == null) {
            String className = "org.languagetool.server.DatabaseAccess";
            className = Premium.isPremiumVersion() ? className + "Premium" : className + "OpenSource";
            try {
                Class<?> clazz = JLanguageTool.getClassBroker().forName(className);
                instance = (DatabaseAccess)clazz.getConstructor(HTTPServerConfig.class).newInstance(config);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static synchronized void reset() {
        if (instance != null) {
            DatabaseAccess.instance.sqlSessionFactory = null;
        }
        instance = null;
    }

    static synchronized DatabaseAccess getInstance() {
        if (instance == null) {
            throw new IllegalStateException("DatabaseAccess.init() has not been called yet or failed");
        }
        return instance;
    }

    static synchronized boolean isReady() {
        return instance != null;
    }

    abstract void invalidateCaches();

    abstract boolean addWord(String var1, Long var2, String var3);

    abstract boolean deleteWord(String var1, Long var2, String var3);

    abstract boolean deleteWordBatch(List<String> var1, Long var2, String var3);

    abstract void addWordBatch(List<String> var1, Long var2, String var3);

    abstract UserInfoEntry getUserInfoWithPassword(String var1, String var2);

    abstract ExtendedUserInfo getExtendedUserInfo(String var1);

    abstract ExtendedUserInfo getExtendedUserInfo(long var1);

    abstract UserInfoEntry getUserInfoWithApiKey(String var1, String var2);

    abstract UserInfoEntry getUserInfoWithAddonToken(String var1, String var2);

    abstract void invalidateUserInfoCache(String var1);

    abstract Long getUserRequestCount(Long var1);

    abstract Long getOrCreateServerId();

    abstract Long getOrCreateClientId(String var1);

    abstract List<DictGroupEntry> getDictGroups(Long var1);

    abstract Long getOrCreateDictGroup(Long var1, String var2);

    public void createAndFillTestTables() {
        this.createAndFillTestTables(false);
    }

    public void createAndFillTestTables(boolean mysql) {
        this.createAndFillTestTables(false, Collections.emptyList());
    }

    public abstract void createAndFillTestTables(boolean var1, List<String> var2);

    public void shutdownCompact() {
        try (SqlSession session = this.sqlSessionFactory.openSession(true);){
            System.out.println("Running shutdownCompact...");
            session.update("shutdownCompact");
        }
    }

    abstract void deleteTestTables();

    /*
     * Exception decompiling
     */
    ResultSet executeStatement(SQL sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void execute(SQL sql) throws SQLException {
        try (SqlSession session = this.sqlSessionFactory.openSession(true);
             Connection conn = session.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute(sql.toString());
        }
    }

    public abstract List<String> getWords(UserLimits var1, List<String> var2, int var3, int var4);

    public abstract List<Rule> getRules(UserLimits var1, Language var2, @Nullable List<String> var3);
}

