/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.FileIOAdapter;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.model.crf.FeatureFunction;
import com.hankcs.hanlp.model.crf.FeatureTemplate;
import com.hankcs.hanlp.model.perceptron.common.TaskType;
import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.feature.MutableFeatureMap;
import com.hankcs.hanlp.model.perceptron.model.LinearModel;
import com.hankcs.hanlp.model.perceptron.tagset.CWSTagSet;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.model.perceptron.tagset.TagSet;
import com.hankcs.hanlp.utility.Predefine;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class LogLinearModel
extends LinearModel {
    private FeatureTemplate[] featureTemplateArray;

    private LogLinearModel(FeatureMap featureMap, float[] parameter) {
        super(featureMap, parameter);
    }

    private LogLinearModel(FeatureMap featureMap) {
        super(featureMap);
    }

    @Override
    public boolean load(ByteArray byteArray) {
        if (!super.load(byteArray)) {
            return false;
        }
        int size = byteArray.nextInt();
        this.featureTemplateArray = new FeatureTemplate[size];
        for (int i = 0; i < size; ++i) {
            FeatureTemplate featureTemplate = new FeatureTemplate();
            featureTemplate.load(byteArray);
            this.featureTemplateArray[i] = featureTemplate;
        }
        if (!byteArray.hasMore()) {
            byteArray.close();
        }
        return true;
    }

    public LogLinearModel(String modelFile) throws IOException {
        super(null, null);
        if (modelFile.endsWith(".bin")) {
            this.load(modelFile);
            return;
        }
        String binPath = modelFile + ".bin";
        if (HanLP.Config.IOAdapter != null && !(HanLP.Config.IOAdapter instanceof FileIOAdapter) || IOUtil.isFileExisted(binPath)) {
            try {
                this.load(binPath);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.convert(modelFile, binPath);
    }

    public LogLinearModel(String txtFile, String binFile) throws IOException {
        super(null, null);
        this.convert(txtFile, binFile);
    }

    /*
     * WARNING - void declaration
     */
    private void convert(String txtFile, String binFile) throws IOException {
        Object args;
        String line;
        TagSet tagSet = new TagSet(TaskType.CLASSIFICATION);
        IOUtil.LineIterator lineIterator = new IOUtil.LineIterator(txtFile);
        if (!lineIterator.hasNext()) {
            throw new IOException("\u7a7a\u767d\u6587\u4ef6");
        }
        Predefine.logger.info(lineIterator.next());
        Predefine.logger.info(lineIterator.next());
        int maxid = Integer.parseInt(lineIterator.next().substring("maxid:".length()).trim());
        Predefine.logger.info(lineIterator.next());
        lineIterator.next();
        while ((line = lineIterator.next()).length() != 0) {
            tagSet.add(line);
        }
        tagSet.type = this.guessModelType(tagSet);
        switch (tagSet.type) {
            case CWS: {
                tagSet = new CWSTagSet(tagSet.idOf("B"), tagSet.idOf("M"), tagSet.idOf("E"), tagSet.idOf("S"));
                break;
            }
            case NER: {
                tagSet = new NERTagSet(tagSet.idOf("O"), tagSet.tags());
            }
        }
        tagSet.lock();
        FeatureMap featureMap = this.featureMap = new MutableFeatureMap(tagSet);
        int sizeOfTagSet = tagSet.size();
        TreeMap<Object, FeatureFunction> featureFunctionMap = new TreeMap<Object, FeatureFunction>();
        TreeMap<Integer, FeatureFunction> featureFunctionList = new TreeMap<Integer, FeatureFunction>();
        ArrayList<FeatureTemplate> featureTemplateList = new ArrayList<FeatureTemplate>();
        float[][] matrix = null;
        while ((line = lineIterator.next()).length() != 0) {
            if (!"B".equals(line)) {
                FeatureTemplate featureTemplate = FeatureTemplate.create(line);
                featureTemplateList.add(featureTemplate);
                continue;
            }
            matrix = new float[sizeOfTagSet][sizeOfTagSet];
        }
        this.featureTemplateArray = featureTemplateList.toArray(new FeatureTemplate[0]);
        int b = -1;
        if (matrix != null) {
            args = lineIterator.next().split(" ", 2);
            b = Integer.valueOf(args[0]);
            featureFunctionList.put(b, null);
        }
        while ((line = lineIterator.next()).length() != 0) {
            args = line.split(" ", 2);
            char[] cArray = ((String)args[1]).toCharArray();
            FeatureFunction featureFunction = new FeatureFunction(cArray, sizeOfTagSet);
            featureFunctionMap.put(args[1], featureFunction);
            featureFunctionList.put(Integer.parseInt((String)args[0]), featureFunction);
        }
        for (Map.Entry entry : featureFunctionList.entrySet()) {
            int i;
            int fid = (Integer)entry.getKey();
            FeatureFunction featureFunction = (FeatureFunction)entry.getValue();
            if (fid == b) {
                for (i = 0; i < sizeOfTagSet; ++i) {
                    for (int j = 0; j < sizeOfTagSet; ++j) {
                        matrix[i][j] = Float.parseFloat(lineIterator.next());
                    }
                }
                continue;
            }
            for (i = 0; i < sizeOfTagSet; ++i) {
                featureFunction.w[i] = Double.parseDouble(lineIterator.next());
            }
        }
        if (lineIterator.hasNext()) {
            Predefine.logger.warning("\u6587\u672c\u8bfb\u53d6\u6709\u6b8b\u7559\uff0c\u53ef\u80fd\u4f1a\u51fa\u95ee\u9898\uff01" + txtFile);
        }
        lineIterator.close();
        Predefine.logger.info("\u6587\u672c\u8bfb\u53d6\u7ed3\u675f\uff0c\u5f00\u59cb\u8f6c\u6362\u6a21\u578b");
        int transitionFeatureOffset = (sizeOfTagSet + 1) * sizeOfTagSet;
        this.parameter = new float[transitionFeatureOffset + featureFunctionMap.size() * sizeOfTagSet];
        if (matrix != null) {
            void var15_21;
            boolean bl = false;
            while (var15_21 < sizeOfTagSet) {
                for (int j = 0; j < sizeOfTagSet; ++j) {
                    this.parameter[var15_21 * sizeOfTagSet + j] = matrix[var15_21][j];
                }
                ++var15_21;
            }
        }
        block13: for (Map.Entry entry : featureFunctionList.entrySet()) {
            int id = (Integer)entry.getKey();
            FeatureFunction f = (FeatureFunction)entry.getValue();
            if (f == null) continue;
            String feature = new String(f.o);
            for (int tid = 0; tid < featureTemplateList.size(); ++tid) {
                FeatureTemplate template = (FeatureTemplate)featureTemplateList.get(tid);
                Iterator<String> iterator = template.delimiterList.iterator();
                String header = iterator.next();
                if (!feature.startsWith(header)) continue;
                int fid = featureMap.idOf(feature.substring(header.length()) + tid);
                for (int i = 0; i < sizeOfTagSet; ++i) {
                    this.parameter[fid * sizeOfTagSet + i] = (float)f.w[i];
                }
                continue block13;
            }
        }
        DataOutputStream dataOutputStream = new DataOutputStream(IOUtil.newOutputStream(binFile));
        this.save(dataOutputStream);
        dataOutputStream.writeInt(featureTemplateList.size());
        for (FeatureTemplate template : featureTemplateList) {
            template.save(dataOutputStream);
        }
        dataOutputStream.close();
    }

    private TaskType guessModelType(TagSet tagSet) {
        if (tagSet.size() == 4 && tagSet.idOf("B") != -1 && tagSet.idOf("M") != -1 && tagSet.idOf("E") != -1 && tagSet.idOf("S") != -1) {
            return TaskType.CWS;
        }
        if (tagSet.idOf("O") != -1) {
            for (String tag : tagSet.tags()) {
                String[] parts = tag.split("-");
                if (parts.length <= 1 || parts[0].length() != 1 || !"BMES".contains(parts[0])) continue;
                return TaskType.NER;
            }
        }
        return TaskType.POS;
    }

    public FeatureTemplate[] getFeatureTemplateArray() {
        return this.featureTemplateArray;
    }
}

