/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron;

import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.dictionary.other.CharTable;
import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.instance.Instance;
import com.hankcs.hanlp.model.perceptron.instance.InstanceHandler;
import com.hankcs.hanlp.model.perceptron.model.LinearModel;
import com.hankcs.hanlp.model.perceptron.utility.IOUtility;
import com.hankcs.hanlp.model.perceptron.utility.Utility;
import java.io.IOException;

public abstract class InstanceConsumer {
    private static char[] tableChar = new char[CharTable.CONVERT.length];

    protected abstract Instance createInstance(Sentence var1, FeatureMap var2);

    protected double[] evaluate(String developFile, String modelFile) throws IOException {
        return this.evaluate(developFile, new LinearModel(modelFile));
    }

    protected double[] evaluate(String developFile, final LinearModel model) throws IOException {
        final int[] stat = new int[2];
        IOUtility.loadInstance(developFile, new InstanceHandler(){

            @Override
            public boolean process(Sentence sentence) {
                Utility.normalize(sentence);
                Instance instance = InstanceConsumer.this.createInstance(sentence, model.featureMap);
                IOUtility.evaluate(instance, model, stat);
                return false;
            }
        });
        return new double[]{(double)stat[1] / (double)stat[0] * 100.0};
    }

    protected String normalize(String text) {
        char[] result = new char[text.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tableChar[text.charAt(i)];
        }
        return new String(result);
    }

    static {
        System.arraycopy(CharTable.CONVERT, 0, tableChar, 0, tableChar.length);
        for (int c = 0; c <= 32; ++c) {
            InstanceConsumer.tableChar[c] = 38;
        }
    }
}

