/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts;

import java.awt.Color;
import org.netbeans.lib.profiler.ui.charts.AbstractPieChartModel;

public class DynamicPieChartModel
extends AbstractPieChartModel {
    protected Color[] itemColors;
    protected String[] itemNames;
    protected double[] itemValues;
    protected double[] itemValuesRel;
    protected boolean hasData = false;
    protected int itemCount = 0;

    @Override
    public Color getItemColor(int index) {
        return this.itemColors[index];
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    @Override
    public String getItemName(int index) {
        return this.itemNames[index];
    }

    @Override
    public double getItemValue(int index) {
        return this.itemValues[index];
    }

    @Override
    public double getItemValueRel(int index) {
        return this.itemValuesRel[index];
    }

    public void setItemValues(double[] itemValues) {
        if (itemValues.length != this.itemCount) {
            this.hasData = false;
            throw new RuntimeException("Unexpected number of values.");
        }
        this.itemValues = itemValues;
        this.updateItemValuesRel();
        this.fireChartDataChanged();
    }

    @Override
    public boolean isSelectable(int index) {
        return true;
    }

    @Override
    public boolean hasData() {
        return this.hasData;
    }

    public void setupModel(String[] itemNames, Color[] itemColors) {
        this.itemNames = itemNames;
        this.itemColors = itemColors;
        if (itemNames.length != itemColors.length) {
            this.itemCount = 0;
            throw new RuntimeException("Counts of item names and item colors don't match.");
        }
        this.itemCount = itemNames.length;
        this.itemValues = null;
        this.itemValuesRel = new double[this.itemCount];
        this.hasData = false;
    }

    private void updateItemValuesRel() {
        int i;
        double sum = 0.0;
        for (i = 0; i < this.itemValues.length; ++i) {
            sum += this.itemValues[i];
        }
        if (sum == 0.0) {
            for (i = 0; i < this.itemValues.length; ++i) {
                this.itemValuesRel[i] = 0.0;
            }
            this.hasData = false;
        } else {
            for (i = 0; i < this.itemValues.length; ++i) {
                this.itemValuesRel[i] = this.itemValues[i] / sum;
            }
            this.hasData = true;
        }
    }
}

