/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.DeferredChangeDetectionPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.EntityFetchGroup;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateChangeRecord;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;

public class AggregateObjectMapping
extends AggregateMapping
implements RelationalMapping,
MapKeyMapping,
EmbeddableMapping {
    protected boolean isNullAllowed = true;
    protected DatabaseTable aggregateKeyTable = null;
    protected Map<String, DatabaseField> aggregateToSourceFields = new HashMap<String, DatabaseField>(5);
    protected Map<String, Object[]> nestedFieldTranslations = new HashMap<String, Object[]>();
    protected List<ManyToManyMapping> overrideManyToManyMappings;
    protected List<UnidirectionalOneToManyMapping> overrideUnidirectionalOneToManyMappings;
    protected Map<String, Converter> converters;
    protected List<DatabaseMapping> mapsIdMappings = new ArrayList<DatabaseMapping>();

    public AggregateObjectMapping() {
        this.overrideManyToManyMappings = new ArrayList<ManyToManyMapping>();
        this.overrideUnidirectionalOneToManyMappings = new ArrayList<UnidirectionalOneToManyMapping>();
        this.converters = new HashMap<String, Converter>();
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    @Override
    public void addAdditionalFieldsToQuery(ReadQuery selectionQuery, Expression baseExpression) {
        for (DatabaseField field : this.getReferenceDescriptor().getAllFields()) {
            if (selectionQuery.isObjectLevelReadQuery()) {
                ((ObjectLevelReadQuery)selectionQuery).addAdditionalField(baseExpression.getField(field));
                continue;
            }
            if (!selectionQuery.isDataReadQuery()) continue;
            ((SQLSelectStatement)((DataReadQuery)selectionQuery).getSQLStatement()).addField(baseExpression.getField(field));
        }
    }

    @Override
    public void addConverter(Converter converter, String attributeName) {
        this.converters.put(attributeName, converter);
    }

    @Override
    public void addFieldsForMapKey(AbstractRecord joinRow) {
        for (DatabaseMapping mapping : this.getReferenceDescriptor().getMappings()) {
            if (mapping.isReadOnly()) continue;
            for (DatabaseField field : mapping.getFields()) {
                if (!field.isUpdatable()) continue;
                joinRow.put(field, (Object)null);
            }
        }
    }

    public void addFieldNameTranslation(String sourceFieldName, String aggregateFieldName) {
        this.addFieldTranslation(new DatabaseField(sourceFieldName), aggregateFieldName);
    }

    @Override
    public void addFieldTranslation(DatabaseField sourceField, String aggregateFieldName) {
        String unQualifiedAggregateFieldName = aggregateFieldName.substring(aggregateFieldName.lastIndexOf(46) + 1);
        this.getAggregateToSourceFields().put(unQualifiedAggregateFieldName, sourceField);
    }

    public void addMapsIdMapping(DatabaseMapping mapping) {
        this.mapsIdMappings.add(mapping);
    }

    @Override
    public void addNestedFieldTranslation(String attributeName, DatabaseField sourceField, String aggregateFieldName) {
        this.nestedFieldTranslations.put(attributeName, new Object[]{sourceField, aggregateFieldName});
    }

    @Override
    public void addOverrideManyToManyMapping(ManyToManyMapping mapping) {
        this.overrideManyToManyMappings.add(mapping);
    }

    @Override
    public void addOverrideUnidirectionalOneToManyMapping(UnidirectionalOneToManyMapping mapping) {
        this.overrideUnidirectionalOneToManyMappings.add(mapping);
    }

    @Override
    public void addKeyToDeletedObjectsList(Object object, Map deletedObjects) {
    }

    protected boolean allAggregateFieldsAreNull(AbstractRecord databaseRow) {
        Vector<DatabaseField> fields = this.getReferenceFields();
        int size = fields.size();
        int index = 0;
        while (index < size) {
            DatabaseField field = fields.get(index);
            Object value = databaseRow.get(field);
            if (value != null) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public void allowNull() {
        this.setIsNullAllowed(true);
    }

    protected boolean backupAttributeValueIsNull(WriteObjectQuery query) {
        Object backupAttributeValue;
        return query.getSession().isUnitOfWork() && (backupAttributeValue = this.getAttributeValueFromObject(query.getBackupClone())) == null;
    }

    public Object buildAggregateFromRow(AbstractRecord databaseRow, Object targetObject, CacheKey cacheKey, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, boolean buildShallowOriginal, AbstractSession executionSession, boolean targetIsProtected) throws DatabaseException {
        EntityFetchGroup entityFetchGroup;
        if (databaseRow.hasSopObject()) {
            Object sopAggregate = this.getAttributeValueFromObject(databaseRow.getSopObject());
            if (targetObject != null && targetObject != databaseRow.getSopObject()) {
                this.setAttributeValueInObject(targetObject, sopAggregate);
            }
            return sopAggregate;
        }
        if (this.isNullAllowed() && this.allAggregateFieldsAreNull(databaseRow)) {
            return null;
        }
        Object aggregate = null;
        ClassDescriptor descriptor = this.getReferenceDescriptor();
        boolean refreshing = true;
        if (targetObject != null) {
            if (descriptor.hasInheritance()) {
                Class newAggregateClass = descriptor.getInheritancePolicy().classFromRow(databaseRow, executionSession);
                aggregate = this.getMatchingAttributeValueFromObject(databaseRow, targetObject, executionSession, descriptor = this.getReferenceDescriptor(newAggregateClass, executionSession));
                if (aggregate != null && aggregate.getClass() != newAggregateClass) {
                    aggregate = descriptor.getObjectBuilder().buildNewInstance();
                    refreshing = false;
                }
            } else {
                aggregate = this.getMatchingAttributeValueFromObject(databaseRow, targetObject, executionSession, descriptor);
            }
        }
        if (aggregate == null) {
            aggregate = descriptor.getObjectBuilder().buildNewInstance();
            refreshing = false;
        }
        ObjectBuildingQuery nestedQuery = sourceQuery;
        FetchGroup targetFetchGroup = null;
        if (sourceQuery.isObjectLevelReadQuery()) {
            FetchGroup sourceFG;
            ObjectLevelReadQuery objectQuery = (ObjectLevelReadQuery)sourceQuery;
            ObjectLevelReadQuery nestedObjectQuery = (ObjectLevelReadQuery)nestedQuery;
            String attributeName = this.getAttributeName();
            if (objectQuery.isPartialAttribute(attributeName) || joinManager != null && joinManager.isAttributeJoined(this.descriptor, this)) {
                nestedObjectQuery = (ObjectLevelReadQuery)objectQuery.deepClone();
                if (objectQuery.hasPartialAttributeExpressions()) {
                    nestedObjectQuery.setPartialAttributeExpressions(this.extractNestedExpressions(objectQuery.getPartialAttributeExpressions(), nestedObjectQuery.getExpressionBuilder(), false));
                } else if (nestedObjectQuery.getJoinedAttributeManager().isToManyJoin()) {
                    ArrayList<AbstractRecord> dataResults = new ArrayList<AbstractRecord>();
                    nestedObjectQuery.getJoinedAttributeManager().setDataResults(dataResults, executionSession);
                    dataResults.addAll(joinManager.getDataResults_());
                    nestedObjectQuery.getJoinedAttributeManager().getDataResultsByPrimaryKey().putAll(joinManager.getDataResultsByPrimaryKey());
                }
                nestedObjectQuery.setDescriptor(descriptor);
                joinManager = nestedObjectQuery.getJoinedAttributeManager();
            }
            if (objectQuery.isAttributeBatchRead(this.descriptor, attributeName)) {
                if (nestedObjectQuery == objectQuery) {
                    nestedObjectQuery = (ObjectLevelReadQuery)nestedObjectQuery.clone();
                }
                nestedObjectQuery.setProperties(objectQuery.getProperties());
                nestedObjectQuery.getBatchFetchPolicy().setAttributeExpressions(this.extractNestedExpressions(objectQuery.getBatchReadAttributeExpressions(), nestedObjectQuery.getExpressionBuilder(), false));
            }
            if ((sourceFG = sourceQuery.getExecutionFetchGroup(descriptor)) != null) {
                if (nestedObjectQuery == objectQuery) {
                    nestedObjectQuery = (ObjectLevelReadQuery)nestedObjectQuery.clone();
                }
                if ((targetFetchGroup = sourceFG.getGroup(this.getAttributeName())) != null && sourceQuery.getDescriptor().hasFetchGroupManager()) {
                    nestedObjectQuery.setFetchGroup(targetFetchGroup);
                } else {
                    targetFetchGroup = null;
                    nestedObjectQuery.setFetchGroup(null);
                    nestedObjectQuery.setFetchGroupName(null);
                }
                nestedObjectQuery.setShouldUseDefaultFetchGroup(false);
                nestedObjectQuery.prepareFetchGroup();
            }
            if (descriptor.hasFetchGroupManager()) {
                descriptor.getFetchGroupManager().unionEntityFetchGroupIntoObject(aggregate, descriptor.getFetchGroupManager().getEntityFetchGroup(targetFetchGroup), executionSession, true);
            }
            nestedQuery = nestedObjectQuery;
        }
        if (buildShallowOriginal) {
            descriptor.getObjectBuilder().buildAttributesIntoShallowObject(aggregate, databaseRow, nestedQuery);
        } else if (executionSession.isUnitOfWork()) {
            descriptor.getObjectBuilder().buildAttributesIntoWorkingCopyClone(aggregate, this.buildWrapperCacheKeyForAggregate(cacheKey, targetIsProtected), nestedQuery, joinManager, databaseRow, (UnitOfWorkImpl)executionSession, refreshing);
        } else {
            descriptor.getObjectBuilder().buildAttributesIntoObject(aggregate, this.buildWrapperCacheKeyForAggregate(cacheKey, targetIsProtected), databaseRow, nestedQuery, joinManager, sourceQuery.getExecutionFetchGroup(descriptor), refreshing, executionSession);
        }
        if (sourceQuery.shouldMaintainCache() && !sourceQuery.shouldStoreBypassCache() && targetFetchGroup != null && descriptor.hasFetchGroupManager() && (entityFetchGroup = (EntityFetchGroup)descriptor.getFetchGroupManager().getEntityFetchGroup(targetFetchGroup).clone()) != null) {
            entityFetchGroup.setRootEntity((FetchGroupTracker)cacheKey.getObject());
            entityFetchGroup.setOnEntity(aggregate, executionSession);
        }
        return aggregate;
    }

    protected CacheKey buildWrapperCacheKeyForAggregate(CacheKey owningCacheKey, boolean targetIsProtected) {
        if (!this.descriptor.getCachePolicy().isProtectedIsolation()) {
            return owningCacheKey;
        }
        if (!targetIsProtected || this.isMapKeyMapping || owningCacheKey == null) {
            return owningCacheKey;
        }
        CacheKey aggregateKey = owningCacheKey;
        Object object = owningCacheKey.getObject();
        if (owningCacheKey.getObject() != null) {
            Object aggregate = this.getAttributeValueFromObject(object);
            aggregateKey = new CacheKey(null, aggregate, null);
            aggregateKey.setProtectedForeignKeys(owningCacheKey.getProtectedForeignKeys());
            aggregateKey.setRecord(owningCacheKey.getRecord());
            aggregateKey.setIsolated(owningCacheKey.isIsolated());
            aggregateKey.setReadTime(owningCacheKey.getReadTime());
        }
        return aggregateKey;
    }

    protected void writeNullReferenceRow(AbstractRecord record) {
        Vector<DatabaseField> fields = this.getReferenceFields();
        int size = fields.size();
        boolean nullInserted = false;
        int index = 0;
        while (index < size) {
            DatabaseField field = (DatabaseField)fields.get(index);
            if (!field.isReadOnly() && (field.isUpdatable() || field.isInsertable())) {
                record.put(field, (Object)null);
                nullInserted = true;
            }
            ++index;
        }
        if (size > 0 && nullInserted) {
            record.setNullValueInFields(true);
        }
    }

    @Override
    public Expression buildObjectJoinExpression(Expression expression, Object value, AbstractSession session) {
        Expression attributeByAttributeComparison = null;
        Expression join = null;
        Object attributeValue = null;
        ClassDescriptor referenceDescriptor = this.getReferenceDescriptor();
        if (value != null && !referenceDescriptor.getJavaClass().isInstance(value)) {
            throw QueryException.incorrectClassForObjectComparison(expression, value, this);
        }
        Enumeration<DatabaseMapping> mappings = referenceDescriptor.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            attributeValue = value == null ? null : mapping.getAttributeValueFromObject(value);
            join = expression.get(mapping.getAttributeName()).equal(attributeValue);
            attributeByAttributeComparison = attributeByAttributeComparison == null ? join : attributeByAttributeComparison.and(join);
        }
        return attributeByAttributeComparison;
    }

    @Override
    public Expression buildObjectJoinExpression(Expression expression, Expression argument, AbstractSession session) {
        Expression attributeByAttributeComparison = null;
        Enumeration<DatabaseMapping> mappingsEnum = this.getReferenceDescriptor().getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            DatabaseMapping mapping = mappingsEnum.nextElement();
            String attributeName = mapping.getAttributeName();
            Expression join = expression.get(attributeName).equal(argument.get(attributeName));
            attributeByAttributeComparison = attributeByAttributeComparison == null ? join : attributeByAttributeComparison.and(join);
        }
        return attributeByAttributeComparison;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeToRowFromAggregate(AbstractRecord record, Object object, Object attributeValue, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        if (attributeValue == null) {
            if (!this.isNullAllowed) throw DescriptorException.nullForNonNullAggregate(object, this);
            this.writeNullReferenceRow(record);
            return;
        } else {
            if (session.isClassReadOnly(attributeValue.getClass())) return;
            this.getObjectBuilder(attributeValue, session).buildRow(record, attributeValue, session, writeType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeToRowFromAggregateForShallowInsert(AbstractRecord record, Object object, Object attributeValue, AbstractSession session) throws DescriptorException {
        if (attributeValue == null) {
            if (!this.isNullAllowed) throw DescriptorException.nullForNonNullAggregate(object, this);
            this.writeNullReferenceRow(record);
            return;
        } else {
            if (session.isClassReadOnly(attributeValue.getClass())) return;
            this.getObjectBuilder(attributeValue, session).buildRowForShallowInsert(record, attributeValue, session);
        }
    }

    protected void writeToRowFromAggregateForUpdateAfterShallowInsert(AbstractRecord record, Object object, Object attributeValue, AbstractSession session, DatabaseTable table) throws DescriptorException {
        if (attributeValue == null) {
            if (!this.isNullAllowed) {
                throw DescriptorException.nullForNonNullAggregate(object, this);
            }
        } else if (!session.isClassReadOnly(attributeValue.getClass()) && !this.isPrimaryKeyMapping()) {
            this.getObjectBuilder(attributeValue, session).buildRowForUpdateAfterShallowInsert(record, attributeValue, session, table);
        }
    }

    protected void writeToRowFromAggregateForUpdateBeforeShallowDelete(AbstractRecord record, Object object, Object attributeValue, AbstractSession session, DatabaseTable table) throws DescriptorException {
        if (attributeValue == null) {
            if (!this.isNullAllowed) {
                throw DescriptorException.nullForNonNullAggregate(object, this);
            }
        } else if (!session.isClassReadOnly(attributeValue.getClass()) && !this.isPrimaryKeyMapping()) {
            this.getObjectBuilder(attributeValue, session).buildRowForUpdateBeforeShallowDelete(record, attributeValue, session, table);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void writeToRowFromAggregateWithChangeRecord(AbstractRecord record, ChangeRecord changeRecord, ObjectChangeSet objectChangeSet, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        if (objectChangeSet != null) {
            if (session.isClassReadOnly(objectChangeSet.getClassType(session))) return;
            this.getReferenceDescriptor(objectChangeSet.getClassType(session), session).getObjectBuilder().buildRowWithChangeSet(record, objectChangeSet, session, writeType);
            return;
        }
        if (this.isNullAllowed) {
            this.writeNullReferenceRow(record);
            return;
        }
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        throw DescriptorException.nullForNonNullAggregate(object, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeToRowFromAggregateForUpdate(AbstractRecord record, WriteObjectQuery query, Object attributeValue) throws DescriptorException {
        if (attributeValue == null) {
            if (!this.isNullAllowed) throw DescriptorException.nullForNonNullAggregate(query.getObject(), this);
            if (this.backupAttributeValueIsNull(query)) return;
            this.writeNullReferenceRow(record);
            return;
        } else if (!(query.getBackupClone() == null || this.getMatchingBackupAttributeValue(query, attributeValue) != null && attributeValue.getClass().equals(this.getMatchingBackupAttributeValue(query, attributeValue).getClass()))) {
            this.getObjectBuilder(attributeValue, query.getSession()).buildRow(record, attributeValue, query.getSession(), DatabaseMapping.WriteType.UPDATE);
            return;
        } else {
            if (query.getSession().isClassReadOnly(attributeValue.getClass())) return;
            WriteObjectQuery clonedQuery = (WriteObjectQuery)query.clone();
            clonedQuery.setObject(attributeValue);
            if (query.getSession().isUnitOfWork()) {
                Object backupAttributeValue = this.getMatchingBackupAttributeValue(query, attributeValue);
                if (backupAttributeValue == null) {
                    backupAttributeValue = this.getObjectBuilder(attributeValue, query.getSession()).buildNewInstance();
                }
                clonedQuery.setBackupClone(backupAttributeValue);
            }
            this.getObjectBuilder(attributeValue, query.getSession()).buildRowForUpdate(record, clonedQuery);
        }
    }

    @Override
    public void buildClone(Object original, CacheKey cacheKey, Object clone, Integer refreshCascade, AbstractSession cloningSession) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        Object aggregateClone = this.buildClonePart(original, clone, cacheKey, attributeValue, refreshCascade, cloningSession);
        if (aggregateClone != null && cloningSession.isUnitOfWork()) {
            ClassDescriptor descriptor = this.getReferenceDescriptor(aggregateClone, cloningSession);
            descriptor.getObjectChangePolicy().setAggregateChangeListener(clone, aggregateClone, (UnitOfWorkImpl)cloningSession, descriptor, this.getAttributeName());
        }
        this.setAttributeValueInObject(clone, aggregateClone);
    }

    @Override
    public Object buildElementClone(Object attributeValue, Object parent, CacheKey parentCacheKey, Integer refreshCascade, AbstractSession cloningSession, boolean isExisting, boolean isFromSharedCache) {
        Object aggregateClone = this.buildClonePart(attributeValue, parent, parentCacheKey, refreshCascade, cloningSession, !isExisting);
        if (aggregateClone != null && cloningSession.isUnitOfWork()) {
            ClassDescriptor descriptor = this.getReferenceDescriptor(aggregateClone, cloningSession);
            descriptor.getObjectChangePolicy().setAggregateChangeListener(parent, aggregateClone, (UnitOfWorkImpl)cloningSession, descriptor, this.getAttributeName());
        }
        return aggregateClone;
    }

    @Override
    public void setChangeListener(Object clone, PropertyChangeListener listener, UnitOfWorkImpl uow) {
        Object attributeValue = this.getAttributeValueFromObject(clone);
        if (attributeValue != null) {
            ClassDescriptor descriptor = this.getReferenceDescriptor(attributeValue, (AbstractSession)uow);
            descriptor.getObjectChangePolicy().setAggregateChangeListener(clone, attributeValue, uow, descriptor, this.getAttributeName());
        }
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, CacheKey sharedCacheKey, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        Object clonedAttributeValue = this.buildAggregateFromRow(databaseRow, clone, null, joinManager, sourceQuery, false, executionSession, true);
        ClassDescriptor descriptor = this.getReferenceDescriptor(clonedAttributeValue, (AbstractSession)unitOfWork);
        if (clonedAttributeValue != null) {
            descriptor.getObjectChangePolicy().setAggregateChangeListener(clone, clonedAttributeValue, unitOfWork, descriptor, this.getAttributeName());
        }
        this.setAttributeValueInObject(clone, clonedAttributeValue);
    }

    @Override
    public void buildShallowOriginalFromRow(AbstractRecord databaseRow, Object original, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) {
        Object aggregate = this.buildAggregateFromRow(databaseRow, original, null, joinManager, sourceQuery, true, executionSession, true);
        this.setAttributeValueInObject(original, aggregate);
    }

    @Override
    public ReadQuery buildSelectionQueryForDirectCollectionKeyMapping(ContainerPolicy containerPolicy) {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(this.referenceClass);
        query.setDescriptor(this.getReferenceDescriptor());
        query.setContainerPolicy(containerPolicy);
        return query;
    }

    protected AbstractRecord buildTemplateInsertRow(AbstractSession session) {
        AbstractRecord result = this.getReferenceDescriptor().getObjectBuilder().buildTemplateInsertRow(session);
        List processedMappings = (List)this.getReferenceDescriptor().getMappings().clone();
        if (this.getReferenceDescriptor().hasInheritance()) {
            for (ClassDescriptor child : this.getReferenceDescriptor().getInheritancePolicy().getChildDescriptors()) {
                for (DatabaseMapping mapping : child.getMappings()) {
                    if (processedMappings.contains(mapping)) continue;
                    mapping.writeInsertFieldsIntoRow(result, session);
                    processedMappings.add(mapping);
                }
            }
        }
        return result;
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow, boolean getAttributeValueFromObject, Set cascadeErrors) {
        ObjectBuilder builder = this.getReferenceDescriptor(object.getClass(), (AbstractSession)uow).getObjectBuilder();
        builder.cascadeDiscoverAndPersistUnregisteredNewObjects(object, newObjects, unregisteredExistingObjects, visitedObjects, uow, cascadeErrors);
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects, boolean getAttributeValueFromObject) {
        Object objectReferenced = null;
        objectReferenced = getAttributeValueFromObject ? this.getAttributeValueFromObject(object) : object;
        if (objectReferenced == null) {
            return;
        }
        if (!visitedObjects.containsKey(objectReferenced)) {
            visitedObjects.put(objectReferenced, objectReferenced);
            ObjectBuilder builder = this.getReferenceDescriptor(objectReferenced.getClass(), (AbstractSession)uow).getObjectBuilder();
            builder.cascadePerformRemove(objectReferenced, uow, visitedObjects);
        }
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        this.cascadePerformRemoveIfRequired(object, uow, visitedObjects, true);
    }

    @Override
    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            return;
        }
        if (!visitedObjects.containsKey(attributeValue)) {
            visitedObjects.put(attributeValue, attributeValue);
            ObjectBuilder builder = this.getReferenceDescriptor(attributeValue, (AbstractSession)uow).getObjectBuilder();
            builder.cascadePerformRemovePrivateOwnedObjectFromChangeSet(attributeValue, uow, visitedObjects);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects, boolean getAttributeValueFromObject) {
        Object objectReferenced = null;
        objectReferenced = getAttributeValueFromObject ? this.getAttributeValueFromObject(object) : object;
        if (objectReferenced == null) {
            return;
        }
        if (!visitedObjects.containsKey(objectReferenced)) {
            visitedObjects.put(objectReferenced, objectReferenced);
            ObjectBuilder builder = this.getReferenceDescriptor(objectReferenced.getClass(), (AbstractSession)uow).getObjectBuilder();
            builder.cascadeRegisterNewForCreate(objectReferenced, uow, visitedObjects);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        this.cascadeRegisterNewIfRequired(object, uow, visitedObjects, true);
    }

    @Override
    public Object clone() {
        AggregateObjectMapping mappingObject = (AggregateObjectMapping)super.clone();
        HashMap<String, DatabaseField> aggregateToSourceFields = new HashMap<String, DatabaseField>();
        aggregateToSourceFields.putAll(this.getAggregateToSourceFields());
        mappingObject.setAggregateToSourceFields(aggregateToSourceFields);
        return mappingObject;
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        return this.getReferenceFields();
    }

    @Override
    public List<Expression> getOrderByNormalizedExpressions(Expression base) {
        ArrayList<Expression> orderBys = new ArrayList<Expression>(this.fields.size());
        for (DatabaseField field : this.fields) {
            orderBys.add(base.getField(field));
        }
        return orderBys;
    }

    @Override
    public void collectQueryParameters(Set<DatabaseField> record) {
        for (DatabaseMapping mapping : this.getReferenceDescriptor().getMappings()) {
            if ((!mapping.isForeignReferenceMapping() || mapping.isCacheable()) && (!mapping.isAggregateObjectMapping() || !mapping.getReferenceDescriptor().hasNoncacheableMappings())) continue;
            ((ForeignReferenceMapping)mapping).collectQueryParameters(record);
        }
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        for (Converter converter : this.converters.values()) {
            this.convertConverterClassNamesToClasses(converter, classLoader);
        }
    }

    @Override
    public Object createMapComponentFromRow(AbstractRecord dbRow, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        Object key = this.buildAggregateFromRow(dbRow, null, parentCacheKey, null, query, false, session, isTargetProtected);
        return key;
    }

    @Override
    public Object createSerializableMapKeyInfo(Object key, AbstractSession session) {
        return key;
    }

    @Override
    public List<Object> createMapComponentsFromSerializableKeyInfo(Object[] keyInfo, AbstractSession session) {
        return Arrays.asList(keyInfo);
    }

    @Override
    public Object createStubbedMapComponentFromSerializableKeyInfo(Object keyInfo, AbstractSession session) {
        return keyInfo;
    }

    @Override
    public Object createMapComponentFromJoinedRow(AbstractRecord dbRow, JoinedAttributeManager joinManger, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        return this.createMapComponentFromRow(dbRow, query, parentCacheKey, session, isTargetProtected);
    }

    @Override
    public QueryKey createQueryKeyForMapKey() {
        return null;
    }

    @Override
    public void deleteMapKey(Object objectDeleted, AbstractSession session) {
    }

    public void dontAllowNull() {
        this.setIsNullAllowed(false);
    }

    @Override
    public void earlyPreDelete(DeleteObjectQuery query, Object object) {
        for (DatabaseMapping mapping : this.getReferenceDescriptor().getPreDeleteMappings()) {
            Object nestedObject = this.getRealAttributeValueFromObject(object, query.getSession());
            if (nestedObject == null) continue;
            mapping.earlyPreDelete(query, nestedObject);
        }
    }

    @Override
    public Map extractIdentityFieldsForQuery(Object object, AbstractSession session) {
        HashMap<DatabaseField, Object> keyFields = new HashMap<DatabaseField, Object>();
        ClassDescriptor descriptor = this.getReferenceDescriptor();
        boolean usePrimaryKeyFields = descriptor.getPrimaryKeyFields() != null && !descriptor.getPrimaryKeyFields().isEmpty();
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            if (mapping.isReadOnly() || usePrimaryKeyFields && (!usePrimaryKeyFields || !mapping.isPrimaryKeyMapping())) continue;
            for (DatabaseField field : mapping.getFields()) {
                if (!field.isUpdatable()) continue;
                Object value = descriptor.getObjectBuilder().extractValueFromObjectForField(object, field, session);
                keyFields.put(field, value);
            }
        }
        return keyFields;
    }

    @Override
    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        return this.getReferenceDescriptor().getTables();
    }

    @Override
    public Expression getAdditionalSelectionCriteriaForMapKey() {
        return null;
    }

    public Vector<Association> getAggregateToSourceFieldAssociations() {
        Vector<Association> associations = new Vector<Association>(this.getAggregateToSourceFields().size());
        Iterator<String> aggregateEnum = this.getAggregateToSourceFields().keySet().iterator();
        Iterator<DatabaseField> sourceEnum = this.getAggregateToSourceFields().values().iterator();
        while (aggregateEnum.hasNext()) {
            associations.addElement(new Association(aggregateEnum.next(), sourceEnum.next()));
        }
        return associations;
    }

    public Map<String, DatabaseField> getAggregateToSourceFields() {
        return this.aggregateToSourceFields;
    }

    @Override
    public Class getAttributeClassification() {
        return this.getReferenceClass();
    }

    @Override
    public Class getFieldClassification(DatabaseField fieldToClassify) {
        DatabaseMapping mapping = this.getReferenceDescriptor().getObjectBuilder().getMappingForField(fieldToClassify);
        if (mapping == null) {
            return null;
        }
        return mapping.getFieldClassification(fieldToClassify);
    }

    @Override
    public List<DatabaseField> getIdentityFieldsForMapKey() {
        ClassDescriptor descriptor = this.getReferenceDescriptor();
        if (descriptor.getPrimaryKeyFields() != null) {
            return descriptor.getPrimaryKeyFields();
        }
        return this.getAllFieldsForMapKey();
    }

    @Override
    public List<DatabaseField> getAllFieldsForMapKey() {
        return this.getReferenceDescriptor().getAllFields();
    }

    @Override
    public Map<DatabaseField, DatabaseField> getForeignKeyFieldsForMapKey() {
        return null;
    }

    protected Object getMatchingAttributeValueFromObject(AbstractRecord row, Object targetObject, AbstractSession session, ClassDescriptor descriptor) {
        return this.getAttributeValueFromObject(targetObject);
    }

    protected Object getMatchingBackupAttributeValue(WriteObjectQuery query, Object attributeValue) {
        return this.getAttributeValueFromObject(query.getBackupClone());
    }

    @Override
    public ObjectLevelReadQuery getNestedJoinQuery(JoinedAttributeManager joinManager, ObjectLevelReadQuery query, AbstractSession session) {
        return null;
    }

    @Override
    public ClassDescriptor getReferenceDescriptor(Class theClass, AbstractSession session) {
        if (this.referenceDescriptor.getJavaClass() == theClass) {
            return this.referenceDescriptor;
        }
        ClassDescriptor subDescriptor = this.referenceDescriptor.getInheritancePolicy().getSubclassDescriptor(theClass);
        if (subDescriptor == null) {
            throw DescriptorException.noSubClassMatch(theClass, this);
        }
        return subDescriptor;
    }

    protected Vector<DatabaseField> getReferenceFields() {
        return this.getReferenceDescriptor().getAllFields();
    }

    @Override
    public Object getTargetVersionOfSourceObject(Object object, Object parent, MergeManager mergeManager, AbstractSession targetSession) {
        if (mergeManager.getSession().isUnitOfWork()) {
            UnitOfWorkImpl uow = (UnitOfWorkImpl)mergeManager.getSession();
            Object aggregateObject = this.buildClonePart(object, parent, null, null, targetSession, uow.isOriginalNewObject(parent));
            return aggregateObject;
        }
        return object;
    }

    @Override
    public Object getMapKeyTargetType() {
        return this.getReferenceDescriptor();
    }

    @Override
    public boolean hasDependency() {
        return this.getReferenceDescriptor().hasDependencyOnParts();
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        CollectionMapping mappingClone;
        DatabaseMapping mapping;
        AbstractSession referenceSession = session;
        if (session.hasBroker()) {
            if (this.getReferenceClass() == null) {
                throw DescriptorException.referenceClassNotSpecified(this);
            }
            referenceSession = session.getSessionForClass(this.getReferenceClass());
        }
        super.initialize(session);
        ClassDescriptor clonedDescriptor = (ClassDescriptor)this.getReferenceDescriptor().clone();
        List<AttributeAccessor> accessorTree = this.getDescriptor().getAccessorTree();
        accessorTree = accessorTree == null ? new ArrayList<AttributeAccessor>() : new ArrayList<AttributeAccessor>(accessorTree);
        accessorTree.add(this.getAttributeAccessor());
        clonedDescriptor.setAccessorTree(accessorTree);
        if (this.isMapKeyMapping() && clonedDescriptor.isAggregateDescriptor()) {
            clonedDescriptor.descriptorIsAggregateCollection();
        }
        if (clonedDescriptor.isChildDescriptor()) {
            ClassDescriptor classDescriptor = session.getDescriptor(clonedDescriptor.getInheritancePolicy().getParentClass());
            this.initializeParentInheritance(classDescriptor, clonedDescriptor, session);
        }
        this.setReferenceDescriptor(clonedDescriptor);
        for (ManyToManyMapping manyToManyMapping : this.overrideManyToManyMappings) {
            mapping = clonedDescriptor.getMappingForAttributeName(manyToManyMapping.getAttributeName());
            if (!mapping.isManyToManyMapping()) continue;
            mappingClone = (ManyToManyMapping)mapping;
            ((ManyToManyMapping)mappingClone).setRelationTable(manyToManyMapping.getRelationTable());
            ((ManyToManyMapping)mappingClone).setSourceKeyFields(manyToManyMapping.getSourceKeyFields());
            ((ManyToManyMapping)mappingClone).setSourceRelationKeyFields(manyToManyMapping.getSourceRelationKeyFields());
            ((ManyToManyMapping)mappingClone).setTargetKeyFields(manyToManyMapping.getTargetKeyFields());
            ((ManyToManyMapping)mappingClone).setTargetRelationKeyFields(manyToManyMapping.getTargetRelationKeyFields());
        }
        for (UnidirectionalOneToManyMapping unidirectionalOneToManyMapping : this.overrideUnidirectionalOneToManyMappings) {
            mapping = clonedDescriptor.getMappingForAttributeName(unidirectionalOneToManyMapping.getAttributeName());
            if (!mapping.isUnidirectionalOneToManyMapping()) continue;
            mappingClone = (UnidirectionalOneToManyMapping)mapping;
            ((OneToManyMapping)mappingClone).setSourceKeyFields(unidirectionalOneToManyMapping.getSourceKeyFields());
            ((OneToManyMapping)mappingClone).setTargetForeignKeyFields(unidirectionalOneToManyMapping.getTargetForeignKeyFields());
        }
        for (DatabaseMapping databaseMapping : this.mapsIdMappings) {
            mapping = clonedDescriptor.getMappingForAttributeName(databaseMapping.getAttributeName());
            if (mapping == null) continue;
            mapping.setIsReadOnly(true);
        }
        if (this.isNullAllowed && this.getReferenceDescriptor().hasTargetForeignKeyMapping(session)) {
            this.isNullAllowed = false;
            session.log(6, "metadata", "metadata_warning_ignore_is_null_allowed", new Object[]{this});
        }
        this.initializeReferenceDescriptor(clonedDescriptor, referenceSession);
        this.translateNestedFields(clonedDescriptor, referenceSession);
        clonedDescriptor.preInitialize(referenceSession);
        clonedDescriptor.initialize(referenceSession);
        Iterator<Object> iterator = this.converters.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String attr = string = (String)iterator.next();
            ClassDescriptor desc = clonedDescriptor;
            while (attr.contains(".")) {
                desc = desc.getMappingForAttributeName(attr.substring(0, attr.indexOf("."))).getReferenceDescriptor();
                attr = attr.substring(attr.indexOf(".") + 1);
            }
            DatabaseMapping mapping2 = desc.getMappingForAttributeName(attr);
            if (mapping2 == null) continue;
            this.converters.get(string).initialize(mapping2, session);
        }
        this.translateFields(clonedDescriptor, referenceSession);
        if (clonedDescriptor.hasInheritance() && clonedDescriptor.getInheritancePolicy().hasChildren()) {
            this.initializeChildInheritance(clonedDescriptor, referenceSession);
        }
        this.setFields(this.collectFields());
        if (clonedDescriptor.hasPreDeleteMappings()) {
            this.getDescriptor().addPreDeleteMapping(this);
        }
    }

    public void initializeChildInheritance(ClassDescriptor parentDescriptor, AbstractSession session) throws DescriptorException {
        if (parentDescriptor.getInheritancePolicy().hasChildren()) {
            List<ClassDescriptor> childDescriptors = parentDescriptor.getInheritancePolicy().getChildDescriptors();
            ArrayList<ClassDescriptor> cloneChildDescriptors = new ArrayList<ClassDescriptor>();
            for (ClassDescriptor child : childDescriptors) {
                ClassDescriptor clonedChildDescriptor = (ClassDescriptor)child.clone();
                clonedChildDescriptor.getInheritancePolicy().setParentDescriptor(parentDescriptor);
                this.initializeReferenceDescriptor(clonedChildDescriptor, session);
                clonedChildDescriptor.preInitialize(session);
                clonedChildDescriptor.initialize(session);
                this.translateFields(clonedChildDescriptor, session);
                cloneChildDescriptors.add(clonedChildDescriptor);
                this.initializeChildInheritance(clonedChildDescriptor, session);
            }
            parentDescriptor.getInheritancePolicy().setChildDescriptors(cloneChildDescriptors);
        }
    }

    public void initializeParentInheritance(ClassDescriptor parentDescriptor, ClassDescriptor childDescriptor, AbstractSession session) throws DescriptorException {
        ClassDescriptor clonedParentDescriptor = (ClassDescriptor)parentDescriptor.clone();
        if (clonedParentDescriptor.getInheritancePolicy().isChildDescriptor()) {
            ClassDescriptor parentToParentDescriptor = session.getDescriptor(clonedParentDescriptor.getJavaClass());
            this.initializeParentInheritance(parentToParentDescriptor, parentDescriptor, session);
        }
        this.initializeReferenceDescriptor(clonedParentDescriptor, session);
        NonSynchronizedVector children = NonSynchronizedVector.newInstance(1);
        ((Vector)children).addElement(childDescriptor);
        clonedParentDescriptor.getInheritancePolicy().setChildDescriptors(children);
        clonedParentDescriptor.preInitialize(session);
        clonedParentDescriptor.initialize(session);
        this.translateFields(clonedParentDescriptor, session);
    }

    protected void initializeReferenceDescriptor(ClassDescriptor clonedDescriptor, AbstractSession session) {
        if (this.aggregateKeyTable != null) {
            clonedDescriptor.setDefaultTable(this.aggregateKeyTable);
            Vector<DatabaseTable> tables = new Vector<DatabaseTable>(1);
            tables.add(this.aggregateKeyTable);
            clonedDescriptor.setTables(tables);
        } else {
            clonedDescriptor.setDefaultTable(this.getDescriptor().getDefaultTable());
            clonedDescriptor.setTables(this.getDescriptor().getTables());
            clonedDescriptor.setPrimaryKeyFields(this.getDescriptor().getPrimaryKeyFields());
            if (clonedDescriptor.hasTargetForeignKeyMapping(session) && !this.isJPAIdNested(session)) {
                for (DatabaseField pkField : this.getDescriptor().getPrimaryKeyFields()) {
                    if (this.getAggregateToSourceFields().containsKey(pkField.getName())) continue;
                    clonedDescriptor.getObjectBuilder().getFieldsMap().put(pkField, pkField);
                }
            }
        }
        if (this.getDescriptor().hasFetchGroupManager() && FetchGroupTracker.class.isAssignableFrom(clonedDescriptor.getJavaClass()) && clonedDescriptor.getFetchGroupManager() == null) {
            clonedDescriptor.setFetchGroupManager(new FetchGroupManager());
        }
    }

    @Override
    public void iterateOnMapKey(DescriptorIterator iterator, Object element) {
        super.iterateOnAttributeValue(iterator, element);
    }

    @Override
    public boolean isLockableMapping() {
        return true;
    }

    @Override
    public boolean isAggregateObjectMapping() {
        return true;
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        ClassDescriptor referencedDescriptor = this.getReferenceDescriptor();
        if (referencedDescriptor == null) {
            Iterator<ClassDescriptor> ordered = project.getOrderedDescriptors().iterator();
            while (ordered.hasNext() && referencedDescriptor == null) {
                ClassDescriptor descriptor = ordered.next();
                if (!descriptor.getJavaClassName().equals(this.getReferenceClassName())) continue;
                referencedDescriptor = descriptor;
            }
        }
        if (referencedDescriptor != null) {
            if (!referencedDescriptor.supportsChangeTracking(project)) {
                return false;
            }
            if (referencedDescriptor.hasInheritance()) {
                for (ClassDescriptor subclassDescriptor : referencedDescriptor.getInheritancePolicy().getChildDescriptors()) {
                    if (subclassDescriptor.supportsChangeTracking(project)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    public boolean isJPAIdNested(AbstractSession session) {
        if (this.isJPAId()) {
            return true;
        }
        ClassDescriptor referenceDescriptor = this.getReferenceDescriptor();
        if (referenceDescriptor == null) {
            referenceDescriptor = session.getDescriptor(this.getReferenceClass());
        }
        for (DatabaseMapping mapping : referenceDescriptor.getMappings()) {
            if (!mapping.isAggregateObjectMapping() || !((AggregateObjectMapping)mapping).isJPAIdNested(session)) continue;
            return true;
        }
        return false;
    }

    public boolean isNullAllowed() {
        return this.isNullAllowed;
    }

    @Override
    public void postInitialize(AbstractSession session) throws DescriptorException {
        super.postInitialize(session);
        if (this.getReferenceDescriptor() != null) {
            this.getReferenceDescriptor().getCachePolicy().setCacheIsolation(this.descriptor.getCachePolicy().getCacheIsolation());
            if (this.getDescriptor().getObjectChangePolicy().getClass().equals(DeferredChangeDetectionPolicy.class)) {
                this.getReferenceDescriptor().setObjectChangePolicy(new DeferredChangeDetectionPolicy());
            } else if (this.getDescriptor().getObjectChangePolicy().getClass().equals(ObjectChangeTrackingPolicy.class) && this.getReferenceDescriptor().getObjectChangePolicy().getClass().equals(AttributeChangeTrackingPolicy.class)) {
                this.getReferenceDescriptor().setObjectChangePolicy(new ObjectChangeTrackingPolicy());
            }
            if (this.getReferenceDescriptor().isAggregateDescriptor()) {
                this.getReferenceDescriptor().getObjectBuilder().setPrimaryKeyClassifications(this.getDescriptor().getObjectBuilder().getPrimaryKeyClassifications());
                this.getReferenceDescriptor().setHasSimplePrimaryKey(this.getDescriptor().hasSimplePrimaryKey());
            }
            this.getReferenceDescriptor().postInitialize(session);
        }
    }

    @Override
    public void preinitializeMapKey(DatabaseTable table) {
        this.setTableForAggregateMappingKey(table);
    }

    @Override
    public void postInitializeMapKey(MappedKeyMapContainerPolicy policy) {
    }

    public Object readFromReturnRowIntoObject(AbstractRecord row, Object targetObject, ReadObjectQuery query, Collection handledMappings, ObjectChangeSet changeSet) throws DatabaseException {
        Object aggregate = this.getAttributeValueFromObject(targetObject);
        ObjectChangeSet aggregateChangeSet = null;
        if (aggregate == null) {
            aggregate = this.readFromRowIntoObject(row, null, targetObject, null, query, query.getSession(), true);
        } else {
            if (changeSet != null && (!changeSet.isNew() || query.getDescriptor() != null && query.getDescriptor().shouldUseFullChangeSetsForNewObjects())) {
                aggregateChangeSet = this.getReferenceDescriptor(aggregate, query.getSession()).getObjectBuilder().createObjectChangeSet(aggregate, (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet(), true, query.getSession());
            }
            DatabaseRecord aggregateRow = new DatabaseRecord();
            int size = row.size();
            Vector<DatabaseField> fields = row.getFields();
            Vector values = row.getValues();
            Vector<DatabaseField> aggregateFields = this.getReferenceFields();
            int i = 0;
            while (i < size) {
                DatabaseField field = (DatabaseField)fields.get(i);
                if (aggregateFields.contains(field)) {
                    aggregateRow.add(field, values.get(i));
                }
                ++i;
            }
            this.getObjectBuilder(aggregate, query.getSession()).assignReturnRow(aggregate, query.getSession(), aggregateRow, aggregateChangeSet);
        }
        if (aggregate != null && this.isNullAllowed()) {
            boolean allAttributesNull = true;
            int nAggregateFields = this.fields.size();
            int i = 0;
            while (i < nAggregateFields && allAttributesNull) {
                DatabaseField field = (DatabaseField)this.fields.elementAt(i);
                if (row.containsKey(field)) {
                    allAttributesNull = row.get(field) == null;
                } else {
                    Object fieldValue = this.valueFromObject(targetObject, field, query.getSession());
                    if (fieldValue == null) {
                        Object baseValue = this.getDescriptor().getObjectBuilder().getBaseValueForField(field, targetObject);
                        if (baseValue != null) {
                            AbstractTransformationMapping transMapping;
                            DatabaseMapping baseMapping = this.getDescriptor().getObjectBuilder().getBaseMappingForField(field);
                            if (baseMapping.isForeignReferenceMapping()) {
                                ForeignReferenceMapping refMapping = (ForeignReferenceMapping)baseMapping;
                                if (refMapping.usesIndirection()) {
                                    allAttributesNull = refMapping.getIndirectionPolicy().objectIsInstantiated(baseValue);
                                }
                            } else if (baseMapping.isTransformationMapping() && (transMapping = (AbstractTransformationMapping)baseMapping).usesIndirection()) {
                                allAttributesNull = transMapping.getIndirectionPolicy().objectIsInstantiated(baseValue);
                            }
                        }
                    } else {
                        allAttributesNull = false;
                    }
                }
                ++i;
            }
            if (allAttributesNull) {
                aggregate = null;
                this.setAttributeValueInObject(targetObject, aggregate);
            }
        }
        if (changeSet != null && (!changeSet.isNew() || query.getDescriptor() != null && query.getDescriptor().shouldUseFullChangeSetsForNewObjects())) {
            AggregateChangeRecord record = (AggregateChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
            if (aggregate == null) {
                if (record != null) {
                    record.setChangedObject(null);
                }
            } else {
                if (record == null) {
                    record = new AggregateChangeRecord(changeSet);
                    record.setAttribute(this.getAttributeName());
                    record.setMapping(this);
                    changeSet.addChange(record);
                }
                if (aggregateChangeSet == null) {
                    aggregateChangeSet = this.getReferenceDescriptor(aggregate, query.getSession()).getObjectBuilder().createObjectChangeSet(aggregate, (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet(), true, query.getSession());
                }
                record.setChangedObject(aggregateChangeSet);
            }
        }
        if (handledMappings != null) {
            handledMappings.add(this);
        }
        return aggregate;
    }

    @Override
    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, CacheKey parentCacheKey, ObjectBuildingQuery sourceQuery, AbstractSession executionSession, boolean isTargetProtected) throws DatabaseException {
        Object aggregate = this.buildAggregateFromRow(databaseRow, targetObject, parentCacheKey, joinManager, sourceQuery, false, executionSession, isTargetProtected);
        this.setAttributeValueInObject(targetObject, aggregate);
        return aggregate;
    }

    @Override
    public void rehashFieldDependancies(AbstractSession session) {
        this.getReferenceDescriptor().rehashFieldDependancies(session);
    }

    @Override
    public boolean requiresDataModificationEventsForMapKey() {
        if (this.getReferenceDescriptor() != null) {
            for (DatabaseMapping mapping : this.getReferenceDescriptor().getMappings()) {
                if (mapping.isReadOnly()) continue;
                for (DatabaseField field : mapping.getFields()) {
                    if (!field.isUpdatable()) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void setAggregateToSourceFieldAssociations(Vector<Association> fieldAssociations) {
        Hashtable<String, DatabaseField> fieldNames = new Hashtable<String, DatabaseField>(fieldAssociations.size() + 1);
        Enumeration<Association> associationsEnum = fieldAssociations.elements();
        while (associationsEnum.hasMoreElements()) {
            Association association = associationsEnum.nextElement();
            fieldNames.put((String)association.getKey(), (DatabaseField)association.getValue());
        }
        this.setAggregateToSourceFields(fieldNames);
    }

    public void setAggregateToSourceFields(Map<String, DatabaseField> aggregateToSource) {
        this.aggregateToSourceFields = aggregateToSource;
    }

    public void setIsNullAllowed(boolean isNullAllowed) {
        this.isNullAllowed = isNullAllowed;
    }

    public void setTableForAggregateMappingKey(DatabaseTable table) {
        this.aggregateKeyTable = table;
    }

    protected void translateField(DatabaseField sourceField, DatabaseField mappingField, ClassDescriptor clonedDescriptor) {
        if (sourceField != null) {
            mappingField.setName(sourceField.getName());
            mappingField.setUseDelimiters(sourceField.shouldUseDelimiters());
            mappingField.useUpperCaseForComparisons(sourceField.getUseUpperCaseForComparisons());
            mappingField.setNameForComparisons(sourceField.getNameForComparisons());
            mappingField.setNullable(sourceField.isNullable());
            mappingField.setUpdatable(sourceField.isUpdatable());
            mappingField.setInsertable(sourceField.isInsertable());
            mappingField.setUnique(sourceField.isUnique());
            mappingField.setScale(sourceField.getScale());
            mappingField.setLength(sourceField.getLength());
            mappingField.setPrecision(sourceField.getPrecision());
            mappingField.setColumnDefinition(sourceField.getColumnDefinition());
            if (sourceField.hasTableName()) {
                mappingField.setTable(clonedDescriptor.getTable(sourceField.getTable().getName()));
            }
            mappingField.setIsTranslated(true);
        }
    }

    protected void translateNestedFields(ClassDescriptor clonedDescriptor, AbstractSession session) {
        if (this.nestedFieldTranslations == null) {
            return;
        }
        for (Map.Entry<String, Object[]> translations : this.nestedFieldTranslations.entrySet()) {
            String attributeName = translations.getKey();
            DatabaseMapping mapping = null;
            String currentAttributeName = attributeName.substring(0, attributeName.indexOf("."));
            String remainingAttributeName = attributeName.substring(attributeName.indexOf(".") + 1);
            mapping = clonedDescriptor.getMappingForAttributeName(currentAttributeName);
            if (!mapping.isAggregateObjectMapping()) continue;
            if (remainingAttributeName != null && remainingAttributeName.contains(".")) {
                ((AggregateObjectMapping)mapping).addNestedFieldTranslation(remainingAttributeName, (DatabaseField)translations.getValue()[0], (String)translations.getValue()[1]);
                continue;
            }
            ((AggregateObjectMapping)mapping).addFieldTranslation((DatabaseField)translations.getValue()[0], (String)translations.getValue()[1]);
        }
    }

    protected void translateFields(ClassDescriptor clonedDescriptor, AbstractSession session) {
        Vector fieldsToTranslate = (Vector)clonedDescriptor.getFields().clone();
        for (QueryKey queryKey : clonedDescriptor.getQueryKeys().values()) {
            if (!queryKey.isDirectQueryKey()) continue;
            DatabaseField field = ((DirectQueryKey)queryKey).getField();
            fieldsToTranslate.add(field);
        }
        if (!clonedDescriptor.getObjectBuilder().isSimple()) {
            for (DatabaseMapping mapping : clonedDescriptor.getMappings()) {
                Collection fkFields;
                if (!mapping.isForeignReferenceMapping() || (fkFields = ((ForeignReferenceMapping)mapping).getFieldsForTranslationInAggregate()) == null || fkFields.isEmpty()) continue;
                fieldsToTranslate.addAll(fkFields);
            }
        }
        for (DatabaseField field : fieldsToTranslate) {
            this.translateField(this.getAggregateToSourceFields().get(field.getName()), field, clonedDescriptor);
        }
        clonedDescriptor.rehashFieldDependancies(session);
    }

    @Override
    public Object unwrapKey(Object key, AbstractSession session) {
        return key;
    }

    @Override
    public Object wrapKey(Object key, AbstractSession session) {
        return key;
    }

    @Override
    public void writeFromAttributeIntoRow(Object attribute, AbstractRecord row, AbstractSession session) {
        this.writeToRowFromAggregate(row, null, attribute, session, DatabaseMapping.WriteType.UNDEFINED);
    }

    @Override
    public Object valueFromObject(Object object, DatabaseField field, AbstractSession session) throws DescriptorException {
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            if (this.isNullAllowed()) {
                return null;
            }
            throw DescriptorException.nullForNonNullAggregate(object, this);
        }
        return this.getObjectBuilder(attributeValue, session).extractValueFromObjectForField(attributeValue, field, session);
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord databaseRow, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        this.writeToRowFromAggregate(databaseRow, object, this.getAttributeValueFromObject(object), session, writeType);
    }

    @Override
    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord row, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        this.writeToRowFromAggregateForShallowInsert(row, object, this.getAttributeValueFromObject(object), session);
    }

    @Override
    public void writeFromObjectIntoRowForUpdateAfterShallowInsert(Object object, AbstractRecord row, AbstractSession session, DatabaseTable table) {
        if (this.isReadOnly() || !this.getFields().get(0).getTable().equals(table) || this.isPrimaryKeyMapping()) {
            return;
        }
        this.writeToRowFromAggregateForUpdateAfterShallowInsert(row, object, this.getAttributeValueFromObject(object), session, table);
    }

    @Override
    public void writeFromObjectIntoRowForUpdateBeforeShallowDelete(Object object, AbstractRecord row, AbstractSession session, DatabaseTable table) {
        if (this.isReadOnly() || !this.getFields().get(0).getTable().equals(table) || this.isPrimaryKeyMapping()) {
            return;
        }
        this.writeToRowFromAggregateForUpdateBeforeShallowDelete(row, object, this.getAttributeValueFromObject(object), session, table);
    }

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord databaseRow, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        this.writeToRowFromAggregateWithChangeRecord(databaseRow, changeRecord, (ObjectChangeSet)((AggregateChangeRecord)changeRecord).getChangedObject(), session, writeType);
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery query, AbstractRecord databaseRow) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        this.writeToRowFromAggregateForUpdate(databaseRow, query, this.getAttributeValueFromObject(query.getObject()));
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord databaseRow, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        AbstractRecord targetRow = this.buildTemplateInsertRow(session);
        Enumeration keyEnum = targetRow.keys();
        while (keyEnum.hasMoreElements()) {
            DatabaseField field = (DatabaseField)keyEnum.nextElement();
            Object value = targetRow.get(field);
            databaseRow.add(field, value);
        }
    }

    public void addPrimaryKeyJoinField(DatabaseField primaryKeyField, DatabaseField secondaryField) {
        ObjectBuilder builder = this.getReferenceDescriptor().getObjectBuilder();
        DatabaseMapping mapping = builder.getMappingForField(primaryKeyField);
        if (mapping != null) {
            builder.getMappingsByField().put(secondaryField, mapping);
        }
    }
}

