/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.ui.libraries;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.javascript.bower.ui.libraries.Bundle;
import org.netbeans.modules.javascript.bower.ui.libraries.Dependency;
import org.netbeans.modules.javascript.bower.ui.libraries.EditPanel;
import org.netbeans.modules.javascript.bower.ui.libraries.Library;
import org.netbeans.modules.javascript.bower.ui.libraries.LibraryProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SearchPanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(SearchPanel.class);
    private final Listener listener = new Listener();
    private String lastSearchTerm;
    private final LibraryProvider libraryProvider;
    private Library selectedLibrary;
    private final Map<String, Library> libraryDetailCache = new HashMap<String, Library>();
    private JButton addButton;
    private JToggleButton alphabeticalSortButton;
    private JButton cancelButton;
    private JLabel descriptionComponent;
    private JLabel descriptionLabel;
    private EditPanel editPanel;
    private JLabel homePageLabel;
    private JLabel homePageLinkLabel;
    private JLabel keywordsComponent;
    private JLabel keywordsLabel;
    private JLabel librariesLabel;
    private JList<Library> librariesList;
    private JLabel loadingLabel;
    private JLabel messageLabel;
    private JToggleButton popularitySortButton;
    private JScrollPane scrollPane;
    private JButton searchButton;
    private JTextField searchField;
    private JLabel searchLabel;
    private JPanel searchPanel;
    private ButtonGroup sortButtonGroup;

    public SearchPanel(LibraryProvider libraryProvider) {
        this.libraryProvider = libraryProvider;
        this.initComponents();
        this.editPanel.setLibraryProvider(libraryProvider);
        this.librariesList.setCellRenderer(new LibraryRenderer());
        this.updateLibraries(new Library[0]);
        this.librarySelected(null);
    }

    final void activate() {
        this.libraryProvider.addPropertyChangeListener(this.listener);
    }

    final void deactivate() {
        this.libraryProvider.removePropertyChangeListener(this.listener);
    }

    String getSelectedLibrary() {
        Library library = this.librariesList.getSelectedValue();
        return library == null ? null : library.getName();
    }

    String getRequiredVersion() {
        return this.editPanel.getRequiredVersion();
    }

    String getInstalledVersion() {
        return this.editPanel.getInstalledVersion();
    }

    private void startSearch() {
        this.librarySelected(null);
        this.lastSearchTerm = this.searchField.getText().trim();
        Library[] libraries = this.libraryProvider.findLibraries(this.lastSearchTerm);
        if (libraries == null) {
            this.messageLabel.setText(Bundle.SearchPanel_message_searching(this.lastSearchTerm));
            this.showComponent(this.messageLabel);
        } else {
            this.updateLibraries(libraries);
        }
    }

    private void showComponent(JComponent component) {
        if (component.getParent() == null) {
            JComponent shownComponent = component == this.messageLabel ? this.searchPanel : this.messageLabel;
            ((GroupLayout)this.getLayout()).replace(shownComponent, component);
        }
    }

    final void updateLibraries(Library[] libraries) {
        if (libraries == null) {
            this.messageLabel.setText(Bundle.SearchPanel_message_searchFailed());
            this.showComponent(this.messageLabel);
        } else if (libraries.length == 0) {
            this.messageLabel.setText(NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.messageLabel.text"));
            this.showComponent(this.messageLabel);
        } else {
            this.librariesList.setModel(this.libraryListModelFor(libraries));
            this.librariesList.setSelectedIndex(0);
            this.showComponent(this.searchPanel);
            this.librariesList.requestFocusInWindow();
        }
    }

    private ListModel<Library> libraryListModelFor(Library[] libraries) {
        Arrays.sort(libraries, this.alphabeticalSortButton.isSelected() ? new AlphabeticLibraryComparator() : new PopularityLibraryComparator());
        DefaultListModel<Library> listModel = new DefaultListModel<Library>();
        for (Library library : libraries) {
            listModel.addElement(library);
        }
        return listModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void librarySelected(Library library) {
        assert (EventQueue.isDispatchThread());
        SearchPanel searchPanel = this;
        synchronized (searchPanel) {
            if (this.selectedLibrary == library) {
                return;
            }
            this.selectedLibrary = library;
        }
        this.updateLibraryDetail(null, null);
        if (library == null) {
            return;
        }
        final String libraryName = library.getName();
        Library details = this.libraryProvider.libraryDetails(libraryName, true);
        if (details != null) {
            this.updateLibraryDetail(libraryName, details);
            return;
        }
        this.loadingLabel.setText(Bundle.SearchPanel_message_loadingDetail());
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String selectedLibraryName;
                SearchPanel searchPanel = SearchPanel.this;
                synchronized (searchPanel) {
                    selectedLibraryName = SearchPanel.this.selectedLibrary == null ? null : SearchPanel.this.selectedLibrary.getName();
                }
                if (libraryName.equals(selectedLibraryName)) {
                    final Library details = SearchPanel.this.libraryProvider.libraryDetails(libraryName, false);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SearchPanel.this.updateLibraryDetail(libraryName, details);
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLibraryDetail(String libraryName, Library libraryDetails) {
        assert (EventQueue.isDispatchThread());
        this.libraryDetailCache.put(libraryName, libraryDetails);
        SearchPanel searchPanel = this;
        synchronized (searchPanel) {
            if (libraryName != null && this.selectedLibrary != null && !libraryName.equals(this.selectedLibrary.getName())) {
                return;
            }
        }
        this.loadingLabel.setText(libraryName != null && libraryDetails == null ? Bundle.SearchPanel_message_loadingOfDetailFailed() : null);
        boolean emptySelection = libraryDetails == null;
        String description = null;
        String keywords = null;
        String homePage = null;
        boolean descriptionEnabled = true;
        if (!emptySelection) {
            if (libraryDetails.getDescription().isEmpty()) {
                description = Bundle.SearchPanel_nodeDescription();
                descriptionEnabled = false;
            } else {
                description = "<html>" + libraryDetails.getDescription();
            }
            if (libraryDetails.getKeywords().length > 0) {
                StringBuilder keywordsText = new StringBuilder("<html>");
                for (String keyword : libraryDetails.getKeywords()) {
                    keywordsText.append(keyword).append(" ");
                }
                keywords = keywordsText.toString();
            }
            Dependency dependency = new Dependency(libraryDetails.getName());
            Library.Version latestVersion = libraryDetails.getLatestVersion();
            if (latestVersion != null) {
                String versionName = latestVersion.getName();
                dependency.setInstalledVersion(versionName);
                dependency.setRequiredVersion(versionName);
            }
            this.editPanel.setDependency(dependency);
            homePage = libraryDetails.getHomePage();
        }
        this.descriptionComponent.setText(description);
        this.descriptionComponent.setVisible(description != null);
        this.descriptionComponent.setEnabled(descriptionEnabled);
        this.keywordsComponent.setText(keywords);
        this.keywordsComponent.setVisible(keywords != null);
        this.keywordsLabel.setVisible(keywords != null);
        this.editPanel.setVisible(!emptySelection);
        this.addButton.setEnabled(!emptySelection);
        this.homePageLinkLabel.setText(homePage);
        this.homePageLabel.setVisible(homePage != null);
        this.homePageLinkLabel.setVisible(homePage != null);
        this.updateHomePageLink(false);
    }

    JButton getAddButton() {
        return this.addButton;
    }

    JButton getCancelButton() {
        return this.cancelButton;
    }

    private String getHomePage() {
        String homePage = this.homePageLinkLabel.getText();
        if (homePage != null) {
            int index = homePage.lastIndexOf(62);
            homePage = homePage.substring(index + 1);
        }
        return homePage;
    }

    void updateHomePageLink(boolean linkVisible) {
        String homePage = this.getHomePage();
        if (homePage != null) {
            homePage = "<html>" + (linkVisible ? "<u>" : "") + homePage;
            this.homePageLinkLabel.setText(homePage);
        }
    }

    void updateLibraryOrder() {
        Library selected = this.librariesList.getSelectedValue();
        ListModel<Library> model = this.librariesList.getModel();
        Library[] libraries = new Library[model.getSize()];
        for (int i = 0; i < model.getSize(); ++i) {
            libraries[i] = model.getElementAt(i);
        }
        this.librariesList.setModel(this.libraryListModelFor(libraries));
        if (selected != null) {
            this.librariesList.setSelectedValue(selected, true);
        }
    }

    private void initComponents() {
        this.searchPanel = new JPanel();
        this.librariesLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.librariesList = new JList();
        this.descriptionLabel = new JLabel();
        this.descriptionComponent = new JLabel();
        this.keywordsLabel = new JLabel();
        this.keywordsComponent = new JLabel();
        this.editPanel = new EditPanel();
        this.loadingLabel = new JLabel();
        this.homePageLabel = new JLabel();
        this.homePageLinkLabel = new JLabel(){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                return new Dimension(0, dim.height);
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.popularitySortButton = new JToggleButton();
        this.alphabeticalSortButton = new JToggleButton();
        this.addButton = new JButton();
        this.cancelButton = new JButton();
        this.sortButtonGroup = new ButtonGroup();
        this.searchLabel = new JLabel();
        this.searchField = new JTextField();
        this.searchButton = new JButton();
        this.messageLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.librariesLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.librariesLabel.text"));
        this.librariesList.setSelectionMode(0);
        this.librariesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SearchPanel.this.librariesListValueChanged(evt);
            }
        });
        this.scrollPane.setViewportView(this.librariesList);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.descriptionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.keywordsLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.keywordsLabel.text"));
        this.loadingLabel.setHorizontalAlignment(0);
        this.loadingLabel.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.homePageLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.homePageLabel.text"));
        this.homePageLinkLabel.setCursor(new Cursor(12));
        this.homePageLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchPanel.this.homePageLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchPanel.this.homePageLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchPanel.this.homePageLinkLabelMouseExited(evt);
            }
        });
        this.sortButtonGroup.add(this.popularitySortButton);
        this.popularitySortButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/javascript/bower/ui/resources/popularity-sort.png")));
        this.popularitySortButton.setSelected(true);
        this.popularitySortButton.setToolTipText(NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.popularitySortButton.toolTipText"));
        this.popularitySortButton.setFocusPainted(false);
        this.popularitySortButton.setMargin(new Insets(0, 0, 0, 0));
        this.popularitySortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.popularitySortButtonActionPerformed(evt);
            }
        });
        this.sortButtonGroup.add(this.alphabeticalSortButton);
        this.alphabeticalSortButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/javascript/bower/ui/resources/alphabetic-sort.png")));
        this.alphabeticalSortButton.setToolTipText(NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.alphabeticalSortButton.toolTipText"));
        this.alphabeticalSortButton.setFocusPainted(false);
        this.alphabeticalSortButton.setMargin(new Insets(0, 0, 0, 0));
        this.alphabeticalSortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.alphabeticalSortButtonActionPerformed(evt);
            }
        });
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.scrollPane, -2, 250, -2).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.librariesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.alphabeticalSortButton).addGap(0, 0, 0).addComponent(this.popularitySortButton))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.descriptionComponent, -1, -1, Short.MAX_VALUE).addComponent(this.keywordsLabel, -1, -1, Short.MAX_VALUE).addComponent(this.keywordsComponent, -1, -1, Short.MAX_VALUE).addComponent(this.editPanel, -1, -1, Short.MAX_VALUE).addComponent(this.loadingLabel, -1, -1, Short.MAX_VALUE).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.homePageLabel).addComponent(this.homePageLinkLabel)).addGap(0, 0, Short.MAX_VALUE)))));
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.librariesLabel).addComponent(this.descriptionLabel).addComponent(this.popularitySortButton).addComponent(this.alphabeticalSortButton)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.descriptionComponent).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.keywordsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keywordsComponent).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.homePageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.homePageLinkLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.editPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadingLabel, -1, -1, Short.MAX_VALUE))).addGap(0, 0, 0)));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.addButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.cancelButton.text"));
        this.searchLabel.setLabelFor(this.searchField);
        Mnemonics.setLocalizedText((JLabel)this.searchLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.searchLabel.text"));
        this.searchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.searchFieldActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.searchButtonActionPerformed(evt);
            }
        });
        this.messageLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.messageLabel.text"));
        this.messageLabel.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel, -1, 550, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.searchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchLabel).addComponent(this.searchField, -2, -1, -2).addComponent(this.searchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messageLabel, -1, 350, Short.MAX_VALUE).addContainerGap()));
    }

    private void searchFieldActionPerformed(ActionEvent evt) {
        this.startSearch();
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.startSearch();
    }

    private void librariesListValueChanged(ListSelectionEvent evt) {
        Library library = this.librariesList.getSelectedValue();
        this.librarySelected(library);
    }

    private void homePageLinkLabelMouseEntered(MouseEvent evt) {
        this.updateHomePageLink(true);
    }

    private void homePageLinkLabelMouseExited(MouseEvent evt) {
        this.updateHomePageLink(false);
    }

    private void homePageLinkLabelMouseClicked(MouseEvent evt) {
        try {
            URI uri = new URI(this.getHomePage());
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException | URISyntaxException ex) {
            Logger.getLogger(SearchPanel.class.getName()).log(Level.INFO, null, ex);
        }
    }

    private void popularitySortButtonActionPerformed(ActionEvent evt) {
        this.updateLibraryOrder();
    }

    private void alphabeticalSortButtonActionPerformed(ActionEvent evt) {
        this.updateLibraryOrder();
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="No need to be serializable")
    static class PopularityLibraryComparator
    implements Comparator<Library> {
        PopularityLibraryComparator() {
        }

        @Override
        public int compare(Library library1, Library library2) {
            return library2.getPopularity() - library1.getPopularity();
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="No need to be serializable")
    static class AlphabeticLibraryComparator
    implements Comparator<Library> {
        AlphabeticLibraryComparator() {
        }

        @Override
        public int compare(Library library1, Library library2) {
            return library1.getName().compareTo(library2.getName());
        }
    }

    static class LibraryRenderer
    extends DefaultListCellRenderer {
        LibraryRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Library) {
                Library library = (Library)value;
                value = library.getName();
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    class Listener
    implements PropertyChangeListener {
        Listener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String searchTerm = evt.getPropertyName();
                    if (searchTerm.equals(SearchPanel.this.lastSearchTerm)) {
                        Library[] libraries = (Library[])evt.getNewValue();
                        SearchPanel.this.updateLibraries(libraries);
                    }
                }
            });
        }
    }
}

