/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import org.openide.util.VectorIcon;

final class Windows8VectorCloseButton
extends VectorIcon {
    public static final Icon DEFAULT = new Windows8VectorCloseButton(false);
    public static final Icon PRESSED = new Windows8VectorCloseButton(true);
    private final boolean pressed;

    private Windows8VectorCloseButton(boolean pressed) {
        super(14, 14);
        this.pressed = pressed;
    }

    protected void paintIcon(Component c, Graphics2D g, int width, int height, double scaling) {
        if (this.pressed) {
            g.setColor(new Color(199, 79, 80, 255));
            g.fillRect(0, 0, width, height);
        }
        g.setColor(this.pressed ? Color.WHITE : new Color(86, 86, 86, 255));
        if (this.getIconWidth() == width && this.getIconHeight() == height) {
            Windows8VectorCloseButton.setAntiAliasing((Graphics2D)g, (boolean)false);
        }
        double strokeWidth = (this.pressed ? 1.0 : 0.8) * scaling;
        if (scaling > 1.0) {
            strokeWidth *= 1.5;
        }
        double marginX = 3.5 * scaling;
        int topMarginY = Windows8VectorCloseButton.round((double)(3.0 * scaling));
        int botMarginY = Windows8VectorCloseButton.round((double)(4.0 * scaling));
        g.clip(new Rectangle2D.Double(0.0, topMarginY, width, height - topMarginY - botMarginY));
        g.setStroke(new BasicStroke((float)strokeWidth));
        g.draw(new Line2D.Double(marginX, topMarginY, (double)width - marginX, height - botMarginY));
        g.draw(new Line2D.Double((double)width - marginX, topMarginY, marginX, height - botMarginY));
    }
}

