/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.charset.Charset;
import java.util.Map;
import org.netbeans.modules.netserver.websocket.Utils;
import org.netbeans.modules.netserver.websocket.WebSocketChanelHandler;
import org.netbeans.modules.netserver.websocket.WebSocketHandler75;
import org.netbeans.modules.netserver.websocket.WebSocketServerImpl;

class WebSocketHandler76
extends WebSocketHandler75
implements WebSocketChanelHandler {
    public WebSocketHandler76(WebSocketServerImpl webSocketServer, SelectionKey key) {
        super(webSocketServer, key);
    }

    @Override
    public void sendHandshake() throws IOException {
        byte[] lastEightBytes = this.readRequestContent();
        if (lastEightBytes == null) {
            throw new IOException("Invalid handshake. Cannot read handshake content");
        }
        StringBuilder builder = new StringBuilder("HTTP/1.1 101 Web Socket Protocol Handshake");
        builder.append("\r\n");
        builder.append("Upgrade: WebSocket");
        builder.append("\r\n");
        builder.append("Connection: Upgrade");
        builder.append("\r\n");
        builder.append("Sec-WebSocket-Origin: ");
        String origin = ((WebSocketServerImpl)this.getWebSocketPoint()).getContext(this.getKey()).getHeaders().get("Origin");
        if (origin != null) {
            builder.append(origin);
        }
        builder.append("\r\n");
        builder.append("Sec-WebSocket-Location: ws://");
        String host = ((WebSocketServerImpl)this.getWebSocketPoint()).getContext(this.getKey()).getHeaders().get("Host");
        if (host != null) {
            builder.append(host);
        } else {
            builder.append("127.0.0.1:");
            builder.append(((InetSocketAddress)((WebSocketServerImpl)this.getWebSocketPoint()).getAddress()).getPort());
        }
        String request = ((WebSocketServerImpl)this.getWebSocketPoint()).getContext(this.getKey()).getRequestString();
        int index = request.indexOf(32);
        String url = null;
        if (index != -1) {
            if ((index = (request = request.substring(index).trim()).indexOf(32)) != -1) {
                url = request.substring(0, index).trim();
            }
        } else {
            url = "/";
        }
        builder.append(url);
        builder.append("\r\n");
        builder.append("\r\n");
        byte[] headers = builder.toString().getBytes(Charset.forName("UTF-8"));
        byte[] responseContent = this.createResponseContent(this.getKey(), lastEightBytes);
        if (responseContent == null) {
            this.close();
            return;
        }
        byte[] response = new byte[headers.length + responseContent.length];
        System.arraycopy(headers, 0, response, 0, headers.length);
        System.arraycopy(responseContent, 0, response, headers.length, responseContent.length);
        ((WebSocketServerImpl)this.getWebSocketPoint()).send(response, this.getKey());
    }

    private byte[] createResponseContent(SelectionKey key, byte[] lastEightBytes) {
        Map<String, String> headers = ((WebSocketServerImpl)this.getWebSocketPoint()).getContext(key).getHeaders();
        String key1 = headers.get("Sec-WebSocket-Key1");
        String key2 = headers.get("Sec-WebSocket-Key2");
        return Utils.produceChallenge76(key1, key2, lastEightBytes);
    }

    private byte[] readRequestContent() throws IOException {
        byte[] content = ((WebSocketServerImpl)this.getWebSocketPoint()).getContext(this.getKey()).getContent();
        boolean red = false;
        for (byte b : content) {
            if (b == 0) continue;
            red = true;
            break;
        }
        if (red) {
            return content;
        }
        return this.readRequestContent(8);
    }
}

