/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LexicalContextNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.ArrayList;
import java.util.List;

public abstract class Node
implements Cloneable {
    protected final int start;
    protected final int finish;
    private final long token;

    public Node(long l, int n) {
        this.token = l;
        this.start = Token.descPosition(l);
        this.finish = n;
    }

    protected Node(long l, int n, int n2) {
        this.start = n;
        this.finish = n2;
        this.token = l;
    }

    protected Node(Node node) {
        this.token = node.token;
        this.start = node.start;
        this.finish = node.finish;
    }

    protected Node(Node node, int n) {
        this.token = node.token;
        this.start = node.start;
        this.finish = n;
    }

    public boolean isLoop() {
        return false;
    }

    public boolean isAssignment() {
        return false;
    }

    public abstract Node accept(NodeVisitor<? extends LexicalContext> var1);

    public abstract <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> var1);

    public final String toString() {
        return this.toString(true);
    }

    public final String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, bl);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        this.toString(stringBuilder, true);
    }

    public abstract void toString(StringBuilder var1, boolean var2);

    public int getFinish() {
        return this.finish;
    }

    public int getStart() {
        return this.start;
    }

    public int getSourceOrder() {
        return this.getStart();
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return Long.hashCode(this.token);
    }

    public int position() {
        return Token.descPosition(this.token);
    }

    public int length() {
        return Token.descLength(this.token);
    }

    public TokenType tokenType() {
        return Token.descType(this.token);
    }

    public boolean isTokenType(TokenType tokenType) {
        return this.tokenType() == tokenType;
    }

    public long getToken() {
        return this.token;
    }

    static <T extends Node> List<T> accept(NodeVisitor<? extends LexicalContext> nodeVisitor, List<T> list) {
        int n = list.size();
        if (n == 0) {
            return list;
        }
        ArrayList<Node> arrayList = null;
        for (int i = 0; i < n; ++i) {
            Node node;
            Node node2 = (Node)list.get(i);
            Node node3 = node = node2 == null ? null : node2.accept(nodeVisitor);
            if (node != node2) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Node>(n);
                    for (int j = 0; j < i; ++j) {
                        arrayList.add((Node)list.get(j));
                    }
                }
                arrayList.add(node);
                continue;
            }
            if (arrayList == null) continue;
            arrayList.add(node2);
        }
        return arrayList == null ? list : arrayList;
    }

    static <T extends LexicalContextNode> T replaceInLexicalContext(LexicalContext lexicalContext, T t, T t2) {
        if (lexicalContext != null) {
            lexicalContext.replace(t, t2);
        }
        return t2;
    }
}

