/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class ArrowFunctionDeclaration
extends Expression {
    private final boolean isReference;
    private final boolean isStatic;
    private final List<FormalParameter> formalParameters = new ArrayList<FormalParameter>();
    @NullAllowed
    private final Expression returnType;
    private final Expression expression;

    public ArrowFunctionDeclaration(int start, int end, List formalParameters, Expression returnType, Expression expression, boolean isReference, boolean isStatic) {
        super(start, end);
        if (formalParameters == null) {
            throw new IllegalArgumentException();
        }
        this.isReference = isReference;
        this.isStatic = isStatic;
        this.formalParameters.addAll(formalParameters);
        this.returnType = returnType;
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<FormalParameter> getFormalParameters() {
        return Collections.unmodifiableList(this.formalParameters);
    }

    @CheckForNull
    public Expression getReturnType() {
        return this.returnType;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sbParams = new StringBuilder();
        this.getFormalParameters().forEach(param -> sbParams.append(param).append(","));
        return (this.isStatic() ? "static " : " ") + "fn" + (this.isReference() ? " & " : "") + "(" + sbParams.toString() + ")" + (this.getReturnType() != null ? ": " + this.getReturnType() : "") + " => " + this.getExpression();
    }
}

