/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class NSDate
extends NSObject {
    private Date date;
    private static final long EPOCH = 978307200000L;
    private static final SimpleDateFormat sdfDefault = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat sdfGnuStep = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    private static synchronized Date parseDateString(String textRepresentation) throws ParseException {
        try {
            return sdfDefault.parse(textRepresentation);
        }
        catch (ParseException ex) {
            return sdfGnuStep.parse(textRepresentation);
        }
    }

    private static synchronized String makeDateString(Date date) {
        return sdfDefault.format(date);
    }

    private static synchronized String makeDateStringGnuStep(Date date) {
        return sdfGnuStep.format(date);
    }

    public NSDate(byte[] bytes) {
        this.date = new Date(978307200000L + (long)(1000.0 * BinaryPropertyListParser.parseDouble(bytes)));
    }

    public NSDate(String textRepresentation) throws ParseException {
        this.date = NSDate.parseDateString(textRepresentation);
    }

    public NSDate(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("Date cannot be null");
        }
        this.date = d;
    }

    public Date getDate() {
        return this.date;
    }

    public boolean equals(Object obj) {
        return obj.getClass().equals(this.getClass()) && this.date.equals(((NSDate)obj).getDate());
    }

    public int hashCode() {
        return this.date.hashCode();
    }

    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        xml.append("<date>");
        xml.append(NSDate.makeDateString(this.date));
        xml.append("</date>");
    }

    public void toBinary(BinaryPropertyListWriter out) throws IOException {
        out.write(51);
        out.writeDouble((double)(this.date.getTime() - 978307200000L) / 1000.0);
    }

    public String toString() {
        return this.date.toString();
    }

    protected void toASCII(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append("\"");
        ascii.append(NSDate.makeDateString(this.date));
        ascii.append("\"");
    }

    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append("<*D");
        ascii.append(NSDate.makeDateStringGnuStep(this.date));
        ascii.append(">");
    }

    static {
        sdfDefault.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdfGnuStep.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

