/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.analyzer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.options.ValidatorPHPStanParameter;
import org.netbeans.modules.php.analysis.ui.PHPStanLevelListCellRenderer;
import org.netbeans.modules.php.analysis.ui.analyzer.Bundle;
import org.netbeans.modules.php.analysis.ui.options.PHPStanOptionsPanel;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;

public class PHPStanCustomizerPanel
extends JPanel {
    public static final String ENABLED = "phpStan.enabled";
    public static final String LEVEL = "phpStan.level";
    public static final String CONFIGURATION = "phpStan.configuration";
    public static final String MEMORY_LIMIT = "phpStan.memory.limit";
    private static final String PHPSTAN_CONFIGURATION_LAST_FOLDER_SUFFIX = ".phpstan.config";
    private static final long serialVersionUID = 2318201027384364349L;
    final Analyzer.CustomizerContext<Void, PHPStanCustomizerPanel> context;
    final Preferences settings;
    private JButton phpStanConfigurationBrowseButton;
    private JLabel phpStanConfigurationLabel;
    private JTextField phpStanConfigurationTextField;
    private JCheckBox phpStanEnabledCheckBox;
    private JComboBox<String> phpStanLevelComboBox;
    private JLabel phpStanLevelLabel;
    private JLabel phpStanMemoryLimitLabel;
    private JTextField phpStanMemoryLimitTextField;

    public PHPStanCustomizerPanel(Analyzer.CustomizerContext<Void, PHPStanCustomizerPanel> context) {
        assert (EventQueue.isDispatchThread());
        assert (context != null);
        this.context = context;
        this.settings = context.getSettings();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setEnabledCheckBox();
        this.setLevelComboBox();
        this.setConfigurationTextField();
        this.setMemoryLimitTextField();
    }

    private void setEnabledCheckBox() {
        assert (EventQueue.isDispatchThread());
        this.phpStanEnabledCheckBox.addItemListener(e -> {
            this.setAllComponetsEnabled(this.phpStanEnabledCheckBox.isSelected());
            this.setPHPStanEnabled();
        });
        boolean isEnabled = this.settings.getBoolean(ENABLED, false);
        this.phpStanEnabledCheckBox.setSelected(isEnabled);
        this.setAllComponetsEnabled(isEnabled);
    }

    private void setLevelComboBox() {
        assert (EventQueue.isDispatchThread());
        this.phpStanLevelComboBox.removeAllItems();
        this.phpStanLevelComboBox.addItem("");
        for (int i = AnalysisOptions.PHPSTAN_MIN_LEVEL; i <= AnalysisOptions.PHPSTAN_MAX_LEVEL; ++i) {
            this.phpStanLevelComboBox.addItem(String.valueOf(i));
        }
        this.phpStanLevelComboBox.addItem("max");
        this.phpStanLevelComboBox.setRenderer(new PHPStanLevelListCellRenderer(this.phpStanLevelComboBox.getRenderer()));
        this.phpStanLevelComboBox.setSelectedItem(this.getValidLevel());
        this.phpStanLevelComboBox.addItemListener(e -> this.setLevel());
    }

    private String getValidLevel() {
        String level = this.settings.get(LEVEL, AnalysisOptions.getInstance().getPHPStanLevel());
        return AnalysisOptions.getValidPHPStanLevel(level);
    }

    private void setConfigurationTextField() {
        assert (EventQueue.isDispatchThread());
        this.phpStanConfigurationTextField.setText(this.settings.get(CONFIGURATION, AnalysisOptions.getInstance().getPHPStanConfigurationPath()));
        this.phpStanConfigurationTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                PHPStanCustomizerPanel.this.setConfiguration();
            }
        });
    }

    private void setMemoryLimitTextField() {
        assert (EventQueue.isDispatchThread());
        this.phpStanMemoryLimitTextField.setText(this.settings.get(MEMORY_LIMIT, AnalysisOptions.getInstance().getPHPStanMemoryLimit()));
        this.phpStanMemoryLimitTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                PHPStanCustomizerPanel.this.setMemoryLimit();
            }
        });
    }

    public String getLevel() {
        return (String)this.phpStanLevelComboBox.getSelectedItem();
    }

    public String getConfiguration() {
        return this.phpStanConfigurationTextField.getText().trim();
    }

    public String getMemoryLimit() {
        return this.phpStanMemoryLimitTextField.getText().trim();
    }

    private void setPHPStanEnabled() {
        this.settings.putBoolean(ENABLED, this.phpStanEnabledCheckBox.isSelected());
    }

    private void setLevel() {
        this.settings.put(LEVEL, this.getLevel());
    }

    private void setConfiguration() {
        if (this.validateData()) {
            this.settings.put(CONFIGURATION, this.getConfiguration());
        }
    }

    private void setMemoryLimit() {
        if (this.validateData()) {
            this.settings.put(MEMORY_LIMIT, this.getMemoryLimit());
        }
    }

    private boolean validateData() {
        ValidatorPHPStanParameter param = ValidatorPHPStanParameter.create(this);
        ValidationResult result = new AnalysisOptionsValidator().validatePHPStan(param).getResult();
        if (result.hasErrors()) {
            this.context.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            this.context.setError(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return false;
        }
        this.context.setError(null);
        return true;
    }

    private void setAllComponetsEnabled(boolean isEnabled) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (component == this.phpStanEnabledCheckBox) continue;
            component.setEnabled(isEnabled);
        }
    }

    private void initComponents() {
        this.phpStanEnabledCheckBox = new JCheckBox();
        this.phpStanConfigurationLabel = new JLabel();
        this.phpStanConfigurationTextField = new JTextField();
        this.phpStanConfigurationBrowseButton = new JButton();
        this.phpStanLevelLabel = new JLabel();
        this.phpStanLevelComboBox = new JComboBox();
        this.phpStanMemoryLimitLabel = new JLabel();
        this.phpStanMemoryLimitTextField = new JTextField();
        Mnemonics.setLocalizedText((AbstractButton)this.phpStanEnabledCheckBox, (String)NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanEnabledCheckBox.text"));
        this.phpStanConfigurationLabel.setLabelFor(this.phpStanConfigurationTextField);
        Mnemonics.setLocalizedText((JLabel)this.phpStanConfigurationLabel, (String)NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanConfigurationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpStanConfigurationBrowseButton, (String)NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanConfigurationBrowseButton.text"));
        this.phpStanConfigurationBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PHPStanCustomizerPanel.this.phpStanConfigurationBrowseButtonActionPerformed(evt);
            }
        });
        this.phpStanLevelLabel.setLabelFor(this.phpStanLevelComboBox);
        Mnemonics.setLocalizedText((JLabel)this.phpStanLevelLabel, (String)NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanLevelLabel.text"));
        this.phpStanLevelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7"}));
        this.phpStanMemoryLimitLabel.setLabelFor(this.phpStanMemoryLimitTextField);
        Mnemonics.setLocalizedText((JLabel)this.phpStanMemoryLimitLabel, (String)NbBundle.getMessage(PHPStanCustomizerPanel.class, (String)"PHPStanCustomizerPanel.phpStanMemoryLimitLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpStanEnabledCheckBox).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpStanConfigurationLabel).addComponent(this.phpStanLevelLabel).addComponent(this.phpStanMemoryLimitLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpStanConfigurationTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpStanConfigurationBrowseButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpStanLevelComboBox, -2, -1, -2).addComponent(this.phpStanMemoryLimitTextField, -2, 100, -2)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpStanEnabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpStanConfigurationLabel).addComponent(this.phpStanConfigurationTextField, -2, -1, -2).addComponent(this.phpStanConfigurationBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpStanLevelLabel).addComponent(this.phpStanLevelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpStanMemoryLimitLabel).addComponent(this.phpStanMemoryLimitTextField, -2, -1, -2))));
    }

    private void phpStanConfigurationBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(PHPStanOptionsPanel.class.getName() + PHPSTAN_CONFIGURATION_LAST_FOLDER_SUFFIX).setFilesOnly(true).setTitle(Bundle.PHPStanCustomizerPanel_configuration_browse_title()).showOpenDialog();
        if (file != null) {
            this.phpStanConfigurationTextField.setText(file.getAbsolutePath());
        }
    }
}

