/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee;

import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.payara.jakartaee.Hk2DeploymentManager;
import org.netbeans.modules.payara.spi.ServerUtilities;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.openide.util.NbBundle;

public class Hk2DeploymentFactory
implements DeploymentFactory {
    private static Hk2DeploymentFactory preludeInstance;
    private static Hk2DeploymentFactory ee6Instance;
    private static Hk2DeploymentFactory ee7Instance;
    private static Hk2DeploymentFactory ee8Instance;
    private String[] uriFragments;
    private String version;
    private String displayName;
    private ServerUtilities su;

    private Hk2DeploymentFactory(String[] uriFragments, String version, String displayName) {
        this.uriFragments = uriFragments;
        this.version = version;
        this.displayName = displayName;
    }

    private void setServerUtilities(ServerUtilities su) {
        this.su = su;
    }

    public static synchronized DeploymentFactory createEe(PayaraVersion version) {
        if (version != null && PayaraVersion.ge((Enum)version, (Enum)PayaraVersion.PF_5_181)) {
            return Hk2DeploymentFactory.createEe8();
        }
        if (version != null && PayaraVersion.ge((Enum)version, (Enum)PayaraVersion.PF_4_1_144)) {
            return Hk2DeploymentFactory.createEe7();
        }
        return Hk2DeploymentFactory.createEe6();
    }

    public static synchronized DeploymentFactory createEe6() {
        if (ee6Instance == null) {
            ServerUtilities tmp = ServerUtilities.getEe6Utilities();
            ee6Instance = new Hk2DeploymentFactory(new String[]{"deployer:pfv3ee6:", "deployer:pfv3"}, "0.2", NbBundle.getMessage(Hk2DeploymentFactory.class, (String)"TXT_FactoryDisplayName"));
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)ee6Instance);
            ee6Instance.setServerUtilities(tmp);
        }
        return ee6Instance;
    }

    public static synchronized DeploymentFactory createEe7() {
        if (ee7Instance == null) {
            ServerUtilities tmp = ServerUtilities.getEe7Utilities();
            ee7Instance = new Hk2DeploymentFactory(new String[]{"deployer:pfv4ee7:", "deployer:pfv4"}, "0.2", NbBundle.getMessage(Hk2DeploymentFactory.class, (String)"TXT_FactoryDisplayName"));
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)ee7Instance);
            ee7Instance.setServerUtilities(tmp);
        }
        return ee7Instance;
    }

    public static synchronized DeploymentFactory createEe8() {
        if (ee8Instance == null) {
            ServerUtilities tmp = ServerUtilities.getEe8Utilities();
            ee8Instance = new Hk2DeploymentFactory(new String[]{"deployer:pfv5ee8:", "deployer:pfv5"}, "0.2", NbBundle.getMessage(Hk2DeploymentFactory.class, (String)"TXT_FactoryDisplayName"));
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)ee8Instance);
            ee8Instance.setServerUtilities(tmp);
        }
        return ee8Instance;
    }

    public boolean handlesURI(String uri) {
        if (uri == null) {
            return false;
        }
        if (uri.startsWith("[")) {
            for (String uriFragment : this.uriFragments) {
                if (uri.indexOf(uriFragment) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public DeploymentManager getDeploymentManager(String uri, String uname, String passwd) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException("Invalid URI:" + uri);
        }
        if (!this.su.isRegisteredUri(uri)) {
            throw new DeploymentManagerCreationException("Registry mismatch for " + uri);
        }
        return new Hk2DeploymentManager(uri, uname, passwd, this.su);
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException("Invalid URI:" + uri);
        }
        if (!this.su.isRegisteredUri(uri)) {
            throw new DeploymentManagerCreationException("Registry mismatch for " + uri);
        }
        return new Hk2DeploymentManager(uri, null, null, this.su);
    }

    public String getProductVersion() {
        return this.version;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

