/**
 * Each Document has a doctype attribute whose value is either null or a DocumentType object. The DocumentType interface in the DOM Core provides an interface to the list of entities that are defined for the document, and little else because the effect of namespaces and the various XML schema efforts on DTD representation are not clearly understood as of this writing.DOM Level 3 doesn't support editing DocumentType nodes. DocumentType nodes are read-only.
 */
var DocumentType = {
}
/**
 * The internal subset as a string, or null if there is none. This is does not contain the delimiting square brackets. Note: The actual content returned depends on how much information is available to the implementation. This may vary depending on various parameters, including the XML processor used to build the document.
 * @syntax documentType.internalSubset
 * @returns {String} 
 */
DocumentType.prototype.internalSubset = new String();

/**
 * The name of DTD; i.e., the name immediately following the DOCTYPE keyword.
 * @syntax documentType.name
 * @returns {String} 
 */
DocumentType.prototype.name = new String();

/**
 * A NamedNodeMap containing the notations declared in the DTD. Duplicates are discarded. Every node in this map also implements the Notation interface. The DOM Level 2 does not support editing notations, therefore notations cannot be altered in any way.
 * @syntax documentType.notations
 * @returns {NamedNodeMap} 
 */
DocumentType.prototype.notations = new NamedNodeMap();

/**
 * The public identifier of the external subset.
 * @syntax documentType.publicId
 * @returns {String} 
 */
DocumentType.prototype.publicId = new String();

/**
 * The system identifier of the external subset. This may be an absolute URI or not.
 * @syntax documentType.systemId
 * @returns {String} 
 */
DocumentType.prototype.systemId = new String();

/**
 * A NamedNodeMap containing the general entities, both external and internal, declared in the DTD. Parameter entities are not contained. Duplicates are discarded. For example in: <!DOCTYPE ex SYSTEM "ex.dtd" [
  <!ENTITY foo "foo">
  <!ENTITY bar "bar">
  <!ENTITY bar "bar2">
  <!ENTITY % baz "baz">
]>
<ex/> the interface provides access to foo and the first declaration of bar but not the second declaration of bar or baz. Every node in this map also implements the Entity interface. The DOM Level 2 does not support editing entities, therefore entities cannot be altered in any way.
 * @syntax documentType.entities
 * @returns {NamedNodeMap} 
 */
DocumentType.prototype.entities = new NamedNodeMap();

/**
 * Represents the DocumentType prototype object.
 * @syntax DocumentType.prototype
 * @static
 */
DocumentType.prototype;

