/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.openide.util.Exceptions;

public final class SyncDocumentRegion {
    private Document doc;
    private String oldVal;
    private List<? extends MutablePositionRegion> regions;
    private List<? extends MutablePositionRegion> sortedRegions;

    public SyncDocumentRegion(Document doc, List<? extends MutablePositionRegion> regions) {
        this.doc = doc;
        this.regions = regions;
        boolean regionsSortPerformed = PositionRegion.isRegionsSorted(regions);
        if (regionsSortPerformed) {
            this.sortedRegions = regions;
        } else {
            this.sortedRegions = new ArrayList<MutablePositionRegion>(regions);
            Collections.sort(this.sortedRegions, PositionRegion.getComparator());
        }
        this.oldVal = this.getFirstRegionText();
    }

    public void updateRegions(List<MutablePositionRegion> regions) {
        List<MutablePositionRegion> sortedRegions;
        boolean sorted = PositionRegion.isRegionsSorted(regions);
        LinkedList<MutablePositionRegion> toRestore = new LinkedList<MutablePositionRegion>();
        LinkedList<MutablePositionRegion> toSync = new LinkedList<MutablePositionRegion>();
        if (sorted) {
            sortedRegions = regions;
        } else {
            sortedRegions = new ArrayList<MutablePositionRegion>(regions);
            Collections.sort(sortedRegions, PositionRegion.getComparator());
        }
        int j = 0;
        int i = 0;
        while (i < this.regions.size()) {
            MutablePositionRegion r1 = this.regions.get(i);
            if (j >= sortedRegions.size()) {
                toRestore.add(r1);
                ++i;
                continue;
            }
            MutablePositionRegion r2 = sortedRegions.get(j);
            if (r1.getStartOffset() == r2.getStartOffset()) {
                ++i;
                ++j;
                continue;
            }
            if (r1.getStartOffset() < r2.getStartOffset()) {
                toRestore.add(r1);
                ++i;
                continue;
            }
            toSync.add(r2);
            ++j;
        }
        while (j < sortedRegions.size()) {
            toSync.add(sortedRegions.get(j));
            ++j;
        }
        this.restore(toRestore);
        this.sync(toSync);
        this.regions = regions;
        this.sortedRegions = sortedRegions;
    }

    public int getRegionCount() {
        return this.regions.size();
    }

    public MutablePositionRegion getRegion(int regionIndex) {
        return this.regions.get(regionIndex);
    }

    public int getFirstRegionStartOffset() {
        return this.getRegion(0).getStartOffset();
    }

    public int getFirstRegionEndOffset() {
        return this.getRegion(0).getEndOffset();
    }

    public int getFirstRegionLength() {
        return this.getFirstRegionEndOffset() - this.getFirstRegionStartOffset();
    }

    public MutablePositionRegion getSortedRegion(int regionIndex) {
        return this.sortedRegions.get(regionIndex);
    }

    public void sync() {
        String firstRegionText = this.getFirstRegionText();
        if (firstRegionText != null) {
            int regionCount = this.getRegionCount();
            for (int i = 1; i < regionCount; ++i) {
                MutablePositionRegion region = this.getRegion(i);
                int offset = region.getStartOffset();
                int length = region.getEndOffset() - offset;
                try {
                    if (CharSequenceUtilities.textEquals((CharSequence)firstRegionText, (CharSequence)DocumentUtilities.getText((Document)this.doc, (int)offset, (int)length))) continue;
                    if (firstRegionText.length() > 0) {
                        this.doc.insertString(offset, firstRegionText, null);
                    }
                    this.doc.remove(offset + firstRegionText.length(), length);
                    continue;
                }
                catch (BadLocationException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private void sync(List<MutablePositionRegion> toSync) {
        String firstRegionText = this.getFirstRegionText();
        for (MutablePositionRegion region : toSync) {
            int offset = region.getStartOffset();
            int length = region.getEndOffset() - offset;
            try {
                CharSequence old = DocumentUtilities.getText((Document)this.doc, (int)offset, (int)length);
                if (CharSequenceUtilities.textEquals((CharSequence)firstRegionText, (CharSequence)old)) continue;
                int res = -1;
                int k = 0;
                while (k < Math.min(old.length(), firstRegionText.length()) && old.charAt(k) == firstRegionText.charAt(k)) {
                    res = k++;
                }
                String insert = firstRegionText.substring(res + 1);
                CharSequence remove = old.subSequence(res + 1, old.length());
                if (insert.length() > 0) {
                    this.doc.insertString(offset + res + 1, insert, null);
                }
                if (remove.length() <= 0) continue;
                this.doc.remove(offset + res + 1 + insert.length(), remove.length());
            }
            catch (BadLocationException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private void restore(List<MutablePositionRegion> toRestore) {
        for (MutablePositionRegion region : toRestore) {
            int offset = region.getStartOffset();
            int length = region.getEndOffset() - offset;
            try {
                if (CharSequenceUtilities.textEquals((CharSequence)this.oldVal, (CharSequence)DocumentUtilities.getText((Document)this.doc, (int)offset, (int)length))) continue;
                if (this.oldVal.length() > 0) {
                    this.doc.insertString(offset, this.oldVal, null);
                }
                this.doc.remove(offset + this.oldVal.length(), length);
            }
            catch (BadLocationException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private String getFirstRegionText() {
        return this.getRegionText(0);
    }

    private String getRegionText(int regionIndex) {
        try {
            MutablePositionRegion region = this.getRegion(regionIndex);
            int offset = region.getStartOffset();
            int length = region.getEndOffset() - offset;
            return this.doc.getText(offset, length);
        }
        catch (BadLocationException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }
}

