/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.xml.util.Util;
import org.netbeans.modules.xml.wizard.AbstractPanel;
import org.netbeans.modules.xml.wizard.SchemaParser;
import org.netbeans.modules.xml.wizard.impl.ExternalReferenceDataNode;
import org.netbeans.modules.xml.wizard.impl.SchemaImportGUI;
import org.netbeans.modules.xml.wizard.impl.SchemaObject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class SchemaPanel
extends AbstractPanel
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = -7568909683682244030L;
    private TemplateWizard templateWizard;
    private FileObject primarySchema = null;
    private Vector rows;
    private static final int PRIMARY_COL = 0;
    private static final int SCHEMA_COL = 1;
    private static final int ROOT_COL = 2;
    private static final int PREFIX_COL = 3;
    private SchemaTableModel tableModel;
    private SchemaImportGUI gui;
    private static String startString;
    private static final String PREFIX = "ns";
    private JButton browseButton;
    private JScrollPane jScrollPane1;
    private JLabel locationLabel;
    private JPanel locationPanel;
    private JButton removeButton;
    private JTable schemaTable;

    public SchemaPanel(TemplateWizard tw) {
        this.templateWizard = tw;
        this.rows = new Vector();
        this.tableModel = new SchemaTableModel();
        this.initComponents();
        this.initAccessibility();
        this.initComp();
    }

    private void initComponents() {
        this.locationPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.schemaTable = new JTable();
        this.locationLabel = new JLabel();
        this.browseButton = new JButton();
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.removeButton = new JButton();
        this.setName(Util.THIS.getString(SchemaPanel.class, "PROP_schema_panel_name"));
        this.locationPanel.setBorder(BorderFactory.createEtchedBorder());
        this.locationPanel.setLayout(new BorderLayout());
        this.schemaTable.setModel(this.tableModel);
        this.jScrollPane1.setViewportView(this.schemaTable);
        this.schemaTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_Schema_table"));
        this.schemaTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_Schema_table"));
        this.locationPanel.add((Component)this.jScrollPane1, "Center");
        this.locationLabel.setLabelFor(this.locationPanel);
        this.locationLabel.setText(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_SchemaPanel_Location"));
        this.locationLabel.setToolTipText(NbBundle.getMessage(SchemaPanel.class, (String)"TIP_SchemaPanel_Location"));
        this.browseButton.setText(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_BrowseButton"));
        this.removeButton.setText(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_RemoveButton"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaPanel.this.removeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.locationPanel, -1, 582, Short.MAX_VALUE).addComponent(this.locationLabel).addGroup(layout.createSequentialGroup().addComponent(this.browseButton).addGap(18, 18, 18).addComponent(this.removeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.locationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.locationPanel, -2, 268, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseButton).addComponent(this.removeButton)).addContainerGap(82, Short.MAX_VALUE)));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_BrowseButton"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaPanel.class, (String)"LBL_RemoveButton"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaPanel.class, (String)"PROP_schema_panel_name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaPanel.class, (String)"PROP_schema_panel_name"));
    }

    private boolean isDuplicate(String schemaFileName) {
        if (this.rows.size() == 1) {
            return false;
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            List rowData = (List)this.rows.get(i);
            SchemaObject obj = (SchemaObject)rowData.get(1);
            if (obj.toString().equals(startString) || !obj.getSchemaFileName().equals(schemaFileName)) continue;
            return true;
        }
        return false;
    }

    private void primarySchemaCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int row = this.schemaTable.getSelectedRow();
        this.deleteRow(row);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        this.gui = new SchemaImportGUI(this.templateWizard);
        DialogDescriptor descriptor = new DialogDescriptor((Object)this.gui, NbBundle.getMessage(SchemaPanel.class, (String)"LBL_Browser"), true, (ActionListener)this);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
        dlg.getAccessibleContext().setAccessibleDescription("DSC_Browser");
        dlg.setVisible(true);
    }

    private void initAccessibility() {
        Util util = Util.THIS;
        this.locationLabel.setDisplayedMnemonic(util.getChar(SchemaPanel.class, "PROP_schema_locationLabel_mne"));
        this.browseButton.setMnemonic(util.getChar(SchemaPanel.class, "LBL_BrowseButton_mme"));
        this.removeButton.setMnemonic(util.getChar(SchemaPanel.class, "LBL_RemoveButton_mne"));
    }

    private void updatePossibilities() {
    }

    @Override
    protected void initView() {
    }

    @Override
    protected void updateModel() {
        int numRows = this.tableModel.getRowCount();
        int numCols = this.tableModel.getColumnCount();
        String uri = null;
        ArrayList<SchemaObject> schemaFiles = new ArrayList<SchemaObject>();
        for (int i = 0; i < numRows; ++i) {
            List rowData = (List)this.rows.get(i);
            boolean primary = (Boolean)rowData.get(0);
            String prefix = (String)rowData.get(3);
            SchemaObject obj = (SchemaObject)rowData.get(1);
            if (obj.toString().equals(startString)) continue;
            obj.setPrefix(prefix);
            String root = (String)rowData.get(2);
            if (primary) {
                this.model.setPrimarySchema(obj.toString());
                this.model.setNamespace(obj.getNamespace());
                this.model.setPrefix(prefix);
                this.model.setRoot(root);
                File file = new File(obj.toString());
                uri = file.getName();
                if (uri != null) {
                    uri = uri.replace(" ", "%20");
                    try {
                        uri = new URI(uri).toASCIIString();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                this.model.setSystemID(uri == null || uri.length() == 0 ? null : uri);
            }
            schemaFiles.add(obj);
        }
        this.model.setSchemaNodes(schemaFiles);
    }

    @Override
    protected void updateView() {
    }

    private String getStartString() {
        return NbBundle.getMessage(SchemaPanel.class, (String)"LBL_TABLE_SCHEMA_PROMPT");
    }

    private void tableKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            int row = this.schemaTable.getSelectedRow();
            this.deleteRow(row);
        }
    }

    private void deleteRow(int index) {
        if (index != -1) {
            SchemaObject val = (SchemaObject)this.tableModel.getValueAt(index, 1);
            if (val.toString().equals(startString)) {
                return;
            }
            this.rows.remove(index);
            this.schemaTable.addNotify();
            this.fireChange();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(DialogDescriptor.OK_OPTION)) {
            List nodes = this.gui.getSelectedNodes();
            if (nodes != null) {
                String noRoot = NbBundle.getMessage(SchemaPanel.class, (String)"LBL_No_Root_Elements");
                for (int i = 0; i < nodes.size(); ++i) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    ExternalReferenceDataNode erdn = (ExternalReferenceDataNode)((Object)nodes.get(i));
                    DataObject dobj = (DataObject)erdn.getLookup().lookup(DataObject.class);
                    if (this.isDuplicate(erdn.getSchemaFileName())) continue;
                    FileObject fobj = dobj.getPrimaryFile();
                    SchemaObject obj = new SchemaObject(erdn.getSchemaFileName());
                    obj.setFromCatalog(erdn.isResolveThroughCatalog());
                    obj.setNamespace(erdn.getNamespace());
                    obj.setSchemaFileName(erdn.getSchemaFileName());
                    row.add(false);
                    row.add(obj);
                    SchemaParser.SchemaInfo info = SchemaParser.getRootElements(fobj);
                    if (info != null && info.roots.size() > 0) {
                        Iterator it = info.roots.iterator();
                        String[] rootElements = new String[info.roots.size()];
                        info.roots.toArray(rootElements);
                        obj.setRootElements(rootElements);
                        row.add(rootElements[0]);
                    } else {
                        row.add(noRoot);
                    }
                    if (null != info.namespace) {
                        String pre = this.generateUniquePrefix();
                        obj.setPrefix(pre);
                        row.add(pre);
                    } else {
                        row.add(null);
                    }
                    this.tableModel.addRow(0, row);
                }
                this.schemaTable.addNotify();
            }
        } else if (evt.getSource().equals(DialogDescriptor.CANCEL_OPTION)) {
            this.gui.setVisible(false);
        }
    }

    private List createBlankElement(String val) {
        ArrayList<Object> t = new ArrayList<Object>();
        t.add(new Boolean(false));
        t.add(new SchemaObject(val));
        t.add(" ");
        t.add(" ");
        return t;
    }

    private void addRow(String val) {
        List r = this.createBlankElement(val);
        this.tableModel.addRow(r);
        this.schemaTable.addNotify();
    }

    private void initComp() {
        this.schemaTable.getModel().addTableModelListener(this);
        this.schemaTable.getTableHeader().setReorderingAllowed(false);
        startString = this.getStartString();
        this.schemaTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SchemaPanel.this.tableKeyPressed(evt);
            }
        });
        this.addRow(startString);
        TableColumn column = null;
        for (int i = 0; i < 4; ++i) {
            column = this.schemaTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(40);
                continue;
            }
            if (i == 1) {
                column.setPreferredWidth(250);
                continue;
            }
            column.setPreferredWidth(80);
        }
        this.schemaTable.getColumnModel().getColumn(0).setCellRenderer(new RadioColumnRenderer());
        this.schemaTable.getColumnModel().getColumn(0).setCellEditor(new RadioColumnEditor());
        TableColumn rootColumn = this.schemaTable.getColumnModel().getColumn(2);
        rootColumn.setCellEditor(new ComboBoxColumnEditor());
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(NbBundle.getMessage(SchemaPanel.class, (String)"TIP_COMBO_COL"));
        rootColumn.setCellRenderer(renderer);
        int height = this.schemaTable.getRowHeight();
        for (int c = 0; c < this.schemaTable.getColumnCount(); ++c) {
            TableCellRenderer r = this.schemaTable.getCellRenderer(0, c);
            Component comp = this.schemaTable.prepareRenderer(r, 0, c);
            int h = comp.getPreferredSize().height;
            height = Math.max(height, h);
        }
        this.schemaTable.setRowHeight(height);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        AbstractTableModel tblModel = (AbstractTableModel)e.getSource();
        Object data = tblModel.getValueAt(row, column);
        if (column == 1) {
            SchemaObject rowValue = (SchemaObject)data;
            if (rowValue.toString().equals(startString)) {
                return;
            }
            String genPrefix = (String)tblModel.getValueAt(row, 3);
            if (genPrefix == null || genPrefix.equals(" ")) {
                String prefix = this.generateUniquePrefix();
                this.tableModel.setValueAt(prefix, row, 3);
            }
            if (row == this.tableModel.getRowCount() - 1) {
                this.addRow(startString);
            }
            if (row == 0) {
                tblModel.setValueAt(new Boolean(true), 0, 0);
            }
        }
    }

    private String generateUniquePrefix() {
        int counter = 1;
        String generatedName = PREFIX + counter++;
        while (!this.isPrefixUnique(generatedName)) {
            generatedName = PREFIX + counter++;
        }
        return generatedName;
    }

    private boolean isPrefixUnique(String prefix) {
        HashSet<String> prefixSet = new HashSet<String>();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Object prefixValue = this.tableModel.getValueAt(i, 3);
            if (!(prefixValue instanceof String)) continue;
            prefixSet.add((String)prefixValue);
        }
        return !prefixSet.contains(prefix);
    }

    public boolean isPanelValid() {
        if (this.tableModel.getRowCount() == 1) {
            return false;
        }
        int rowCount = this.tableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            List rowValue = (List)this.rows.get(i);
            boolean selected = (Boolean)rowValue.get(0);
            if (!selected) continue;
            return true;
        }
        return false;
    }

    class ComboBoxColumnEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox comboBox;

        @Override
        public Component getTableCellEditorComponent(JTable table, Object obj, boolean isSelected, int row, int col) {
            String[] root;
            this.comboBox = new JComboBox();
            this.comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ComboBoxColumnEditor.this.fireEditingStopped();
                }
            });
            DefaultComboBoxModel<String> rootModel = new DefaultComboBoxModel<String>();
            SchemaObject o = (SchemaObject)table.getModel().getValueAt(row, 1);
            if (!o.toString().equals(startString) && (root = o.getRootElements()) != null && root.length > 0) {
                for (int i = 0; i < root.length; ++i) {
                    rootModel.addElement(root[i]);
                }
            }
            this.comboBox.setModel(rootModel);
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getModel().getSelectedItem();
        }
    }

    class RadioColumnRenderer
    extends JRadioButton
    implements TableCellRenderer {
        RadioColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(Color.WHITE);
            if (value == null) {
                this.setSelected(false);
            } else {
                Boolean ValueAsBoolean = (Boolean)value;
                this.setSelected(ValueAsBoolean);
            }
            this.setHorizontalAlignment(0);
            this.setToolTipText(NbBundle.getMessage(SchemaPanel.class, (String)"TIP_PREFIX_COL"));
            return this;
        }
    }

    class RadioColumnEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JRadioButton theRadioButton = new JRadioButton();

        public RadioColumnEditor() {
            this.theRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    RadioColumnEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object obj, boolean isSelected, int row, int col) {
            this.theRadioButton.setHorizontalAlignment(0);
            if (obj != null) {
                Boolean lValueAsBoolean = (Boolean)obj;
                this.theRadioButton.setSelected(lValueAsBoolean);
            }
            return this.theRadioButton;
        }

        @Override
        public Object getCellEditorValue() {
            return new Boolean(this.theRadioButton.isSelected());
        }
    }

    class SchemaTableModel
    extends AbstractTableModel {
        SchemaTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return SchemaPanel.this.rows.size();
        }

        @Override
        public String getColumnName(int col) {
            String colName = null;
            switch (col) {
                case 0: {
                    colName = NbBundle.getMessage(SchemaPanel.class, (String)"LBL_PRIMARY_COL");
                    break;
                }
                case 1: {
                    colName = NbBundle.getMessage(SchemaPanel.class, (String)"LBL_SCHEMA_COL");
                    break;
                }
                case 2: {
                    colName = NbBundle.getMessage(SchemaPanel.class, (String)"LBL_ROOT_COL");
                    break;
                }
                case 3: {
                    colName = NbBundle.getMessage(SchemaPanel.class, (String)"LBL_PREIFX_COL");
                }
            }
            return colName;
        }

        @Override
        public Object getValueAt(int row, int col) {
            List obj = (List)SchemaPanel.this.rows.elementAt(row);
            if (col == 1) {
                SchemaObject val = (SchemaObject)obj.get(col);
                return val;
            }
            if (col == 3) {
                return obj.get(col) == null ? NbBundle.getMessage(SchemaPanel.class, (String)"LBL_NoPrefix") : obj.get(col);
            }
            return obj.get(col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 2) {
                return true;
            }
            if (col == 0) {
                SchemaObject s = (SchemaObject)this.getValueAt(row, 1);
                return !s.toString().equals(startString);
            }
            if (col == 3) {
                SchemaObject s = (SchemaObject)this.getValueAt(row, 1);
                return s.getNamespace() != null;
            }
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row < 0 || col < 0 || row >= this.getRowCount() || col >= this.getColumnCount()) {
                return;
            }
            if (value == null) {
                return;
            }
            List rowVector = (List)SchemaPanel.this.rows.elementAt(row);
            if (col == 0 && ((Boolean)value).booleanValue()) {
                SchemaObject obj = (SchemaObject)this.getValueAt(row, 1);
                if (obj.getRootElements() == null || obj.getRootElements().length == 0) {
                    String errMsg = NbBundle.getMessage(SchemaPanel.class, (String)"MSG_SchemaPanel_Incorrect_Primary");
                    SchemaPanel.this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)errMsg);
                    return;
                }
                SchemaPanel.this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)"");
                for (int i = 0; i < this.getRowCount(); ++i) {
                    if (i == row) continue;
                    this.setValueAt(new Boolean(false), i, 0);
                }
                rowVector.set(col, value);
            } else if (col == 1) {
                String systemId = (String)value;
                if (systemId.equals(startString)) {
                    return;
                }
                try {
                    File file = new File(systemId);
                    if (!file.exists() && !systemId.startsWith("http")) {
                        return;
                    }
                    URL context = SchemaPanel.this.model.getTargetFolderURL();
                    if (context != null) {
                        systemId = new URL(context, systemId).toExternalForm();
                    }
                }
                catch (MalformedURLException ex) {
                    return;
                }
                SchemaParser parser = new SchemaParser();
                SchemaParser.SchemaInfo info = parser.parse(systemId);
                SchemaObject obj = new SchemaObject((String)value);
                if (info.namespace != null) {
                    obj.setNamespace(info.namespace);
                }
                if (info != null && info.roots.size() > 0) {
                    Iterator it = info.roots.iterator();
                    String[] rootElements = new String[info.roots.size()];
                    info.roots.toArray(rootElements);
                    obj.setRootElements(rootElements);
                    rowVector.set(2, rootElements[0]);
                }
                obj.setSchemaFileName((String)value);
                rowVector.set(col, obj);
            } else if (col == 3) {
                String prefix = ((String)value).trim();
                if (SchemaPanel.this.isPrefixUnique(prefix)) {
                    rowVector.set(col, prefix);
                }
            } else {
                rowVector.set(col, value);
            }
            SchemaPanel.this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)"");
            SchemaPanel.this.fireChange();
            this.fireTableCellUpdated(row, col);
        }

        private void addRow(List r) {
            SchemaPanel.this.rows.add(r);
        }

        private void addRow(int i, List row) {
            SchemaPanel.this.rows.add(i, row);
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < numCols; ++j) {
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

