/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.ClassNode;
import com.oracle.js.parser.ir.ExportSpecifierNode;
import com.oracle.js.parser.ir.FromNode;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.ImportSpecifierNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.NameSpaceImportNode;
import com.oracle.js.parser.ir.ObjectNode;
import com.oracle.js.parser.ir.PropertyNode;
import com.oracle.js.parser.ir.UnaryNode;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.doc.api.JsDocumentationSupport;
import org.netbeans.modules.javascript2.doc.spi.JsComment;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.JsReference;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.model.api.Occurrence;
import org.netbeans.modules.javascript2.types.api.Identifier;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class JsSemanticAnalyzer
extends SemanticAnalyzer<JsParserResult> {
    public static final EnumSet<ColoringAttributes> UNUSED_OBJECT_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.CLASS);
    public static final EnumSet<ColoringAttributes> UNUSED_METHOD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> LOCAL_VARIABLE_DECLARATION = EnumSet.of(ColoringAttributes.LOCAL_VARIABLE_DECLARATION);
    public static final EnumSet<ColoringAttributes> LOCAL_VARIABLE_DECLARATION_UNUSED = EnumSet.of(ColoringAttributes.LOCAL_VARIABLE_DECLARATION, ColoringAttributes.UNUSED);
    public static final EnumSet<ColoringAttributes> LOCAL_VARIABLE_USE = EnumSet.of(ColoringAttributes.LOCAL_VARIABLE);
    public static final EnumSet<ColoringAttributes> GLOBAL_DEFINITION = EnumSet.of(ColoringAttributes.GLOBAL, ColoringAttributes.CLASS);
    public static final EnumSet<ColoringAttributes> NUMBER_OXB_CHAR = EnumSet.of(ColoringAttributes.CUSTOM1);
    public static final EnumSet<ColoringAttributes> SEMANTIC_KEYWORD = EnumSet.of(ColoringAttributes.CUSTOM2);
    private boolean cancelled = false;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights = null;
    private static final List<String> GLOBAL_TYPES = Arrays.asList("Array", "String", "Boolean", "Number");
    private Collection<OffsetRange> globalJsHintInlines = new ArrayList<OffsetRange>();

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void run(JsParserResult result, SchedulerEvent event) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        Map<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        Model model = Model.getModel((ParserResult)result, (boolean)false);
        JsObject global = model.getGlobalObject();
        Collection definedGlobal = ModelUtils.getDefinedGlobal((Snapshot)result.getSnapshot(), (int)-1);
        for (Identifier iden : definedGlobal) {
            this.globalJsHintInlines.add(iden.getOffsetRange());
        }
        highlights = this.count(result, global, highlights, new HashSet<String>());
        highlights = this.processSemanticKeywords(result, highlights);
        this.semanticHighlights = (highlights = this.processNumbers(result, highlights)) != null && highlights.size() > 0 ? highlights : null;
    }

    private Map<OffsetRange, Set<ColoringAttributes>> count(JsParserResult result, JsObject parent, Map<OffsetRange, Set<ColoringAttributes>> highlights, Set<String> processedObjects) {
        if (ModelUtils.wasProcessed((JsObject)parent, processedObjects)) {
            return highlights;
        }
        for (JsObject object : parent.getProperties().values()) {
            if (object.getDeclarationName() != null) {
                switch (object.getJSKind()) {
                    case CONSTRUCTOR: 
                    case METHOD: 
                    case FUNCTION: 
                    case GENERATOR: {
                        Object range;
                        if (object.isDeclared() && !object.isAnonymous() && !object.getDeclarationName().getOffsetRange().isEmpty()) {
                            EnumSet<ColoringAttributes> coloring = ColoringAttributes.METHOD_SET;
                            if (object.getModifiers().contains(Modifier.PRIVATE)) {
                                OffsetRange orOccurrence;
                                OffsetRange orDeclaration;
                                if (object.getOccurrences().isEmpty()) {
                                    coloring = UNUSED_METHOD_SET;
                                } else if (object.getOccurrences().size() == 1 && (orDeclaration = object.getDeclarationName().getOffsetRange()).equals((Object)(orOccurrence = ((Occurrence)object.getOccurrences().get(0)).getOffsetRange()))) {
                                    coloring = UNUSED_METHOD_SET;
                                }
                            }
                            this.addColoring(result, highlights, object.getDeclarationName().getOffsetRange(), coloring);
                        }
                        for (JsObject param : ((JsFunction)object).getParameters()) {
                            if (!(object instanceof JsReference) || ((JsReference)object).getOriginal().isAnonymous()) {
                                this.count(result, param, highlights, processedObjects);
                            }
                            if (this.hasSourceOccurences(result, param) || (range = LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)param.getDeclarationName().getOffsetRange())).getStart() >= range.getEnd()) continue;
                            highlights.put((OffsetRange)range, ColoringAttributes.UNUSED_SET);
                        }
                        break;
                    }
                    case PROPERTY_GETTER: 
                    case PROPERTY_SETTER: {
                        Token token;
                        int offset = LexUtilities.getLexerOffset((ParserResult)result, (int)object.getDeclarationName().getOffsetRange().getStart());
                        TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)result.getSnapshot(), (int)offset);
                        if (ts == null) break;
                        ts.move(offset);
                        if (ts.moveNext() && ts.movePrevious() && ((token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT, JsTokenId.DOC_COMMENT))).id() == JsTokenId.IDENTIFIER || token.id() == JsTokenId.PRIVATE_IDENTIFIER) && token.length() == 3) {
                            highlights.put(new OffsetRange(ts.offset(), ts.offset() + token.length()), ColoringAttributes.METHOD_SET);
                        }
                        highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)object.getDeclarationName().getOffsetRange()), ColoringAttributes.FIELD_SET);
                        break;
                    }
                    case OBJECT: 
                    case OBJECT_LITERAL: 
                    case CLASS: {
                        Object cts;
                        Object occurence22;
                        Token token;
                        if ("UNKNOWN".equals(object.getName())) break;
                        if (parent.getParent() == null && !GLOBAL_TYPES.contains(object.getName())) {
                            this.addColoring(result, highlights, object.getDeclarationName().getOffsetRange(), GLOBAL_DEFINITION);
                            token = object.getOccurrences().iterator();
                            while (token.hasNext()) {
                                occurence22 = (Occurrence)token.next();
                                this.addColoring(result, highlights, occurence22.getOffsetRange(), ColoringAttributes.GLOBAL_SET);
                            }
                        } else {
                            if (!object.isDeclared() || "prototype".equals(object.getName()) || object.isAnonymous()) break;
                            if ((object.getOccurrences().isEmpty() || object.getOccurrences().size() == 1 && ((Occurrence)object.getOccurrences().get(0)).getOffsetRange().equals((Object)object.getDeclarationName().getOffsetRange())) && object.getModifiers().contains(Modifier.PRIVATE)) {
                                highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)object.getDeclarationName().getOffsetRange()), UNUSED_OBJECT_SET);
                                break;
                            }
                            highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)object.getDeclarationName().getOffsetRange()), ColoringAttributes.CLASS_SET);
                            cts = LexUtilities.getJsTokenSequence((Snapshot)result.getSnapshot(), (int)object.getDeclarationName().getOffsetRange().getStart());
                            for (Occurrence occurrence : object.getOccurrences()) {
                                cts.move(occurrence.getOffsetRange().getStart());
                                if (!cts.moveNext() || cts.token().id() != JsTokenId.STRING || occurrence.getOffsetRange().equals((Object)object.getDeclarationName().getOffsetRange())) continue;
                                highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)occurrence.getOffsetRange()), ColoringAttributes.CLASS_SET);
                            }
                        }
                        break;
                    }
                    case PROPERTY: 
                    case FIELD: {
                        Object cts;
                        Object occurence22;
                        if (object.isDeclared()) {
                            this.addColoring(result, highlights, object.getDeclarationName().getOffsetRange(), ColoringAttributes.FIELD_SET);
                            for (Object occurence22 : object.getOccurrences()) {
                                this.addColoring(result, highlights, occurence22.getOffsetRange(), ColoringAttributes.FIELD_SET);
                            }
                        } else {
                            cts = LexUtilities.getJsTokenSequence((Snapshot)result.getSnapshot(), (int)object.getOffset());
                            cts.move(object.getOffsetRange().getStart());
                            if (cts.moveNext() && cts.token().id() == JsTokenId.STRING) {
                                this.addColoring(result, highlights, object.getOffsetRange(), ColoringAttributes.FIELD_SET);
                            }
                            occurence22 = object.getOccurrences().iterator();
                            while (occurence22.hasNext()) {
                                Occurrence occurrence;
                                occurrence = (Occurrence)occurence22.next();
                                cts.move(occurrence.getOffsetRange().getStart());
                                if (!cts.moveNext() || cts.token().id() != JsTokenId.STRING) continue;
                                this.addColoring(result, highlights, occurrence.getOffsetRange(), ColoringAttributes.FIELD_SET);
                            }
                        }
                        break;
                    }
                    case VARIABLE: {
                        Object occurence22;
                        Object range;
                        if (parent.getParent() == null && !GLOBAL_TYPES.contains(object.getName())) {
                            this.addColoring(result, highlights, object.getDeclarationName().getOffsetRange(), ColoringAttributes.GLOBAL_SET);
                            for (Object occurence22 : object.getOccurrences()) {
                                this.addColoring(result, highlights, occurence22.getOffsetRange(), ColoringAttributes.GLOBAL_SET);
                            }
                        } else {
                            if ((object.getOccurrences().isEmpty() || object.getOccurrences().size() == 1 && ((Occurrence)object.getOccurrences().get(0)).getOffsetRange().equals((Object)object.getDeclarationName().getOffsetRange())) && !GLOBAL_TYPES.contains(object.getName())) {
                                range = object.getDeclarationName().getOffsetRange();
                                if (range.getStart() >= range.getEnd()) break;
                                if (object.getModifiers().contains(Modifier.PRIVATE) || object.getModifiers().contains(Modifier.PROTECTED)) {
                                    highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)object.getDeclarationName().getOffsetRange()), LOCAL_VARIABLE_DECLARATION_UNUSED);
                                    break;
                                }
                                highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)object.getDeclarationName().getOffsetRange()), ColoringAttributes.UNUSED_SET);
                                break;
                            }
                            if (!(object instanceof JsObject) || "arguments".equals(object.getName())) break;
                            if (object.getOccurrences().size() <= object.getAssignmentCount()) {
                                if (object.getDeclarationName().getOffsetRange().getLength() > 0) {
                                    highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)object.getDeclarationName().getOffsetRange()), ColoringAttributes.UNUSED_SET);
                                }
                                range = object.getOccurrences().iterator();
                                while (range.hasNext()) {
                                    occurence22 = (Occurrence)range.next();
                                    if (occurence22.getOffsetRange().getLength() <= 0) continue;
                                    highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)occurence22.getOffsetRange()), ColoringAttributes.UNUSED_SET);
                                }
                            } else {
                                if (!object.getModifiers().contains(Modifier.PRIVATE) && !object.getModifiers().contains(Modifier.PROTECTED)) break;
                                OffsetRange decOffset = object.getDeclarationName().getOffsetRange();
                                this.addColoring(result, highlights, decOffset, LOCAL_VARIABLE_DECLARATION);
                                for (Occurrence occurence : object.getOccurrences()) {
                                    if (occurence.getOffsetRange().getLength() <= 0 || occurence.getOffsetRange().equals((Object)decOffset)) continue;
                                    this.addColoring(result, highlights, occurence.getOffsetRange(), LOCAL_VARIABLE_USE);
                                }
                            }
                        }
                        break;
                    }
                }
            }
            if (this.isCancelled()) {
                highlights = null;
                break;
            }
            if (object instanceof JsReference && ModelUtils.isDescendant((JsObject)object, (JsObject)((JsReference)object).getOriginal())) continue;
            highlights = this.count(result, object, highlights, processedObjects);
        }
        return highlights;
    }

    private Map<OffsetRange, Set<ColoringAttributes>> processSemanticKeywords(final JsParserResult result, final Map<OffsetRange, Set<ColoringAttributes>> highlights) {
        FunctionNode root = result.getRoot();
        if (root == null) {
            return highlights;
        }
        NodeVisitor visitor = new NodeVisitor(new LexicalContext()){

            public boolean enterFunctionNode(FunctionNode functionNode) {
                if (functionNode.isModule()) {
                    functionNode.visitImports((NodeVisitor)this);
                    functionNode.visitExports((NodeVisitor)this);
                }
                if (functionNode.isAsync() && !functionNode.isMethod()) {
                    Token token;
                    TokenSequence ts;
                    int pos = com.oracle.js.parser.Token.descPosition((long)functionNode.getFirstToken());
                    if (functionNode.getKind() != FunctionNode.Kind.ARROW) {
                        --pos;
                    }
                    if ((ts = LexUtilities.getJsPositionedSequence((Snapshot)result.getSnapshot(), (int)pos)) != null && (token = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts)) != null && (token.id() == JsTokenId.IDENTIFIER || token.id() == JsTokenId.PRIVATE_IDENTIFIER) && "async".equals(token.text().toString())) {
                        highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)new OffsetRange(ts.offset(), ts.offset() + token.length())), SEMANTIC_KEYWORD);
                    }
                }
                return super.enterFunctionNode(functionNode);
            }

            public boolean enterImportSpecifierNode(ImportSpecifierNode importSpecifierNode) {
                if (importSpecifierNode.getIdentifier() != null) {
                    Token token;
                    int start = importSpecifierNode.getIdentifier().getFinish();
                    TokenSequence ts = LexUtilities.getJsPositionedSequence((Snapshot)result.getSnapshot(), (int)start);
                    if (ts != null && (token = LexUtilities.findNextNonWsNonComment((TokenSequence)ts)) != null && (token.id() == JsTokenId.IDENTIFIER || token.id() == JsTokenId.PRIVATE_IDENTIFIER) && ts.offset() < importSpecifierNode.getBindingIdentifier().getStart()) {
                        highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)new OffsetRange(ts.offset(), ts.offset() + token.length())), SEMANTIC_KEYWORD);
                    }
                }
                return false;
            }

            public boolean enterExportSpecifierNode(ExportSpecifierNode exportSpecifierNode) {
                if (exportSpecifierNode.getExportIdentifier() != null) {
                    Token token;
                    int start = exportSpecifierNode.getIdentifier().getFinish();
                    TokenSequence ts = LexUtilities.getJsPositionedSequence((Snapshot)result.getSnapshot(), (int)start);
                    if (ts != null && (token = LexUtilities.findNextNonWsNonComment((TokenSequence)ts)) != null && (token.id() == JsTokenId.IDENTIFIER || token.id() == JsTokenId.PRIVATE_IDENTIFIER) && ts.offset() < exportSpecifierNode.getExportIdentifier().getStart()) {
                        highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)new OffsetRange(ts.offset(), ts.offset() + token.length())), SEMANTIC_KEYWORD);
                    }
                }
                return false;
            }

            public boolean enterNameSpaceImportNode(NameSpaceImportNode nameSpaceImportNode) {
                Token token;
                int start = nameSpaceImportNode.getBindingIdentifier().getStart();
                if (start <= 0) {
                    return false;
                }
                TokenSequence ts = LexUtilities.getJsPositionedSequence((Snapshot)result.getSnapshot(), (int)(start - 1));
                if (ts != null && (token = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts)) != null && token.id() == JsTokenId.IDENTIFIER && ts.token().length() > 1) {
                    highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)new OffsetRange(ts.offset(), ts.offset() + token.length())), SEMANTIC_KEYWORD);
                }
                return false;
            }

            public boolean enterFromNode(FromNode fromNode) {
                highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)new OffsetRange(fromNode.getStart(), fromNode.getStart() + "from".length())), SEMANTIC_KEYWORD);
                return false;
            }

            public boolean enterClassNode(ClassNode classNode) {
                for (PropertyNode p : classNode.getClassElements()) {
                    this.handleProperty(p, true);
                }
                return super.enterClassNode(classNode);
            }

            public boolean enterObjectNode(ObjectNode objectNode) {
                for (PropertyNode p : objectNode.getElements()) {
                    this.handleProperty(p, false);
                }
                return super.enterObjectNode(objectNode);
            }

            public boolean enterVarNode(VarNode varNode) {
                Token token;
                TokenSequence ts;
                if (varNode.isLet() && (ts = LexUtilities.getJsPositionedSequence((Snapshot)result.getSnapshot(), (int)(varNode.getStart() - 1))) != null && (token = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts)) != null && token.id() == JsTokenId.RESERVED_LET) {
                    highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)new OffsetRange(ts.offset(), ts.offset() + token.length())), SEMANTIC_KEYWORD);
                }
                return super.enterVarNode(varNode);
            }

            public boolean enterUnaryNode(UnaryNode unaryNode) {
                Token token;
                TokenSequence ts;
                if (unaryNode.isTokenType(TokenType.AWAIT) && (ts = LexUtilities.getJsPositionedSequence((Snapshot)result.getSnapshot(), (int)unaryNode.getStart())) != null && (token = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts)) != null && token.id() == JsTokenId.RESERVED_AWAIT) {
                    highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)new OffsetRange(ts.offset(), ts.offset() + token.length())), SEMANTIC_KEYWORD);
                }
                return super.enterUnaryNode(unaryNode);
            }

            private void handleProperty(PropertyNode p, boolean classElement) {
                Token token;
                TokenSequence ts;
                int offset = -1;
                if (p.getValue() instanceof FunctionNode && ((FunctionNode)p.getValue()).isAsync() && (ts = LexUtilities.getJsPositionedSequence((Snapshot)result.getSnapshot(), (int)(p.getStart() - 1))) != null && (token = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts)) != null && (token.id() == JsTokenId.IDENTIFIER || token.id() == JsTokenId.PRIVATE_IDENTIFIER) && "async".equals(token.text().toString())) {
                    offset = ts.offset();
                    highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)new OffsetRange(ts.offset(), ts.offset() + token.length())), SEMANTIC_KEYWORD);
                }
                if (classElement && p.isStatic() && (ts = LexUtilities.getJsPositionedSequence((Snapshot)result.getSnapshot(), (int)(offset >= 0 ? offset - 1 : p.getStart() - 1))) != null && (token = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts)) != null && token.id() == JsTokenId.RESERVED_STATIC) {
                    highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)new OffsetRange(ts.offset(), ts.offset() + token.length())), SEMANTIC_KEYWORD);
                }
            }
        };
        root.accept(visitor);
        return highlights;
    }

    private Map<OffsetRange, Set<ColoringAttributes>> processNumbers(JsParserResult result, Map<OffsetRange, Set<ColoringAttributes>> highlights) {
        TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)result.getSnapshot(), (int)0);
        if (ts != null) {
            Token token;
            ts.move(0);
            ArrayList<JsTokenId> lookFor = new ArrayList<JsTokenId>(3);
            lookFor.add(JsTokenId.NUMBER);
            while (ts.moveNext() && (token = LexUtilities.findNextToken((TokenSequence)ts, lookFor)) != null) {
                String number;
                if (token.id() != JsTokenId.NUMBER || !(number = token.text().toString().toLowerCase(Locale.ENGLISH)).startsWith("0b") && !number.startsWith("0x") && !number.startsWith("0o")) continue;
                highlights.put(LexUtilities.getLexerOffsets((ParserResult)result, (OffsetRange)new OffsetRange(ts.offset() + 1, ts.offset() + 2)), NUMBER_OXB_CHAR);
            }
        }
        return highlights;
    }

    private void addColoring(JsParserResult result, Map<OffsetRange, Set<ColoringAttributes>> highlights, OffsetRange astRange, Set<ColoringAttributes> coloring) {
        int start = result.getSnapshot().getOriginalOffset(astRange.getStart());
        int end = result.getSnapshot().getOriginalOffset(astRange.getEnd());
        if (start > -1 && end > -1 && start < end && !this.isInComment(result, astRange)) {
            OffsetRange range = start == astRange.getStart() ? astRange : new OffsetRange(start, end);
            highlights.put(range, coloring);
        }
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    private boolean hasSourceOccurences(JsParserResult result, JsObject param) {
        if (param.getOccurrences().isEmpty()) {
            return false;
        }
        if (param.getOccurrences().size() == 1 && ((Occurrence)param.getOccurrences().get(0)).getOffsetRange().equals((Object)param.getDeclarationName().getOffsetRange())) {
            return false;
        }
        int sourceOccurenceCount = 0;
        for (Occurrence occurrence : param.getOccurrences()) {
            if (!this.isInComment(result, occurrence.getOffsetRange())) {
                ++sourceOccurenceCount;
            }
            if (sourceOccurenceCount <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean isInComment(JsParserResult result, OffsetRange range) {
        for (JsComment comment : JsDocumentationSupport.getDocumentationHolder((org.netbeans.modules.javascript2.types.spi.ParserResult)result).getCommentBlocks().values()) {
            if (!comment.getOffsetRange().containsInclusive(range.getStart())) continue;
            return true;
        }
        return this.globalJsHintInlines.contains(range);
    }
}

