/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import eu.hansolo.jdktools.Latest;
import eu.hansolo.jdktools.PackageType;
import eu.hansolo.jdktools.TermOfSupport;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.Pkg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.netbeans.modules.java.disco.BundleTableModel;
import org.netbeans.modules.java.disco.Client;
import org.netbeans.modules.java.disco.DiscoPlatformInstall;
import org.netbeans.modules.java.disco.DistributionListCellRenderer;
import org.netbeans.modules.java.disco.LTSes;
import org.netbeans.modules.java.disco.PackageTypeListCellRenderer;
import org.netbeans.modules.java.disco.VersionListCellRenderer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public abstract class AdvancedPanel
extends JPanel {
    protected BundleTableModel tableModel;
    private final DefaultComboBoxModel<Distribution> distrosModel = new DefaultComboBoxModel();
    private JComboBox<Distribution> distributionComboBox;
    private JScrollPane jScrollPane1;
    private JCheckBox latestCheckBox;
    private JComboBox<PackageType> packageTypeComboBox;
    protected JTable table;
    private JComboBox<Integer> versionComboBox;

    public AdvancedPanel() {
        this.initComponents();
        this.distributionComboBox.setRenderer(new DistributionListCellRenderer());
        this.versionComboBox.setRenderer(new VersionListCellRenderer());
        this.packageTypeComboBox.setRenderer(new PackageTypeListCellRenderer());
    }

    @UIEffect
    public @Nullable Pkg getSelectedPackage() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return null;
        }
        int modelIndex = this.table.convertRowIndexToModel(index);
        Pkg bundle = this.tableModel.getBundles().get(modelIndex);
        return bundle;
    }

    private TableModel createTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new BundleTableModel(new ArrayList<Pkg>());
        }
        return this.tableModel;
    }

    @UIEffect
    protected abstract void updateData(Distribution var1, Integer var2, Latest var3, PackageType var4);

    protected void updateDistributions(List<Distribution> distros) {
        this.distrosModel.removeAllElements();
        distros.stream().sorted((o1, o2) -> o1.getUiString().compareTo(o2.getUiString())).forEachOrdered(this.distrosModel::addElement);
        Client.getInstance().getDistribution(DiscoPlatformInstall.defaultDistribution()).filter(distros::contains).ifPresent(this.distrosModel::setSelectedItem);
    }

    protected void setVersions(List<Integer> versions, Map<Integer, TermOfSupport> lts) {
        ArrayList<Integer> reversedVersions = new ArrayList<Integer>(versions);
        Collections.sort(reversedVersions, Collections.reverseOrder());
        ((VersionListCellRenderer)this.versionComboBox.getRenderer()).setLTS(lts);
        DefaultComboBoxModel versionModel = (DefaultComboBoxModel)this.versionComboBox.getModel();
        reversedVersions.forEach(v -> versionModel.addElement(v));
        versionModel.setSelectedItem(LTSes.latest(lts));
    }

    private ComboBoxModel<Integer> createVersionComboboxModel() {
        return new DefaultComboBoxModel<Integer>();
    }

    private ComboBoxModel<Distribution> createDistributionComboboxModel() {
        return this.distrosModel;
    }

    private ComboBoxModel<PackageType> createPackageTypeComboboxModel() {
        PackageType[] bundleTypes = (PackageType[])Arrays.stream(PackageType.values()).filter(bundleType -> PackageType.NONE != bundleType).filter(bundleType -> PackageType.NOT_FOUND != bundleType).toArray(PackageType[]::new);
        return new DefaultComboBoxModel<PackageType>(bundleTypes);
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.distributionComboBox = new JComboBox();
        JPanel jPanel5 = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.versionComboBox = new JComboBox();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.packageTypeComboBox = new JComboBox();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.latestCheckBox = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.setLayout(new BorderLayout());
        jPanel1.setLayout(new BoxLayout(jPanel1, 2));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        Mnemonics.setLocalizedText((JLabel)jLabel1, (String)NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.jLabel1.text"));
        jPanel4.add(jLabel1);
        this.distributionComboBox.setModel(this.createDistributionComboboxModel());
        this.distributionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedPanel.this.distributionComboBoxActionPerformed(evt);
            }
        });
        jPanel4.add(this.distributionComboBox);
        jPanel1.add(jPanel4);
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.jLabel2.text"));
        jPanel5.add(jLabel2);
        this.versionComboBox.setModel(this.createVersionComboboxModel());
        this.versionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedPanel.this.versionComboBoxActionPerformed(evt);
            }
        });
        jPanel5.add(this.versionComboBox);
        jPanel1.add(jPanel5);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.jLabel3.text"));
        jPanel3.add(jLabel3);
        this.packageTypeComboBox.setModel(this.createPackageTypeComboboxModel());
        this.packageTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedPanel.this.packageTypeComboBoxActionPerformed(evt);
            }
        });
        jPanel3.add(this.packageTypeComboBox);
        jPanel1.add(jPanel3);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        Mnemonics.setLocalizedText((JLabel)jLabel4, (String)NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.jLabel4.text"));
        jPanel2.add(jLabel4);
        this.latestCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.latestCheckBox, (String)NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.latestCheckBox.text"));
        this.latestCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedPanel.this.latestCheckBoxActionPerformed(evt);
            }
        });
        jPanel2.add(this.latestCheckBox);
        jPanel1.add(jPanel2);
        this.add((Component)jPanel1, "Center");
        this.table.setAutoCreateRowSorter(true);
        this.table.setModel(this.createTableModel());
        this.table.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.table);
        this.add((Component)this.jScrollPane1, "Last");
    }

    private void latestCheckBoxActionPerformed(ActionEvent evt) {
        this.updateData((Distribution)this.distributionComboBox.getSelectedItem(), (Integer)this.versionComboBox.getSelectedItem(), this.latestCheckBox.isSelected() ? Latest.OVERALL : Latest.NONE, (PackageType)this.packageTypeComboBox.getSelectedItem());
    }

    private void distributionComboBoxActionPerformed(ActionEvent evt) {
        this.updateData((Distribution)this.distributionComboBox.getSelectedItem(), (Integer)this.versionComboBox.getSelectedItem(), this.latestCheckBox.isSelected() ? Latest.OVERALL : Latest.NONE, (PackageType)this.packageTypeComboBox.getSelectedItem());
    }

    private void versionComboBoxActionPerformed(ActionEvent evt) {
        this.updateData((Distribution)this.distributionComboBox.getSelectedItem(), (Integer)this.versionComboBox.getSelectedItem(), this.latestCheckBox.isSelected() ? Latest.OVERALL : Latest.NONE, (PackageType)this.packageTypeComboBox.getSelectedItem());
    }

    private void packageTypeComboBoxActionPerformed(ActionEvent evt) {
        this.updateData((Distribution)this.distributionComboBox.getSelectedItem(), (Integer)this.versionComboBox.getSelectedItem(), this.latestCheckBox.isSelected() ? Latest.OVERALL : Latest.NONE, (PackageType)this.packageTypeComboBox.getSelectedItem());
    }
}

