/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.php.api.util.StringUtils;

public final class Type {
    public static final String SEPARATOR_INTERSECTION = "&";
    public static final String SEPARATOR = "|";
    public static final String STRING = "string";
    public static final String REAL = "real";
    public static final String INT = "int";
    public static final String INTEGER = "integer";
    public static final String BOOL = "bool";
    public static final String BOOLEAN = "boolean";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String ARRAY = "array";
    public static final String NULL = "null";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String OBJECT = "object";
    public static final String NUMBER = "number";
    public static final String CALLBACK = "callback";
    public static final String CALLABLE = "callable";
    public static final String ITERABLE = "iterable";
    public static final String RESOURCE = "resource";
    public static final String VOID = "void";
    public static final String MIXED = "mixed";
    public static final String SELF = "self";
    public static final String PARENT = "parent";
    public static final String STATIC = "static";
    public static final String NEVER = "never";
    private static final List<String> TYPES_FOR_EDITOR = Arrays.asList("array", "callable", "iterable", "bool", "float", "int", "string", "object", "null", "false", "mixed");
    private static final List<String> TYPES_FOR_RETURN_TYPE = Arrays.asList("array", "callable", "iterable", "bool", "float", "int", "string", "void", "object", "null", "false", "mixed", "never");
    private static final List<String> TYPES_FOR_FIELD_TYPE = Arrays.asList("array", "iterable", "bool", "float", "int", "string", "object", "self", "parent", "null", "false", "mixed");
    private static final List<String> SPECIAL_TYPES_FOR_TYPE = Arrays.asList("self", "parent");
    private static final List<String> TYPES_FOR_PHP_DOC = Arrays.asList("string", "integer", "int", "boolean", "bool", "float", "double", "object", "mixed", "array", "resource", "void", "null", "callback", "callable", "iterable", "false", "true", "self");
    private static final List<String> MIXED_TYPE = Arrays.asList("array", "bool", "callable", "int", "float", "null", "object", "string");
    private static final List<String> TYPES_FOR_BACKING_TYPE = Arrays.asList("int", "string");

    private Type() {
    }

    public static boolean isPrimitive(String typeName) {
        boolean retval = false;
        if (BOOL.equals(typeName) || BOOLEAN.equals(typeName) || INT.equals(typeName) || INTEGER.equals(typeName) || FLOAT.equals(typeName) || REAL.equals(typeName) || ARRAY.equals(typeName) || OBJECT.equals(typeName) || MIXED.equals(typeName) || NUMBER.equals(typeName) || CALLBACK.equals(typeName) || RESOURCE.equals(typeName) || DOUBLE.equals(typeName) || STRING.equals(typeName) || NULL.equals(typeName) || VOID.equals(typeName) || CALLABLE.equals(typeName) || ITERABLE.equals(typeName) || FALSE.equals(typeName) || STATIC.equals(typeName) || NEVER.equals(typeName)) {
            retval = true;
        }
        return retval;
    }

    public static boolean isArray(String typeName) {
        boolean result = false;
        if (ARRAY.equals(typeName) || typeName != null && typeName.contains("[") && typeName.contains("]")) {
            result = true;
        }
        return result;
    }

    public static boolean isInvalidPropertyType(String typeName) {
        return VOID.equals(typeName) || NULL.equals(typeName) || STATIC.equals(typeName) || NEVER.equals(typeName);
    }

    public static List<String> getTypesForEditor() {
        return TYPES_FOR_EDITOR;
    }

    public static List<String> getSpecialTypesForType() {
        return SPECIAL_TYPES_FOR_TYPE;
    }

    public static List<String> getTypesForReturnType() {
        return TYPES_FOR_RETURN_TYPE;
    }

    public static List<String> getTypesForFieldType() {
        return TYPES_FOR_FIELD_TYPE;
    }

    public static List<String> getTypesForPhpDoc() {
        return TYPES_FOR_PHP_DOC;
    }

    public static List<String> getTypesForBackingType() {
        return TYPES_FOR_BACKING_TYPE;
    }

    public static String asUnionType(Collection<String> types) {
        return StringUtils.implode(types, (String)SEPARATOR);
    }

    public static String asIntersectionType(Collection<String> types) {
        return StringUtils.implode(types, (String)SEPARATOR_INTERSECTION);
    }

    public static List<String> getMixedType() {
        return MIXED_TYPE;
    }

    public static String getTypeSeparator(boolean isIntersection) {
        return isIntersection ? SEPARATOR_INTERSECTION : SEPARATOR;
    }

    public static enum Kind {
        NORMAL(""),
        NULLABLE("?"),
        UNION("|"),
        INTERSECTION("&");

        private final String sign;

        private Kind(String sing) {
            this.sign = sing;
        }

        public String getSign() {
            return this.sign;
        }

        public static Kind fromTypes(String types) {
            Kind kind = NORMAL;
            if (types.contains(Type.SEPARATOR)) {
                kind = UNION;
            } else if (types.contains(Type.SEPARATOR_INTERSECTION)) {
                kind = INTERSECTION;
            } else if (types.contains(NULLABLE.getSign())) {
                kind = NULLABLE;
            }
            return kind;
        }
    }
}

