/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.source.classpath.CacheClassPath;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ClasspathNavigatorProviderImpl
implements NavigatorPanel {
    private JComponent panel;
    private final ExplorerManager manager = new ExplorerManager();

    public String getDisplayName() {
        return NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"NM_Classpath");
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"SD_Classpath");
    }

    public JComponent getComponent() {
        if (this.panel == null) {
            final PropertySheetView view = new PropertySheetView();
            class Panel
            extends JPanel
            implements ExplorerManager.Provider,
            Lookup.Provider {
                private final Lookup lookup;

                Panel() {
                    this.lookup = ExplorerUtils.createLookup((ExplorerManager)ClasspathNavigatorProviderImpl.this.manager, (ActionMap)new ActionMap());
                    this.setLayout(new BorderLayout());
                    this.add((Component)view, "Center");
                }

                public ExplorerManager getExplorerManager() {
                    return ClasspathNavigatorProviderImpl.this.manager;
                }

                public Lookup getLookup() {
                    return this.lookup;
                }
            }
            this.panel = new Panel();
        }
        return this.panel;
    }

    public Lookup getLookup() {
        return null;
    }

    public void panelActivated(Lookup context) {
        FileObject file = (FileObject)context.lookup(FileObject.class);
        if (file != null) {
            try {
                ClasspathNodeImpl node = new ClasspathNodeImpl(file);
                this.manager.setRootContext((Node)node);
                this.manager.setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void panelDeactivated() {
        this.manager.setRootContext((Node)new AbstractNode(Children.LEAF));
    }

    private static final class ClasspathNodeImpl
    extends FilterNode {
        private final FileObject file;

        public ClasspathNodeImpl(FileObject file) throws DataObjectNotFoundException {
            super(DataObject.find((FileObject)file).getNodeDelegate(), FilterNode.Children.LEAF);
            this.file = file;
        }

        public Node.PropertySet[] getPropertySets() {
            Sheet sheet = new Sheet();
            Sheet.Set ps = new Sheet.Set();
            ps.setName("classpaths");
            ps.setDisplayName(NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"LBL_JavaNode_sheet_classpaths"));
            ps.setShortDescription(NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_sheet_classpaths"));
            ps.put(new Node.Property[]{new ClasspathProperty("classpath/compile", false, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_compile_classpath"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_compile_classpath")), new ClasspathProperty("modules/compile", false, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_module_compile_classpath"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_module_compile_classpath")), new ClasspathProperty("modules/classpath", false, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_module_classpath"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_module_classpath")), new ClasspathProperty("classpath/source", false, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_source_classpath"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_source_classpath")), new ClasspathProperty("modules/source", false, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_module_sourcepath"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_module_sourcepath")), new ClasspathProperty("classpath/boot", false, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_boot_classpath"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_boot_classpath")), new ClasspathProperty("modules/boot", false, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_module_boot_classpath"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_module_boot_classpath")), new ClasspathProperty("classpath/execute", false, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_execute_classpath"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_execute_classpath")), new ClasspathProperty("classpath/processor", false, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_processorpath"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_processorpath")), new ClasspathProperty("classpath/compile", true, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_compile_classpath_tr"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_compile_classpath_tr")), new ClasspathProperty("modules/compile", true, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_module_compile_classpath_tr"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_module_compile_classpath_tr")), new ClasspathProperty("modules/classpath", true, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_module_classpath_tr"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_module_classpath_tr")), new ClasspathProperty("classpath/source", true, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_source_classpath_tr"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_source_classpath_tr")), new ClasspathProperty("classpath/execute", true, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_execute_classpath_tr"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_execute_classpath_tr")), new ClasspathProperty("classpath/boot", true, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"PROP_JavaNode_boot_classpath_tr"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_JavaNode_boot_classpath_tr")), new PropertySupport.ReadOnly<String>("ClassPathDefiner", String.class, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"DN_ClassPathDefiner"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_ClassPathDefiner")){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    for (ClassPathProvider impl : Lookup.getDefault().lookupResult(ClassPathProvider.class).allInstances()) {
                        if (impl.findClassPath(file, "classpath/source") == null) continue;
                        return impl.getClass().getName();
                    }
                    return "<none>";
                }
            }, new PropertySupport.ReadOnly<String>("OwningProject", String.class, NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"DN_OwningProject"), NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"HINT_OwningProject")){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    Project prj = FileOwnerQuery.getOwner((FileObject)file);
                    if (prj != null) {
                        return prj.toString() + "(" + prj.getClass().getName() + ")";
                    }
                    return "<none>";
                }
            }});
            sheet.put(ps);
            return sheet.toArray();
        }

        private final class ClasspathProperty
        extends PropertySupport.ReadOnly<String> {
            private final String id;
            private final boolean translate;

            public ClasspathProperty(String id, boolean translate, String displayName, String shortDescription) {
                super(id + (translate ? "_tr" : ""), String.class, displayName, shortDescription);
                this.id = id;
                this.translate = translate;
                this.setValue("oneline", false);
            }

            public String getValue() {
                ClassPath cp = ClassPath.getClassPath((FileObject)ClasspathNodeImpl.this.file, (String)this.id);
                if (cp != null) {
                    if (this.translate) {
                        cp = "classpath/source".equals(this.id) ? CacheClassPath.forSourcePath((ClassPath)cp, (boolean)false) : CacheClassPath.forClassPath((ClassPath)cp, (boolean)false);
                    }
                    StringBuffer sb = new StringBuffer();
                    for (ClassPath.Entry entry : cp.entries()) {
                        URL u = entry.getURL();
                        String item = u.toExternalForm();
                        if (u.getProtocol().equals("file")) {
                            item = new File(URI.create(item)).getAbsolutePath();
                        } else if (u.getProtocol().equals("jar") && item.endsWith("!/")) {
                            URL embedded = FileUtil.getArchiveFile((URL)u);
                            assert (embedded != null) : u;
                            if (embedded.getProtocol().equals("file")) {
                                item = new File(URI.create(embedded.toExternalForm())).getAbsolutePath();
                            }
                        }
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(item);
                    }
                    return sb.toString();
                }
                return NbBundle.getMessage(ClasspathNavigatorProviderImpl.class, (String)"LBL_JavaNode_classpath_unknown");
            }
        }
    }
}

