/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.websvc.api.support.InvokeOperationCookie;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.core.WebServiceActionProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class InvokeOperationAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(InvokeOperationAction.class, (String)"LBL_CallWebServiceOperation");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        FileObject currentFO = this.getCurrentFileObject(activatedNodes[0]);
        return currentFO != null && WebServiceActionProvider.getInvokeOperationAction(currentFO) != null;
    }

    protected void performAction(Node[] activatedNodes) {
        FileObject currentFO;
        if (activatedNodes[0] != null && (currentFO = this.getCurrentFileObject(activatedNodes[0])) != null) {
            InvokeOperationCookie invokeCookie;
            InvokeOperationCookie invokeOp = WebServiceActionProvider.getInvokeOperationAction(currentFO);
            InvokeOperationCookie.ClientSelectionPanel serviceExplorer = invokeOp.getDialogDescriptorPanel();
            final DialogDescriptor descriptor = new DialogDescriptor((Object)serviceExplorer, NbBundle.getMessage(InvokeOperationAction.class, (String)"TTL_SelectOperation"));
            serviceExplorer.addPropertyChangeListener(InvokeOperationCookie.ClientSelectionPanel.PROPERTY_SELECTION_VALID, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    descriptor.setValid(((Boolean)evt.getNewValue()).booleanValue());
                }
            });
            descriptor.setValid(false);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            if (descriptor.getValue().equals(NotifyDescriptor.OK_OPTION) && (invokeCookie = WebServiceActionProvider.getInvokeOperationAction(currentFO)) != null) {
                String cookieClassName;
                JTextComponent target = Utilities.getFocusedComponent();
                if (target != null) {
                    invokeCookie.invokeOperation(serviceExplorer.getSelectedClient(), target);
                }
                Object[] params = new Object[]{(cookieClassName = invokeCookie.getClass().getName()).contains("jaxrpc") ? "JAX-RPC" : "JAX-WS", "CALL WS OPERATION"};
                LogUtils.logWsAction((Object[])params);
            }
        }
    }

    private FileObject getCurrentFileObject(Node n) {
        FileObject result = null;
        DataObject dobj = (DataObject)n.getCookie(DataObject.class);
        if (dobj != null) {
            result = dobj.getPrimaryFile();
        }
        return result;
    }
}

