/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.snaptracer.impl.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

final class AttachToBugAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(AttachToBugAction.class.getName());
    private static final String BUZILLA_CLASS = "org.netbeans.modules.bugzilla.api.NBBugzillaUtils";
    private static final String ATTACH_FILE_METHOD = "attachFiles";
    private static final String ICON_PATH = "org/netbeans/modules/profiler/snaptracer/impl/icons/bugtracking.png";
    private static final String NPSS_MINE = "application/x-npss";
    private static Method ATTACH_FILE;
    private final File snapshotFile;

    static boolean isSupported() {
        try {
            Class<?> bugzilla = Class.forName(BUZILLA_CLASS, true, Thread.currentThread().getContextClassLoader());
            ATTACH_FILE = bugzilla.getMethod(ATTACH_FILE_METHOD, String.class, String.class, String[].class, String[].class, File[].class);
        }
        catch (NoSuchMethodException ex) {
            LOG.log(Level.FINE, "isSupported", ex);
        }
        catch (SecurityException ex) {
            LOG.log(Level.FINE, "isSupported", ex);
        }
        catch (ClassNotFoundException ex) {
            LOG.log(Level.FINE, "isSupported", ex);
        }
        return ATTACH_FILE != null;
    }

    AttachToBugAction(File file) {
        this.snapshotFile = file;
        assert (file.isFile());
        this.putValue("Name", Bundle.AttachToBugAction_ActionName());
        this.putValue("ShortDescription", Bundle.AttachToBugAction_ActionDescr());
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)ICON_PATH, (boolean)true));
        this.putValue("iconBase", ICON_PATH);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IssueNumberDialog issue = new IssueNumberDialog();
                String bugNumber = issue.getIssueString();
                if (bugNumber != null) {
                    AttachToBugAction.attachtoBug(bugNumber, AttachToBugAction.this.snapshotFile);
                }
            }
        });
    }

    private static void attachtoBug(final String bugNumber, final File targetFile) {
        final ProgressHandle progress = ProgressHandle.createHandle((String)Bundle.AttachToBugAction_ProgressMsg());
        progress.setInitialDelay(500);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                progress.start();
                try {
                    String[] comments = new String[]{Bundle.AttachToBugAction_FileDescription()};
                    String[] contentType = new String[]{AttachToBugAction.NPSS_MINE};
                    File[] files = new File[]{targetFile};
                    ATTACH_FILE.invoke(null, bugNumber, Bundle.AttachToBugAction_Description(), comments, contentType, files);
                }
                catch (IllegalAccessException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Throwable oex = ex.getTargetException();
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "attachtoBug", oex);
                    ProfilerDialogs.displayError((String)Bundle.AttachToBugAction_AttachFailedMsg(oex.getLocalizedMessage()));
                    ProfilerLogger.log((String)("Failed to attach NPSS snapshot: " + oex.getMessage()));
                }
                finally {
                    progress.finish();
                }
            }
        });
    }

    private static class IssueNumberDialog
    extends JPanel {
        private JButton okButton;
        private JLabel issueLabel;
        private JTextField issueField;

        private IssueNumberDialog() {
            this.initComponents();
        }

        public String getIssueString() {
            DialogDescriptor dd = new DialogDescriptor((Object)this, Bundle.IssueNumberDialog_DialogCaption(), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
            if (dd.getValue() == this.okButton) {
                return Integer.toString(Integer.parseInt(this.issueField.getText().trim()));
            }
            return null;
        }

        private void initComponents() {
            this.issueLabel = new JLabel();
            this.issueField = new JTextField();
            this.okButton = new JButton();
            this.setLayout(new GridBagLayout());
            this.issueLabel.setLabelFor(this.issueField);
            Mnemonics.setLocalizedText((JLabel)this.issueLabel, (String)Bundle.IssueNumberDialog_LabelString());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(15, 10, 0, 10);
            gridBagConstraints.anchor = 17;
            this.add((Component)this.issueLabel, gridBagConstraints);
            this.issueField.getAccessibleContext().setAccessibleDescription(Bundle.IssueNumberDialog_FieldAccessDescr());
            this.issueField.setSelectionColor(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
            this.issueField.setSelectedTextColor(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
            this.issueField.setPreferredSize(new Dimension(150, this.issueField.getPreferredSize().height));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(15, 0, 0, 10);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            this.add((Component)this.issueField, gridBagConstraints);
            this.issueField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateOkButton();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateOkButton();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateOkButton();
                }
            });
            Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)Bundle.IssueNumberDialog_ButtonName());
            this.updateOkButton();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            this.add((Component)new JPanel(), gridBagConstraints);
        }

        private void updateOkButton() {
            String number = this.issueField.getText().trim();
            try {
                int n;
                if (!number.isEmpty() && (n = Integer.parseInt(number)) > 0 && n < 1000000) {
                    this.okButton.setEnabled(true);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.okButton.setEnabled(false);
        }
    }
}

