/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.client.SecurityParams;
import org.netbeans.modules.websvc.rest.client.XmlDomUtils;
import org.netbeans.modules.websvc.rest.client.XmlStaxUtils;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.model.jaxb.FieldDescriptor;
import org.netbeans.modules.websvc.saas.model.jaxb.MethodDescriptor;
import org.netbeans.modules.websvc.saas.model.jaxb.ServletDescriptor;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

class Wadl2JavaHelper {
    private static final String PROP_XML_SCHEMA = "xml_schema";
    private static final String PROP_PACKAGE_NAME = "package_name";
    private static final String PROP_SOURCE_ROOT = "source_root";
    private static final String SIGN_PARAMS_METHOD = "signParams";
    static final String PROJEC_TYPE_WEB = "web";
    static final String PROJEC_TYPE_WEB_EE7 = "web-ee7";
    static final String PROJEC_TYPE_DESKTOP = "desktop";
    static final String PROJEC_TYPE_NB_MODULE = "nb-module";

    Wadl2JavaHelper() {
    }

    static Pair<String> getParamList(List<String> requiredParams, Map<String, String> fixedParams) {
        StringBuilder paramNames = new StringBuilder();
        StringBuilder paramValues = new StringBuilder();
        boolean first = true;
        for (String string : requiredParams) {
            if (first) {
                first = false;
            } else {
                paramNames.append(",");
                paramValues.append(",");
            }
            paramNames.append("\"");
            paramNames.append(string);
            paramNames.append("\"");
            paramValues.append(Wadl2JavaHelper.makeJavaIdentifier(string));
        }
        for (Map.Entry entry : fixedParams.entrySet()) {
            String p = (String)entry.getKey();
            if (first) {
                first = false;
            } else {
                paramNames.append(",");
                paramValues.append(",");
            }
            paramNames.append("\"");
            paramNames.append(p);
            paramNames.append("\"");
            paramValues.append("\"");
            paramNames.append((String)entry.getValue());
            paramNames.append("\"");
        }
        return new Pair<String>(paramNames.toString(), paramValues.toString());
    }

    static Pair<String> getParamList(List<String> requiredParams, Map<String, String> fixedParams, SecurityParams securityParams) {
        StringBuffer paramNames = new StringBuffer();
        StringBuffer paramValues = new StringBuffer();
        boolean first = true;
        for (String p : requiredParams) {
            if (Wadl2JavaHelper.isSignatureParam(p, securityParams)) continue;
            if (first) {
                first = false;
            } else {
                paramNames.append(",");
                paramValues.append(",");
            }
            paramNames.append("\"" + p + "\"");
            if (Wadl2JavaHelper.isSecurityParam(p, securityParams)) {
                paramValues.append(Wadl2JavaHelper.findGetterForParam(p, securityParams.getMethodDescriptors()));
                continue;
            }
            paramValues.append(Wadl2JavaHelper.makeJavaIdentifier(p));
        }
        for (String p : fixedParams.keySet()) {
            if (Wadl2JavaHelper.isSignatureParam(p, securityParams)) continue;
            if (first) {
                first = false;
            } else {
                paramNames.append(",");
                paramValues.append(",");
            }
            paramNames.append("\"" + p + "\"");
            if (Wadl2JavaHelper.isSecurityParam(p, securityParams)) {
                paramValues.append(Wadl2JavaHelper.findGetterForParam(p, securityParams.getMethodDescriptors()));
                continue;
            }
            paramValues.append("\"" + fixedParams.get(p) + "\"");
        }
        return new Pair<String>(paramNames.toString(), paramValues.toString());
    }

    static String makeJavaIdentifier(String s) {
        int len = s.length();
        String result = s;
        for (int i = 0; i < len; ++i) {
            char ch = result.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            result = result.replace(ch, '_');
        }
        if (len > 0) {
            if (!Character.isJavaIdentifierStart(result.charAt(0))) {
                result = "_" + result;
            }
            result = result.substring(0, 1).toLowerCase() + result.substring(1);
        }
        return result;
    }

    static String getClientClassName(WadlSaasResource saasResource) {
        String path = saasResource.getResource().getPath();
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            char ch = path.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            path = path.replace(ch, '_');
        }
        while (path.startsWith("_")) {
            path = path.substring(1);
        }
        while (path.endsWith("_")) {
            path = path.substring(0, path.length() - 1);
        }
        String saasName = saasResource.getSaas().getDisplayName();
        if ((saasName = saasName.replace(" ", "_")).length() == 0) {
            saasName = "Resource";
        } else if (!Character.isJavaIdentifierStart(saasName.charAt(0))) {
            saasName = "Resource_" + saasName;
        } else if (Character.isLowerCase(saasName.charAt(0))) {
            saasName = saasName.substring(0, 1).toUpperCase() + saasName.substring(1);
        }
        return saasName + (path.length() == 0 ? "" : "_" + path) + "_JerseyClient";
    }

    static void generateJaxb(FileObject targetFo, WadlSaas wadlSaas) throws IOException {
        FileObject srcRoot;
        List schemaFiles;
        FileObject buildXml;
        Project project = FileOwnerQuery.getOwner((FileObject)targetFo);
        if (project != null && (buildXml = project.getProjectDirectory().getFileObject("build.xml")) != null && (schemaFiles = wadlSaas.getLocalSchemaFiles()).size() > 0 && (srcRoot = Wadl2JavaHelper.findSourceRootForFile(project, targetFo)) != null) {
            XmlStaxUtils staxUtils = new XmlStaxUtils();
            String saasDir = Wadl2JavaHelper.getSourceRootPath(project, srcRoot);
            String packagePrefix = wadlSaas.getPackageName();
            String targetName = "saas.xjc." + packagePrefix;
            try {
                boolean isXjcTarget = staxUtils.isTarget(buildXml, targetName);
                if (!isXjcTarget) {
                    NotifyDescriptor.Confirmation dd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(Wadl2JavaHelper.class, (String)"MSG_CreateJaxbArtifacts", (Object[])new Object[]{targetName, saasDir}), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                    if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                        FileObject metaInf = srcRoot.getFileObject("META-INF");
                        if (metaInf == null) {
                            metaInf = srcRoot.createFolder("META-INF");
                        }
                        String[] xmlSchemas = new String[schemaFiles.size()];
                        String[] packageNames = new String[schemaFiles.size()];
                        boolean isInitTarget = staxUtils.isTarget(buildXml, "saas-init-xjc");
                        int i = 0;
                        for (FileObject schemaFile : schemaFiles) {
                            if (metaInf != null && metaInf.isFolder() && metaInf.getFileObject(schemaFile.getNameExt()) == null) {
                                FileUtil.copyFile((FileObject)schemaFile, (FileObject)metaInf, (String)schemaFile.getName());
                                xmlSchemas[i] = saasDir + "/META-INF/" + schemaFile.getNameExt();
                            } else {
                                xmlSchemas[i] = schemaFile.getPath();
                            }
                            packageNames[i++] = packagePrefix + "." + SaasUtil.toValidJavaName((String)schemaFile.getName()).toLowerCase();
                        }
                        XmlDomUtils.addJaxbXjcTargets(buildXml, targetName, saasDir, xmlSchemas, packageNames, isInitTarget, PROJEC_TYPE_NB_MODULE.equals(Wadl2JavaHelper.getProjectType(project)));
                        for (FileObject schemaFile : schemaFiles) {
                            ExecutorTask executorTask = ActionUtils.runTarget((FileObject)buildXml, (String[])new String[]{targetName}, null);
                        }
                    }
                }
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(Wadl2JavaHelper.class.getName()).log(Level.WARNING, "Can not parse wadl file", ex);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(Wadl2JavaHelper.class.getName()).log(Level.WARNING, "Can not configure parser for wadl file", ex);
            }
            catch (SAXException ex) {
                Logger.getLogger(Wadl2JavaHelper.class.getName()).log(Level.WARNING, "Can not parse wadl file", ex);
            }
        }
    }

    static String getProjectType(Project project) {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            int projectType = restSupport.getProjectType();
            if (projectType == 1) {
                return PROJEC_TYPE_WEB;
            }
            if (projectType == 2) {
                return PROJEC_TYPE_NB_MODULE;
            }
        } else {
            AuxiliaryConfiguration aux = ProjectUtils.getAuxiliaryConfiguration((Project)project);
            for (int i = 1; i < 10; ++i) {
                if (aux.getConfigurationFragment("data", "http://www.netbeans.org/ns/nb-module-project/" + String.valueOf(i), true) != null) {
                    return PROJEC_TYPE_NB_MODULE;
                }
                if (aux.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/" + String.valueOf(i), true) == null) continue;
                return PROJEC_TYPE_WEB;
            }
        }
        return PROJEC_TYPE_DESKTOP;
    }

    private static FileObject findSourceRootForFile(Project project, FileObject fo) {
        SourceGroup[] sourceGroups;
        for (SourceGroup sourceGroup : sourceGroups = SourceGroupSupport.getJavaSourceGroups(project)) {
            FileObject srcRoot = sourceGroup.getRootFolder();
            if (!FileUtil.isParentOf((FileObject)srcRoot, (FileObject)fo)) continue;
            return srcRoot;
        }
        return null;
    }

    private static String getSourceRootPath(Project project, FileObject srcRoot) {
        return FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)srcRoot);
    }

    static boolean isSecurityParam(String param, SecurityParams securityParams) {
        return securityParams.getParams().contains(param);
    }

    static boolean isSignatureParam(String param, SecurityParams securityParams) {
        return param.equals(securityParams.getSignature());
    }

    private static String findGetterForParam(String param, List<MethodDescriptor> methodDescriptors) {
        for (MethodDescriptor method : methodDescriptors) {
            if (!param.equals(method.getId())) continue;
            return method.getName() + "()";
        }
        return Wadl2JavaHelper.makeJavaIdentifier(param);
    }

    static ClassTree addSessionAuthMethods(WorkingCopy copy, ClassTree originalClass, SecurityParams securityParams) {
        ClassTree modifiedClass = originalClass;
        TreeMaker maker = copy.getTreeMaker();
        for (FieldDescriptor field : securityParams.getFieldDescriptors()) {
            ModifiersTree fieldModifiers = maker.Modifiers(Wadl2JavaHelper.getModifiers(field.getModifiers()));
            ExpressionTree fieldType = JavaSourceHelper.createTypeTree(copy, field.getType());
            VariableTree fieldTree = maker.Variable(fieldModifiers, (CharSequence)field.getName(), (Tree)fieldType, null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)fieldTree);
        }
        for (MethodDescriptor m : securityParams.getMethodDescriptors()) {
            String body;
            ModifiersTree methodModifiers = maker.Modifiers(Wadl2JavaHelper.getModifiers(m.getModifiers()));
            ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
            String pList = m.getParamNames();
            if (pList != null) {
                List<String> paramN = Wadl2JavaHelper.getList(pList);
                List<String> paramT = Wadl2JavaHelper.getList(m.getParamTypes());
                ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
                for (int i = 0; i < paramN.size(); ++i) {
                    ExpressionTree paramTypeTree = JavaSourceHelper.createTypeTree(copy, paramT.get(i));
                    VariableTree paramTree = maker.Variable(paramModifier, (CharSequence)paramN.get(i), (Tree)paramTypeTree, null);
                    paramList.add(paramTree);
                }
            }
            ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
            String tList = m.getThrows();
            if (tList != null) {
                for (String thr : Wadl2JavaHelper.getList(tList)) {
                    throwsList.add(JavaSourceHelper.createTypeTree(copy, thr));
                }
            }
            if ((body = m.getBody()) == null) {
                String bodyTemplate = m.getBodyRef();
                if (bodyTemplate != null) {
                    body = Wadl2JavaHelper.getMethodBody(bodyTemplate);
                }
                if (body == null) {
                    body = "void".equals(m.getReturnType()) ? "{}" : "{return null;}";
                }
            }
            MethodTree methodTree = maker.Method(methodModifiers, (CharSequence)m.getName(), (Tree)JavaSourceHelper.createTypeTree(copy, m.getReturnType()), Collections.emptyList(), paramList, throwsList, body, null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
        }
        return modifiedClass;
    }

    private static List<String> getList(String s) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(s, ",");
        while (tokens.hasMoreTokens()) {
            list.add(tokens.nextToken().trim());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getMethodBody(String templatePath) {
        FileObject templateFo = FileUtil.getConfigFile((String)templatePath);
        if (templateFo != null) {
            String string;
            StringWriter writer;
            block10: {
                InputStreamReader is = null;
                writer = null;
                try {
                    int b;
                    is = new InputStreamReader(templateFo.getInputStream(), StandardCharsets.UTF_8);
                    writer = new StringWriter();
                    char[] buffer = new char[1024];
                    while ((b = is.read(buffer)) != -1) {
                        writer.write(buffer, 0, b);
                    }
                    string = writer.toString();
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (writer != null) {
                            writer.close();
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        return null;
                    }
                }
                is.close();
            }
            if (writer != null) {
                writer.close();
            }
            return string;
        }
        return null;
    }

    private static Set<Modifier> getModifiers(String modif) {
        HashSet<Modifier> modifs = new HashSet<Modifier>();
        if (modif != null) {
            if (modif.contains("public")) {
                modifs.add(Modifier.PUBLIC);
            } else if (modif.contains("protected")) {
                modifs.add(Modifier.PROTECTED);
            } else if (modif.contains("private")) {
                modifs.add(Modifier.PRIVATE);
            }
            if (modif.contains("static")) {
                modifs.add(Modifier.STATIC);
            }
            if (modif.contains("final")) {
                modifs.add(Modifier.FINAL);
            }
        }
        return modifs;
    }

    static ClassTree addSessionAuthServlets(WorkingCopy copy, ClassTree originalClass, SecurityParams securityParams, boolean annotateServlet) {
        ClassTree modifiedClass = originalClass;
        TreeMaker maker = copy.getTreeMaker();
        TypeElement servletAn = copy.getElements().getTypeElement("javax.servlet.annotation.WebServlet");
        for (ServletDescriptor classDescriptor : securityParams.getServletDescriptors()) {
            ClassTree innerClass;
            String className = classDescriptor.getClassName();
            ModifiersTree classModifiers = maker.Modifiers(Wadl2JavaHelper.getModifiers(classDescriptor.getModifiers()));
            if (annotateServlet && servletAn != null) {
                ArrayList<AssignmentTree> attrs = new ArrayList<AssignmentTree>();
                attrs.add(maker.Assignment((ExpressionTree)maker.Identifier((CharSequence)"name"), (ExpressionTree)maker.Literal((Object)className)));
                attrs.add(maker.Assignment((ExpressionTree)maker.Identifier((CharSequence)"urlPatterns"), (ExpressionTree)maker.Literal((Object)classDescriptor.getServletMapping())));
                AnnotationTree servletAnnotation = maker.Annotation((Tree)maker.QualIdent((Element)servletAn), attrs);
                classModifiers = maker.addModifiersAnnotation(classModifiers, servletAnnotation);
            }
            ExpressionTree extendsTree = JavaSourceHelper.createTypeTree(copy, "javax.servlet.http.HttpServlet");
            ClassTree modifiedInnerClass = innerClass = maker.Class(classModifiers, (CharSequence)className, Collections.emptyList(), (Tree)extendsTree, Collections.emptyList(), Collections.emptyList());
            for (MethodDescriptor m : classDescriptor.getMethodDescriptor()) {
                String body;
                ModifiersTree methodModifiers = maker.Modifiers(Wadl2JavaHelper.getModifiers(m.getModifiers()));
                ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
                String pList = m.getParamNames();
                if (pList != null) {
                    List<String> paramN = Wadl2JavaHelper.getList(pList);
                    List<String> paramT = Wadl2JavaHelper.getList(m.getParamTypes());
                    ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
                    for (int i = 0; i < paramN.size(); ++i) {
                        ExpressionTree paramTypeTree = JavaSourceHelper.createTypeTree(copy, paramT.get(i));
                        VariableTree paramTree = maker.Variable(paramModifier, (CharSequence)paramN.get(i), (Tree)paramTypeTree, null);
                        paramList.add(paramTree);
                    }
                }
                ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
                String tList = m.getThrows();
                if (tList != null) {
                    for (String thr : Wadl2JavaHelper.getList(tList)) {
                        throwsList.add(JavaSourceHelper.createTypeTree(copy, thr));
                    }
                }
                if ((body = m.getBody()) == null && (body = Wadl2JavaHelper.getMethodBody(m.getBodyRef())) == null) {
                    body = "void".equals(m.getReturnType()) ? "{}" : "{return null;}";
                }
                MethodTree methodTree = maker.Method(methodModifiers, (CharSequence)m.getName(), (Tree)JavaSourceHelper.createTypeTree(copy, m.getReturnType()), Collections.emptyList(), paramList, throwsList, body, null);
                modifiedInnerClass = maker.addClassMember(modifiedInnerClass, (Tree)methodTree);
            }
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)modifiedInnerClass);
        }
        return modifiedClass;
    }

    static class Pair<T> {
        private T key;
        private T value;

        public Pair(T key, T value) {
            this.key = key;
            this.value = value;
        }

        public T getKey() {
            return this.key;
        }

        public T getValue() {
            return this.value;
        }
    }
}

