/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jpath.expression;

import org.apache.taglibs.standard.lang.jpath.expression.SimpleNode;

public class ValidationException
extends Exception {
    protected boolean specialConstructor;
    public String image;
    protected SimpleNode node;
    protected String eol = System.getProperty("line.separator", "\n");

    public ValidationException() {
        this.specialConstructor = false;
    }

    public ValidationException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public ValidationException(SimpleNode currentNode, String message) {
        super(message);
        this.specialConstructor = true;
        this.node = currentNode;
    }

    public String getMessage() {
        int i;
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "";
        boolean maxSize = true;
        String retval = this.eol + "Encountered \"";
        retval = retval + super.getMessage();
        retval = retval + "\"" + this.eol;
        retval = retval + "at : " + this.eol;
        retval = retval + this.node.rootOriginalString() + this.eol;
        for (i = 0; i < this.node.firstToken.beginColumn - 1; ++i) {
            retval = retval + " ";
        }
        for (i = 0; i < this.node.lastToken.endColumn - (this.node.firstToken.beginColumn - 1); ++i) {
            retval = retval + "^";
        }
        retval = retval + this.eol;
        retval = retval + "beginning at column " + this.node.firstToken.beginColumn + "." + this.eol;
        retval = retval + "ending at column " + this.node.lastToken.endColumn + "." + this.eol;
        return retval;
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

