/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.completion;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.micronaut.completion.MicronautDataCompletionTask;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;

public final class MicronautDataCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        switch (queryType) {
            case 1: 
            case 9: {
                return new AsyncCompletionTask((AsyncCompletionQuery)new MicronautDataCompletionQuery(), component);
            }
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    private static class MicronautDataCompletionQuery
    extends AsyncCompletionQuery {
        private static final String ICON = "org/netbeans/modules/micronaut/resources/micronaut.png";

        private MicronautDataCompletionQuery() {
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            MicronautDataCompletionTask task = new MicronautDataCompletionTask();
            resultSet.addAllItems(task.query(doc, caretOffset, new MicronautDataCompletionTask.ItemFactory<CompletionItem>(){

                @Override
                public CompletionItem createFinderMethodItem(String name, String returnType, int offset) {
                    CompletionUtilities.CompletionItemBuilder builder = CompletionUtilities.newCompletionItemBuilder((String)name).iconResource(MicronautDataCompletionQuery.ICON).leftHtmlText("<b>" + name + "</b>").sortPriority(10);
                    if (returnType != null) {
                        builder.onSelect(ctx -> {
                            Document doc = ctx.getComponent().getDocument();
                            try {
                                doc.remove(offset, ctx.getComponent().getCaretPosition() - offset);
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            String template = "${PAR#1 default=\"" + returnType + "\"} " + name + "${cursor completionInvoke}()";
                            CodeTemplateManager.get((Document)doc).createTemporary(template).insert(ctx.getComponent());
                        });
                    } else {
                        builder.startOffset(offset);
                    }
                    return builder.build();
                }

                @Override
                public CompletionItem createFinderMethodNameItem(String prefix, String name, int offset) {
                    return CompletionUtilities.newCompletionItemBuilder((String)(prefix + name)).startOffset(offset).iconResource(MicronautDataCompletionQuery.ICON).leftHtmlText(prefix + "<b>" + name + "</b>").sortPriority(10).sortText((CharSequence)name).build();
                }

                @Override
                public CompletionItem createSQLItem(CompletionItem item) {
                    return item;
                }
            }));
            resultSet.setAnchorOffset(task.getAnchorOffset());
            resultSet.finish();
        }
    }
}

