/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.db;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.micronaut.db.Bundle;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;

public class MicronautController
implements TemplateWizard.Iterator {
    private WizardDescriptor.Panel panel;
    private WizardDescriptor wizardDescriptor;

    public static TemplateWizard.Iterator create() {
        return new MicronautController();
    }

    public static CreateFromTemplateHandler handler() {
        return new CreateFromTemplateHandler(){

            protected boolean accept(CreateDescriptor desc) {
                return true;
            }

            protected List<FileObject> createFromTemplate(CreateDescriptor desc) throws IOException {
                try {
                    NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(Bundle.MSG_SelectControllerName(), Bundle.MSG_SelectControllerName());
                    if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine)) {
                        ArrayList<FileObject> generated = new ArrayList<FileObject>();
                        String name = inputLine.getInputText();
                        if (!name.isEmpty()) {
                            String controllerName = name.substring(0, 1).toUpperCase() + name.substring(1) + "Controller";
                            FileObject fo = MicronautController.generate(desc.getTarget(), controllerName);
                            if (fo != null) {
                                generated.add(fo);
                            }
                        }
                        return generated;
                    }
                }
                catch (Exception ex) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getMessage(), 0));
                }
                return Collections.emptyList();
            }
        };
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        FileObject fo;
        HashSet<DataObject> generated = new HashSet<DataObject>();
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)wiz);
        String targetName = Templates.getTargetName((WizardDescriptor)wiz);
        if (targetFolder != null && targetName != null && !targetName.isEmpty() && (fo = MicronautController.generate(targetFolder, targetName)) != null) {
            generated.add(DataObject.find((FileObject)fo));
        }
        return generated;
    }

    public void initialize(TemplateWizard wiz) {
        this.wizardDescriptor = wiz;
        Project project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        if (sourceGroups.length == 0) {
            sourceGroups = sources.getSourceGroups("generic");
            this.panel = Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups).create();
        } else {
            this.panel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups);
        }
        Wizards.mergeSteps((WizardDescriptor)wiz, (WizardDescriptor.Panel[])new WizardDescriptor.Panel[]{this.panel}, null);
    }

    public void uninitialize(TemplateWizard wiz) {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panel;
    }

    public String name() {
        return null;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private static FileObject generate(FileObject folder, String controllerName) {
        try {
            JavaSource js;
            FileObject fo = GenerationUtils.createClass((FileObject)folder, (String)controllerName, (String)Bundle.MSG_ControllerClass(controllerName));
            if (fo != null && (js = JavaSource.forFileObject((FileObject)fo)) != null) {
                js.runModificationTask(copy -> {
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    Tree origTree = copy.getCompilationUnit().getTypeDecls().get(0);
                    if (origTree.getKind() == Tree.Kind.CLASS) {
                        GenerationUtils gu = GenerationUtils.newInstance((WorkingCopy)copy);
                        TreeMaker tm = copy.getTreeMaker();
                        String name = controllerName.toLowerCase();
                        if (name.endsWith("controller")) {
                            name = name.substring(0, name.length() - 10);
                        }
                        List<ExpressionTree> annArgs = Collections.singletonList(gu.createAnnotationArgument(null, (Object)("/" + name.toLowerCase())));
                        ClassTree cls = gu.addAnnotation((ClassTree)origTree, gu.createAnnotation("io.micronaut.http.annotation.Controller", annArgs));
                        List<ExpressionTree> getAnnArgs = Arrays.asList(gu.createAnnotationArgument("uri", (Object)"/"), gu.createAnnotationArgument("produces", (Object)"text/plain"));
                        ModifiersTree mods = tm.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(gu.createAnnotation("io.micronaut.http.annotation.Get", getAnnArgs)));
                        MethodTree indexMethod = tm.Method(mods, (CharSequence)"index", (Tree)tm.QualIdent("java.lang.String"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{return \"Example Response\";}", null);
                        cls = tm.addClassMember(cls, (Tree)indexMethod);
                        copy.rewrite(origTree, (Tree)cls);
                    }
                }).commit();
            }
            return fo;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }
}

