/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.process;

import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.prep.CssPreprocessorType;
import org.netbeans.modules.css.prep.less.LessCssPreprocessor;
import org.netbeans.modules.css.prep.less.LessExecutable;
import org.netbeans.modules.css.prep.preferences.LessPreferences;
import org.netbeans.modules.css.prep.process.BaseProcessor;
import org.netbeans.modules.css.prep.util.InvalidExternalExecutableException;
import org.netbeans.modules.css.prep.util.UiUtils;
import org.netbeans.modules.css.prep.util.Warnings;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public final class LessProcessor
extends BaseProcessor {
    public LessProcessor(LessCssPreprocessor cssPreprocessor) {
        super(cssPreprocessor);
    }

    @Override
    protected boolean isEnabledInternal(Project project) {
        return LessPreferences.getInstance().isEnabled(project);
    }

    @Override
    protected boolean isSupportedFile(FileObject fileObject) {
        return CssPreprocessorType.LESS.getFileExtensions().contains(fileObject.getExt());
    }

    @Override
    protected boolean isPartial(FileObject fileObject) {
        return false;
    }

    @Override
    protected List<Pair<String, String>> getMappings(Project project) {
        return LessPreferences.getInstance().getMappings(project);
    }

    @Override
    protected String getCompilerOptions(Project project) {
        return LessPreferences.getInstance().getCompilerOptions(project);
    }

    @Override
    protected void compileInternal(Project project, File workDir, File source, File target, List<String> compilerOptions) {
        block3: {
            LessExecutable less = this.getLess(project);
            if (less == null) {
                return;
            }
            try {
                less.compile(workDir, source, target, compilerOptions);
            }
            catch (ExecutionException ex) {
                if (!Warnings.showWarning(CssPreprocessorType.LESS)) break block3;
                UiUtils.processExecutionException(ex);
            }
        }
    }

    @CheckForNull
    private LessExecutable getLess(Project project) {
        try {
            return LessExecutable.getDefault();
        }
        catch (InvalidExternalExecutableException ex) {
            this.cssPreprocessor.fireProcessingErrorOccured(project, ex.getLocalizedMessage());
            return null;
        }
    }
}

