/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.identity.model.CreateApiKeyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UploadApiKeyRequest
extends BmcRequest<CreateApiKeyDetails> {
    private String userId;
    private CreateApiKeyDetails createApiKeyDetails;
    private String opcRetryToken;

    @InternalSdk
    public CreateApiKeyDetails getBody$() {
        return this.createApiKeyDetails;
    }

    @ConstructorProperties(value={"userId", "createApiKeyDetails", "opcRetryToken"})
    UploadApiKeyRequest(String userId, CreateApiKeyDetails createApiKeyDetails, String opcRetryToken) {
        this.userId = userId;
        this.createApiKeyDetails = createApiKeyDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).createApiKeyDetails(this.createApiKeyDetails).opcRetryToken(this.opcRetryToken);
    }

    public String toString() {
        return "UploadApiKeyRequest(super=" + super.toString() + ", userId=" + this.getUserId() + ", createApiKeyDetails=" + this.getCreateApiKeyDetails() + ", opcRetryToken=" + this.getOpcRetryToken() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadApiKeyRequest)) {
            return false;
        }
        UploadApiKeyRequest other = (UploadApiKeyRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        CreateApiKeyDetails this$createApiKeyDetails = this.getCreateApiKeyDetails();
        CreateApiKeyDetails other$createApiKeyDetails = other.getCreateApiKeyDetails();
        if (this$createApiKeyDetails == null ? other$createApiKeyDetails != null : !((Object)this$createApiKeyDetails).equals(other$createApiKeyDetails)) {
            return false;
        }
        String this$opcRetryToken = this.getOpcRetryToken();
        String other$opcRetryToken = other.getOpcRetryToken();
        return !(this$opcRetryToken == null ? other$opcRetryToken != null : !this$opcRetryToken.equals(other$opcRetryToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UploadApiKeyRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        CreateApiKeyDetails $createApiKeyDetails = this.getCreateApiKeyDetails();
        result = result * 59 + ($createApiKeyDetails == null ? 43 : ((Object)$createApiKeyDetails).hashCode());
        String $opcRetryToken = this.getOpcRetryToken();
        result = result * 59 + ($opcRetryToken == null ? 43 : $opcRetryToken.hashCode());
        return result;
    }

    public String getUserId() {
        return this.userId;
    }

    public CreateApiKeyDetails getCreateApiKeyDetails() {
        return this.createApiKeyDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<UploadApiKeyRequest, CreateApiKeyDetails> {
        private String userId;
        private CreateApiKeyDetails createApiKeyDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UploadApiKeyRequest o) {
            this.userId(o.getUserId());
            this.createApiKeyDetails(o.getCreateApiKeyDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UploadApiKeyRequest build() {
            UploadApiKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateApiKeyDetails body) {
            this.createApiKeyDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder createApiKeyDetails(CreateApiKeyDetails createApiKeyDetails) {
            this.createApiKeyDetails = createApiKeyDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public UploadApiKeyRequest buildWithoutInvocationCallback() {
            return new UploadApiKeyRequest(this.userId, this.createApiKeyDetails, this.opcRetryToken);
        }

        public String toString() {
            return "UploadApiKeyRequest.Builder(userId=" + this.userId + ", createApiKeyDetails=" + this.createApiKeyDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

