/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.dirchooser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import org.netbeans.swing.dirchooser.DirectoryChooserUI;
import org.netbeans.swing.dirchooser.Module;
import org.openide.util.Utilities;

public class DelegatingChooserUI
extends ComponentUI {
    static final String USE_SHELL_FOLDER = "FileChooser.useShellFolder";
    static final String NB_USE_SHELL_FOLDER = "nb.FileChooser.useShellFolder";
    static final String START_TIME = "start.time";
    private static boolean firstTime = true;

    public static ComponentUI createUI(JComponent c) {
        ComponentUI compUI;
        JFileChooser fc = (JFileChooser)c;
        if (Utilities.isWindows()) {
            if (System.getProperty(NB_USE_SHELL_FOLDER) != null) {
                fc.putClientProperty(USE_SHELL_FOLDER, Boolean.getBoolean(NB_USE_SHELL_FOLDER));
            } else {
                String jv = System.getProperty("java.version");
                if ("1.6.0_02".compareToIgnoreCase(jv = jv.split("-", 2)[0]) <= 0 && "1.6.0_10".compareToIgnoreCase(jv) >= 0 && !Boolean.TRUE.equals(fc.getClientProperty(USE_SHELL_FOLDER))) {
                    fc.putClientProperty(USE_SHELL_FOLDER, Boolean.FALSE);
                }
            }
        }
        if (fc.getClientProperty(START_TIME) == null) {
            fc.putClientProperty(START_TIME, System.currentTimeMillis());
        }
        Class<?> chooser = DelegatingChooserUI.getCurChooser(fc);
        try {
            Method createUIMethod = chooser.getMethod("createUI", JComponent.class);
            compUI = (ComponentUI)createUIMethod.invoke(null, fc);
        }
        catch (Exception exc) {
            Logger.getLogger(DelegatingChooserUI.class.getName()).log(Level.FINE, "Could not instantiate custom chooser, fallbacking to Metal", exc);
            compUI = MetalFileChooserUI.createUI(c);
        }
        if (firstTime) {
            fc.addPropertyChangeListener("fileSelectionChanged", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    JFileChooser fileChooser = (JFileChooser)evt.getSource();
                    fileChooser.updateUI();
                }
            });
        }
        return compUI;
    }

    private static Class<?> getCurChooser(JFileChooser fc) {
        if (fc.getFileSelectionMode() == 1) {
            return DirectoryChooserUI.class;
        }
        return Module.getOrigChooser();
    }
}

