/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.ui;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import org.netbeans.modules.web.inspect.PageInspectorImpl;
import org.netbeans.modules.web.inspect.PageModel;
import org.netbeans.modules.web.inspect.ui.Bundle;
import org.netbeans.modules.web.inspect.ui.DomPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="DomTC", persistenceType=0, iconBase="org/netbeans/modules/web/inspect/resources/domElement.png")
public final class DomTC
extends TopComponent {
    public static final String ID = "DomTC";

    public DomTC() {
        this.setName(Bundle.CTL_DomTC());
        this.setToolTipText(Bundle.HINT_DomTC());
        this.setLayout(new BorderLayout());
        this.associateLookup((Lookup)new DomTCLookup());
        PageInspectorImpl.getDefault().addPropertyChangeListener(this.createInspectorListener());
        this.update();
    }

    private void update() {
        if (EventQueue.isDispatchThread()) {
            PageModel pageModel = PageInspectorImpl.getDefault().getPage();
            this.removeAll();
            DomPanel panel = new DomPanel(pageModel);
            this.add(panel);
            ((DomTCLookup)this.getLookup()).setPanel(panel);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DomTC.this.update();
                }
            });
        }
    }

    private PropertyChangeListener createInspectorListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("model".equals(propName)) {
                    DomTC.this.update();
                }
            }
        };
    }

    public boolean requestFocusInWindow() {
        return this.getComponent(0).requestFocusInWindow();
    }

    private class DomTCLookup
    extends ProxyLookup {
        private DomTCLookup() {
        }

        void setPanel(DomPanel panel) {
            Lookup lookup = ExplorerUtils.createLookup((ExplorerManager)panel.getExplorerManager(), (ActionMap)DomTC.this.getActionMap());
            this.setLookups(new Lookup[]{lookup});
        }
    }
}

