/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

public class ComboBoxTableCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    private JPanel editor;
    private boolean tableListenerAdded = false;
    private JTable table;
    private Runnable comboBoxFocusRequester;
    private Runnable comboBoxOpener;
    private int currentRow = -1;
    private Object prevItem;
    private Object initialValue;
    private boolean consumeComboBoxActionEvent = true;
    private EventObject startEditingEvent = null;

    public ComboBoxTableCellEditor(Object[] values, ListCellRenderer customRenderer) {
        super(new JComboBox());
        this.setItems(values);
        this.editor = new JPanel(new BorderLayout());
        this.setClickCountToStart(1);
        this.editor.addMouseListener(new MouseAdapter(){

            @Override
            public final void mousePressed(MouseEvent evt) {
                ComboBoxTableCellEditor.this.eventEditorMousePressed();
            }
        });
        JComboBox cb = this.getComboBox();
        if (customRenderer != null) {
            cb.setRenderer(customRenderer);
        }
        cb.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                ComboBoxTableCellEditor.this.eventComboBoxActionPerformed();
            }
        });
        this.comboBoxFocusRequester = new Runnable(){

            @Override
            public final void run() {
                ComboBoxTableCellEditor.this.getComboBox().requestFocus();
            }
        };
        this.comboBoxOpener = new Runnable(){

            @Override
            public final void run() {
                if (ComboBoxTableCellEditor.this.startEditingEvent instanceof MouseEvent) {
                    try {
                        ComboBoxTableCellEditor.this.getComboBox().setPopupVisible(true);
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public ComboBoxTableCellEditor(Object[] values) {
        this(values, null);
    }

    public ComboBoxTableCellEditor() {
        this(new Object[0], null);
    }

    public ComboBoxTableCellEditor(ListCellRenderer customRenderer) {
        this(new Object[0], customRenderer);
    }

    @Override
    public final Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int col) {
        if (!this.tableListenerAdded) {
            this.tableListenerAdded = true;
            this.table = table;
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public final void valueChanged(ListSelectionEvent evt) {
                    ComboBoxTableCellEditor.this.eventTableSelectionChanged();
                }
            });
        }
        this.currentRow = row;
        this.initialValue = value;
        return this.getEditorComponent(table, value, selected, row, col);
    }

    protected Component getEditorComponent(JTable table, Object value, boolean selected, int row, int col) {
        this.setSelectedItem(value);
        selected = table.isRowSelected(row);
        if (selected) {
            SwingUtilities.invokeLater(this.comboBoxFocusRequester);
            SwingUtilities.invokeLater(this.comboBoxOpener);
            return this.getComboBox();
        }
        this.editor.removeAll();
        return this.editor;
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        this.startEditingEvent = evt;
        if (evt instanceof MouseEvent && evt.getSource() instanceof JTable) {
            MouseEvent me = (MouseEvent)evt;
            JTable table = (JTable)me.getSource();
            Point pt = new Point(me.getX(), me.getY());
            int row = table.rowAtPoint(pt);
            int col = table.columnAtPoint(pt);
            Rectangle rec = table.getCellRect(row, col, false);
            if (me.getY() >= rec.y + rec.height || me.getX() >= rec.x + rec.width) {
                return false;
            }
        }
        return super.isCellEditable(evt);
    }

    @Override
    public Object getCellEditorValue() {
        return this.prevItem;
    }

    protected void setSelectedItem(Object item) {
        if (this.getComboBox().getSelectedItem() != item) {
            this.consumeComboBoxActionEvent = false;
            this.getComboBox().setSelectedItem(item);
            this.consumeComboBoxActionEvent = true;
        }
    }

    public final void setItems(Object[] items) {
        JComboBox cb = this.getComboBox();
        cb.removeAllItems();
        int n = items != null ? items.length : 0;
        for (int i = 0; i < n; ++i) {
            cb.addItem(items[i]);
        }
    }

    final void eventEditorMousePressed() {
        this.editor.add(this.getComboBox());
        this.editor.revalidate();
        SwingUtilities.invokeLater(this.comboBoxFocusRequester);
    }

    protected void eventTableSelectionChanged() {
        if (!this.table.isRowSelected(this.currentRow)) {
            this.stopCellEditing();
        }
    }

    protected void eventComboBoxActionPerformed() {
        Object item = this.getComboBox().getSelectedItem();
        if (item != null) {
            this.prevItem = item;
        }
        if (this.consumeComboBoxActionEvent) {
            this.stopCellEditing();
        }
    }

    public final JComboBox getComboBox() {
        return (JComboBox)this.getComponent();
    }

    public final Object getInitialValue() {
        return this.initialValue;
    }

    public final int getCurrentRow() {
        return this.currentRow;
    }
}

