/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.welcome.content.RSSEntityResolver;
import org.netbeans.modules.welcome.content.RSSFeed;
import org.openide.util.NbPreferences;
import org.openide.xml.XMLUtil;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CombinationRSSFeed
extends RSSFeed {
    private String url1;
    private String url2;
    private int maxItemCount;

    public CombinationRSSFeed(String url1, String url2, boolean showProxyButton, int maxItemCount) {
        super(showProxyButton);
        this.maxItemCount = maxItemCount;
        this.url1 = url1;
        this.url2 = url2;
    }

    @Override
    protected List<RSSFeed.FeedItem> buildItemList() throws SAXException, ParserConfigurationException, IOException {
        XMLReader reader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
        RSSFeed.FeedHandler handler = new RSSFeed.FeedHandler(this.getMaxItemCount());
        reader.setContentHandler(handler);
        reader.setEntityResolver(new RSSEntityResolver());
        reader.setErrorHandler(new RSSFeed.ErrorCatcher());
        reader.parse(this.findInputSource(new URL(this.url1)));
        ArrayList<RSSFeed.FeedItem> res = new ArrayList<RSSFeed.FeedItem>(2 * this.getMaxItemCount());
        res.addAll(handler.getItemList());
        handler = new RSSFeed.FeedHandler(this.getMaxItemCount());
        reader.setContentHandler(handler);
        reader.parse(this.findInputSource(new URL(this.url2)));
        res.addAll(handler.getItemList());
        List<RSSFeed.FeedItem> items = this.sortNodes(res);
        if (items.size() > this.getMaxItemCount()) {
            items = items.subList(0, this.getMaxItemCount());
        }
        return items;
    }

    private ArrayList<RSSFeed.FeedItem> sortNodes(ArrayList<RSSFeed.FeedItem> res) {
        Collections.sort(res, new DateFeedItemComparator());
        return res;
    }

    @Override
    protected void clearCache() {
        try {
            NbPreferences.forModule(RSSFeed.class).remove(this.url2path(new URL(this.url1)));
            NbPreferences.forModule(RSSFeed.class).remove(this.url2path(new URL(this.url2)));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    protected int getMaxItemCount() {
        return this.maxItemCount;
    }

    private static class DateFeedItemComparator
    implements Comparator<RSSFeed.FeedItem> {
        private static DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        private static DateFormat dateFormatLong = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        private static DateFormat dateFormatShort = new SimpleDateFormat("EEE, dd MMM yyyy", Locale.ENGLISH);

        private DateFeedItemComparator() {
        }

        @Override
        public int compare(RSSFeed.FeedItem item1, RSSFeed.FeedItem item2) {
            Date date1 = this.extractDate(item1);
            Date date2 = this.extractDate(item2);
            if (null == date1 && null == date2) {
                return 0;
            }
            if (null == date1) {
                return 1;
            }
            if (null == date2) {
                return -1;
            }
            if (date1.after(date2)) {
                return -1;
            }
            if (date1.before(date2)) {
                return 1;
            }
            return 0;
        }

        private Date extractDate(RSSFeed.FeedItem item) {
            try {
                if (null != item.dateTime) {
                    return dateFormat.parse(item.dateTime);
                }
            }
            catch (ParseException pE) {
                try {
                    return dateFormatShort.parse(item.dateTime);
                }
                catch (ParseException otherPE) {
                    try {
                        return dateFormatLong.parse(item.dateTime);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
    }
}

