/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.HashSet;
import javax.swing.text.Document;
import org.codehaus.groovy.ast.ClassNode;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionContext;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;

public class SpockUtils {
    public static boolean isInSpecificationClass(CompletionContext context) {
        ClassNode classNode = context.declaringClass;
        if (classNode == null) {
            return false;
        }
        ParserResult pr = context.getParserResult();
        if (pr != null && pr instanceof GroovyParserResult) {
            GroovyParserResult gpr = (GroovyParserResult)pr;
            ClassNode specCN = gpr.resolveClassName("spock.lang.Specification");
            if (specCN != null) {
                if (classNode.isDerivedFrom(specCN)) {
                    return true;
                }
            } else {
                String name;
                HashSet<String> visited = new HashSet<String>();
                while (classNode != null && !visited.contains(name = classNode.getName())) {
                    if ("spock.lang.Specification".equals(name)) {
                        return true;
                    }
                    visited.add(name);
                    classNode = classNode.getSuperClass();
                }
            }
        }
        return false;
    }

    static boolean isFirstStatement(CompletionContext request) {
        TokenSequence<GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence((Document)request.doc, 1);
        if (ts != null) {
            ts.move(request.lexOffset);
            if (ts.movePrevious()) {
                while (ts.isValid() && ts.movePrevious() && ts.offset() >= 0) {
                    Token t = ts.token();
                    if (t.id() == GroovyTokenId.NLS || t.id() == GroovyTokenId.WHITESPACE || t.id() == GroovyTokenId.SH_COMMENT || t.id() == GroovyTokenId.SL_COMMENT || t.id() == GroovyTokenId.BLOCK_COMMENT || t.id() == GroovyTokenId.LINE_COMMENT) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

