/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints.lsp;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.lsp.Diagnostic;
import org.netbeans.modules.editor.hints.AnnotationHolder;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.lsp.ErrorProvider;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

public class HintsDiagnosticsProvider
implements ErrorProvider {
    public List<? extends Diagnostic> computeErrors(ErrorProvider.Context context) {
        FileObject file = context.file();
        AnnotationHolder ah = AnnotationHolder.getInstance(file);
        if (ah == null) {
            return null;
        }
        Document doc = ah.getDocument();
        if (!(doc instanceof LineDocument)) {
            return null;
        }
        int reportOffset = context.getOffset();
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        block5: for (ErrorDescription d : ah.getErrors()) {
            PositionBounds range = d.getRange();
            if (reportOffset > 0 && range.getBegin().getOffset() > reportOffset || range.getEnd().getOffset() <= reportOffset) continue;
            Diagnostic.Builder b = Diagnostic.Builder.create(() -> ((PositionRef)range.getBegin()).getOffset(), () -> ((PositionRef)range.getEnd()).getOffset(), (String)d.getDescription());
            b.setCode(d.getId());
            switch (d.getSeverity()) {
                case ERROR: 
                case VERIFIER: {
                    if (context.errorKind() != ErrorProvider.Kind.ERRORS) continue block5;
                    Diagnostic.Severity s = Diagnostic.Severity.Error;
                    break;
                }
                case WARNING: {
                    if (context.errorKind() != ErrorProvider.Kind.ERRORS) continue block5;
                    Diagnostic.Severity s = Diagnostic.Severity.Warning;
                    break;
                }
                case HINT: {
                    if (context.errorKind() != ErrorProvider.Kind.HINTS) continue block5;
                    Diagnostic.Severity s = Diagnostic.Severity.Hint;
                    break;
                }
                default: {
                    Diagnostic.Severity s = Diagnostic.Severity.Information;
                }
            }
            result.add(b.build());
        }
        return result;
    }
}

