/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.tm4e.core.grammar.IToken;
import org.eclipse.tm4e.core.grammar.StackElement;
import org.eclipse.tm4e.core.internal.grammar.ScopeListElement;
import org.eclipse.tm4e.core.internal.grammar.Token;

class LineTokens {
    private static final Logger LOGGER = Logger.getLogger(LineTokens.class.getName());
    private final String lineText;
    private final List<IToken> tokens;
    private boolean emitBinaryTokens;
    private final List<Integer> binaryTokens;
    private int lastTokenEndIndex;

    LineTokens(boolean emitBinaryTokens, String lineText) {
        this.emitBinaryTokens = emitBinaryTokens;
        String string = this.lineText = LOGGER.isLoggable(Level.FINEST) ? lineText : null;
        if (this.emitBinaryTokens) {
            this.tokens = null;
            this.binaryTokens = new ArrayList<Integer>();
        } else {
            this.tokens = new ArrayList<IToken>();
            this.binaryTokens = null;
        }
        this.lastTokenEndIndex = 0;
    }

    public void produce(StackElement stack, int endIndex) {
        this.produceFromScopes(stack.contentNameScopesList, endIndex);
    }

    public void produceFromScopes(ScopeListElement scopesList, int endIndex) {
        if (this.lastTokenEndIndex >= endIndex) {
            return;
        }
        if (this.emitBinaryTokens) {
            int metadata = scopesList.metadata;
            if (!this.binaryTokens.isEmpty() && this.binaryTokens.get(this.binaryTokens.size() - 1) == metadata) {
                this.lastTokenEndIndex = endIndex;
                return;
            }
            this.binaryTokens.add(this.lastTokenEndIndex);
            this.binaryTokens.add(metadata);
            this.lastTokenEndIndex = endIndex;
            return;
        }
        List<String> scopes = scopesList.generateScopes();
        if (this.lineText != null) {
            LOGGER.info("  token: |" + this.lineText.substring(this.lastTokenEndIndex, endIndex).replaceAll("\n", "\\n") + '|');
            for (String scope : scopes) {
                LOGGER.info("      * " + scope);
            }
        }
        this.tokens.add(new Token(this.lastTokenEndIndex, endIndex, scopes));
        this.lastTokenEndIndex = endIndex;
    }

    public IToken[] getResult(StackElement stack, int lineLength) {
        if (!this.tokens.isEmpty() && this.tokens.get(this.tokens.size() - 1).getStartIndex() == lineLength - 1) {
            this.tokens.remove(this.tokens.size() - 1);
        }
        if (this.tokens.isEmpty()) {
            this.lastTokenEndIndex = -1;
            this.produce(stack, lineLength);
            this.tokens.get(this.tokens.size() - 1).setStartIndex(0);
        }
        return this.tokens.toArray(new IToken[0]);
    }

    public int[] getBinaryResult(StackElement stack, int lineLength) {
        if (!this.binaryTokens.isEmpty() && this.binaryTokens.get(this.binaryTokens.size() - 2) == lineLength - 1) {
            this.binaryTokens.remove(this.binaryTokens.size() - 1);
            this.binaryTokens.remove(this.binaryTokens.size() - 1);
        }
        if (this.binaryTokens.isEmpty()) {
            this.lastTokenEndIndex = -1;
            this.produce(stack, lineLength);
            this.binaryTokens.set(this.binaryTokens.size() - 2, 0);
        }
        int[] result = new int[this.binaryTokens.size()];
        int len = this.binaryTokens.size();
        for (int i = 0; i < len; ++i) {
            result[i] = this.binaryTokens.get(i);
        }
        return result;
    }
}

