/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.editor.lib.api.ProblemDescription;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.plain.AttributeElement;
import org.netbeans.modules.html.editor.lib.plain.AttributelessOpenTagElement;
import org.netbeans.modules.html.editor.lib.plain.CommentElement;
import org.netbeans.modules.html.editor.lib.plain.DeclarationElement;
import org.netbeans.modules.html.editor.lib.plain.EndTagElement;
import org.netbeans.modules.html.editor.lib.plain.EntityReferenceElement;
import org.netbeans.modules.html.editor.lib.plain.ErrorElement;
import org.netbeans.modules.html.editor.lib.plain.LongOpenTagElement;
import org.netbeans.modules.html.editor.lib.plain.OpenTagElement;
import org.netbeans.modules.html.editor.lib.plain.ProblematicAttributelessOpenTagElement;
import org.netbeans.modules.html.editor.lib.plain.ProblematicOpenTagElement;
import org.netbeans.modules.html.editor.lib.plain.TextElement;
import org.netbeans.modules.web.common.api.LexerUtils;

public class ElementsParser
implements Iterator<Element> {
    private int state;
    private static final int S_INIT = 0;
    private static final int S_TAG_OPEN_SYMBOL = 1;
    private static final int S_TAG = 2;
    private static final int S_TAG_ATTR = 3;
    private static final int S_TAG_VALUE = 4;
    private static final int S_COMMENT = 5;
    private static final int S_DECLARATION = 6;
    private static final int S_DOCTYPE_DECLARATION = 7;
    private static final int S_DOCTYPE_AFTER_ROOT_ELEMENT = 8;
    private static final int S_DOCTYPE_PUBLIC_ID = 9;
    private static final int S_DOCTYPE_FILE = 10;
    private static final int S_TEXT = 11;
    private static final int S_TAG_AFTER_NAME = 12;
    public static final String UNEXPECTED_SYMBOL_IN_OPEN_TAG = "unexpected_symbol_in_open_tag";
    private CharSequence sourceCode;
    private TokenSequence<HTMLTokenId> ts;
    private Token<HTMLTokenId> token;
    private int start;
    private boolean openTag = true;
    private String tagName;
    private TokenInfo attrib;
    private List<TokenInfo> attr_keys;
    private List<List<TokenInfo>> attr_values;
    private Element current;
    private boolean eof;
    private AtomicReference<Element> lastFoundElement;
    private String root_element;
    private String doctype_public_id;
    private String doctype_file;
    private String doctype_name;
    private static final int SNIPPET_LEN = 100;

    private ElementsParser(CharSequence sourceCode, TokenSequence<HTMLTokenId> tokenSequence) {
        this.sourceCode = sourceCode;
        this.ts = tokenSequence;
        this.state = 0;
        this.start = -1;
        this.attr_keys = new ArrayList<TokenInfo>();
        this.attr_values = new ArrayList<List<TokenInfo>>();
        this.eof = false;
    }

    public static ElementsParser forOffset(CharSequence sourceCode, TokenSequence<HTMLTokenId> tokenSequence, int position) {
        if (position < 0) {
            throw new IllegalArgumentException(String.format("Position (%s) must be positive", position));
        }
        int diff = tokenSequence.move(position);
        if (diff != 0) {
            throw new IllegalArgumentException(String.format("Parser must be started at a token beginning, not in the middle (position=%s, token diff=%s, token=%s)", position, diff, tokenSequence.moveNext() ? tokenSequence.token() : null));
        }
        return new ElementsParser(sourceCode, tokenSequence);
    }

    public static ElementsParser forTokenIndex(CharSequence sourceCode, TokenSequence<HTMLTokenId> tokenSequence, int tokenIndex) {
        if (tokenIndex < 0) {
            throw new IllegalArgumentException(String.format("TokenSequence index (%s) must be positive", tokenIndex));
        }
        tokenSequence.moveEnd();
        int lastTokenIndex = tokenSequence.index();
        if (tokenIndex > lastTokenIndex) {
            throw new IllegalArgumentException(String.format("token index (%s) is bigger than last index in the sequence (%s)", tokenIndex, lastTokenIndex));
        }
        tokenSequence.moveIndex(tokenIndex);
        return new ElementsParser(sourceCode, tokenSequence);
    }

    @Override
    public boolean hasNext() {
        if (this.lastFoundElement == null) {
            this.lastFoundElement = new AtomicReference<Element>(this.findNextElement());
        }
        return this.lastFoundElement.get() != null;
    }

    @Override
    public Element next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("No such element");
        }
        Element element = this.lastFoundElement.get();
        this.lastFoundElement = null;
        return element;
    }

    @Override
    public void remove() {
    }

    private void error() {
        this.current = new ErrorElement(this.sourceCode, this.start, (short)(this.ts.offset() + this.ts.token().length() - this.start));
    }

    private void text() {
        this.current = new TextElement(this.start, this.ts.offset() + this.ts.token().length());
    }

    private void entityReference() {
        this.current = new EntityReferenceElement(this.sourceCode, this.start, (short)(this.ts.offset() + this.ts.token().length() - this.start));
    }

    private void comment() {
        this.current = new CommentElement(this.sourceCode, this.start, this.ts.offset() + this.ts.token().length() - this.start);
    }

    private void declaration() {
        this.current = new DeclarationElement(this.sourceCode, this.start, (short)(this.ts.offset() + this.ts.token().length() - this.start), this.root_element, this.doctype_public_id, this.doctype_file, this.doctype_name);
    }

    private void tag(boolean emptyTag) {
        this.tag(emptyTag, null);
    }

    private void tag(boolean emptyTag, ProblemDescription problem) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(1);
        for (int i = 0; i < this.attr_keys.size(); ++i) {
            TokenInfo key = this.attr_keys.get(i);
            List<TokenInfo> values = this.attr_values.get(i);
            StringBuilder joinedValue = new StringBuilder();
            if (values == null) {
                assert (key.token.length() < Short.MAX_VALUE);
                AttributeElement ta = new AttributeElement(this.sourceCode, key.offset, (short)key.token.length());
                attributes.add(ta);
                continue;
            }
            if (values.size() == 1) {
                TokenInfo ti = values.get(0);
                assert (key.token.length() < Short.MAX_VALUE);
                AttributeElement ta = new AttributeElement(this.sourceCode, key.offset, ti.offset, (short)key.token.length(), ti.token.length());
                attributes.add(ta);
                continue;
            }
            for (TokenInfo t : values) {
                joinedValue.append(t.token.text());
            }
            TokenInfo firstValuePart = values.get(0);
            TokenInfo lastValuePart = values.get(values.size() - 1);
            AttributeElement.AttributeElementWithJoinedValue ta = new AttributeElement.AttributeElementWithJoinedValue(this.sourceCode, key.offset, (short)key.token.length(), firstValuePart.offset, joinedValue.toString().intern());
            attributes.add(ta);
        }
        if (this.start == -1) {
            throw new IllegalStateException(this.getCodeSnippet());
        }
        int len = this.ts.offset() + this.ts.token().length() - this.start;
        if (len <= 0) {
            throw new IllegalStateException(this.getCodeSnippet());
        }
        this.current = this.openTag ? (attributes.isEmpty() ? (problem == null ? new AttributelessOpenTagElement(this.sourceCode, this.start, (short)len, (byte)this.tagName.length(), emptyTag) : new ProblematicAttributelessOpenTagElement(this.sourceCode, this.start, (short)len, (byte)this.tagName.length(), emptyTag, problem)) : (problem == null ? (len > Short.MAX_VALUE ? new LongOpenTagElement(this.sourceCode, this.start, len, (byte)this.tagName.length(), attributes, emptyTag) : new OpenTagElement(this.sourceCode, this.start, (short)len, (byte)this.tagName.length(), attributes, emptyTag)) : new ProblematicOpenTagElement(this.sourceCode, this.start, (short)len, (byte)this.tagName.length(), attributes, emptyTag, problem))) : new EndTagElement(this.sourceCode, this.start, (short)len, (byte)this.tagName.length());
        this.tagName = null;
        this.attrib = null;
        this.attr_keys = new ArrayList<TokenInfo>();
        this.attr_values = new ArrayList<List<TokenInfo>>();
    }

    private String getCodeSnippet() {
        int offset = this.ts.offset();
        int from = Math.max(0, offset - 50);
        int to = Math.min(this.sourceCode.length(), offset + 50);
        return this.sourceCode.subSequence(from, to).toString();
    }

    private void tag_with_error(ProblemDescription problem) {
        this.backup(1);
        this.tag(false, problem);
        this.state = 0;
        this.start = -1;
    }

    private void reset() {
        this.backup(1);
        this.error();
        this.state = 0;
        this.start = -1;
    }

    private void backup(int tokens) {
        for (int i = 0; i < tokens; ++i) {
            this.ts.movePrevious();
            this.token = this.ts.token();
        }
    }

    private Element findNextElement() {
        Element element = null;
        while (!this.eof && (element = this.processNextToken()) == null) {
        }
        return element;
    }

    private Element processNextToken() {
        this.current = null;
        if (!this.ts.moveNext()) {
            this.handleEOF();
            this.eof = true;
            return this.current;
        }
        int offset = this.ts.offset();
        this.token = this.ts.token();
        HTMLTokenId id = (HTMLTokenId)this.token.id();
        block0 : switch (this.state) {
            case 0: {
                switch (id) {
                    case CHARACTER: {
                        this.start = this.ts.offset();
                        this.entityReference();
                        this.state = 0;
                        this.start = -1;
                        break block0;
                    }
                    case TAG_OPEN_SYMBOL: {
                        this.start = this.ts.offset();
                        this.state = 1;
                        break block0;
                    }
                    case BLOCK_COMMENT: {
                        this.start = this.ts.offset();
                        this.state = 5;
                        break block0;
                    }
                    case DECLARATION: {
                        this.start = this.ts.offset();
                        if (LexerUtils.equals((CharSequence)"<!doctype", (CharSequence)this.token.text(), (boolean)true, (boolean)true)) {
                            this.root_element = null;
                            this.doctype_public_id = null;
                            this.doctype_file = null;
                            this.state = 7;
                        } else {
                            this.state = 6;
                        }
                        this.doctype_name = this.token.text().subSequence(2, this.token.text().length()).toString();
                        break block0;
                    }
                }
                this.start = this.ts.offset();
                this.state = 11;
                break;
            }
            case 11: {
                switch (id) {
                    case TEXT: {
                        break block0;
                    }
                }
                this.backup(1);
                this.text();
                this.state = 0;
                this.start = -1;
                break;
            }
            case 1: {
                switch (id) {
                    case TAG_OPEN: {
                        this.state = 12;
                        this.openTag = true;
                        this.tagName = this.token.text().toString();
                        break block0;
                    }
                    case TAG_CLOSE: {
                        this.state = 12;
                        this.openTag = false;
                        this.tagName = this.token.text().toString();
                        break block0;
                    }
                }
                this.reset();
                break;
            }
            case 12: {
                this.backup(1);
                this.state = 2;
                break;
            }
            case 2: {
                switch (id) {
                    case WS: 
                    case EOL: 
                    case ERROR: {
                        break block0;
                    }
                    case ARGUMENT: {
                        this.state = 3;
                        this.attrib = this.tokenInfo();
                        break block0;
                    }
                    case TAG_CLOSE_SYMBOL: {
                        boolean emptyTag = "/>".equals(this.token.text().toString());
                        this.tag(emptyTag);
                        this.state = 0;
                        this.start = -1;
                        break block0;
                    }
                }
                this.tag_with_error(ProblemDescription.create(UNEXPECTED_SYMBOL_IN_OPEN_TAG, String.format("Unexpected symbol '%s' found in the open tag", this.token.text()), 2, offset, offset + this.token.length()));
                break;
            }
            case 3: {
                switch (id) {
                    case WS: 
                    case OPERATOR: {
                        break block0;
                    }
                    case VALUE: 
                    case VALUE_JAVASCRIPT: 
                    case VALUE_CSS: {
                        this.backup(1);
                        this.state = 4;
                        break block0;
                    }
                    case ARGUMENT: 
                    case TAG_CLOSE_SYMBOL: {
                        this.attr_keys.add(this.attrib);
                        this.attr_values.add(null);
                        this.state = 2;
                        this.backup(1);
                        break block0;
                    }
                }
                this.tag_with_error(ProblemDescription.create(UNEXPECTED_SYMBOL_IN_OPEN_TAG, String.format("Unexpected symbol '%s' found in the open tag", this.token.text()), 2, offset, offset + this.token.length()));
                break;
            }
            case 4: {
                switch (id) {
                    case VALUE: 
                    case VALUE_JAVASCRIPT: 
                    case VALUE_CSS: 
                    case EL_OPEN_DELIMITER: 
                    case EL_CONTENT: 
                    case EL_CLOSE_DELIMITER: {
                        int index = this.attr_keys.indexOf(this.attrib);
                        if (index == -1) {
                            ArrayList<TokenInfo> values = new ArrayList<TokenInfo>();
                            values.add(this.tokenInfo());
                            this.attr_keys.add(this.attrib);
                            this.attr_values.add(values);
                            break;
                        }
                        List<TokenInfo> valueParts = this.attr_values.get(index);
                        if (valueParts == null) break block0;
                        valueParts.add(this.tokenInfo());
                        break;
                    }
                    case ERROR: {
                        this.tag_with_error(ProblemDescription.create(UNEXPECTED_SYMBOL_IN_OPEN_TAG, String.format("Unexpected symbol '%s' found in the open tag", this.token.text()), 2, offset, offset + this.token.length()));
                        break;
                    }
                    default: {
                        this.backup(1);
                        this.state = 2;
                        break;
                    }
                }
                break;
            }
            case 5: {
                switch (id) {
                    case BLOCK_COMMENT: 
                    case WS: 
                    case EOL: {
                        break block0;
                    }
                }
                this.backup(1);
                this.comment();
                this.state = 0;
                this.start = -1;
                break;
            }
            case 6: {
                switch (id) {
                    case DECLARATION: 
                    case WS: 
                    case EOL: 
                    case SGML_COMMENT: {
                        break block0;
                    }
                }
                this.backup(1);
                this.declaration();
                this.state = 0;
                this.start = -1;
                break;
            }
            case 7: {
                switch (id) {
                    case DECLARATION: {
                        this.root_element = this.token.text().toString();
                        this.state = 8;
                        break block0;
                    }
                    case WS: 
                    case EOL: 
                    case SGML_COMMENT: {
                        break block0;
                    }
                }
                this.backup(1);
                this.declaration();
                this.state = 0;
                this.start = -1;
                break;
            }
            case 8: {
                switch (id) {
                    case DECLARATION: {
                        if (LexerUtils.equals((CharSequence)"public", (CharSequence)this.token.text(), (boolean)true, (boolean)true)) {
                            this.doctype_public_id = new String();
                            this.state = 9;
                            break block0;
                        }
                        if (LexerUtils.equals((CharSequence)"system", (CharSequence)this.token.text(), (boolean)true, (boolean)true)) {
                            this.state = 10;
                            this.doctype_file = new String();
                            break block0;
                        }
                        if (this.token.text().charAt(0) != '>') break block0;
                        this.declaration();
                        this.state = 0;
                        this.start = -1;
                        break block0;
                    }
                    case WS: 
                    case EOL: 
                    case SGML_COMMENT: {
                        break block0;
                    }
                }
                this.backup(1);
                this.declaration();
                this.state = 0;
                this.start = -1;
                break;
            }
            case 9: {
                switch (id) {
                    case DECLARATION: 
                    case WS: {
                        String tokenText = this.token.text().toString();
                        if (tokenText.startsWith("\"")) {
                            tokenText = tokenText.substring(1);
                        }
                        if (tokenText.endsWith("\"")) {
                            tokenText = tokenText.substring(0, tokenText.length() - 1);
                            this.doctype_public_id = this.doctype_public_id + tokenText;
                            this.doctype_public_id = this.doctype_public_id.trim();
                            this.state = 10;
                            break block0;
                        }
                        this.doctype_public_id = this.doctype_public_id + tokenText;
                        break block0;
                    }
                    case EOL: 
                    case SGML_COMMENT: {
                        break block0;
                    }
                }
                this.backup(1);
                this.declaration();
                this.state = 0;
                this.start = -1;
                break;
            }
            case 10: {
                switch (id) {
                    case DECLARATION: {
                        this.doctype_file = this.token.text().toString();
                        this.state = 6;
                        break block0;
                    }
                    case WS: 
                    case EOL: 
                    case SGML_COMMENT: {
                        break block0;
                    }
                }
                this.backup(1);
                this.declaration();
                this.state = 0;
                this.start = -1;
            }
        }
        return this.current;
    }

    private void handleEOF() {
        if (this.state != 0) {
            switch (this.state) {
                case 5: {
                    this.comment();
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.declaration();
                    break;
                }
                case 11: {
                    this.text();
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.tag(false);
                    break;
                }
                case 12: {
                    this.tag(false);
                    break;
                }
                default: {
                    this.error();
                }
            }
        }
    }

    private TokenInfo tokenInfo() {
        return new TokenInfo(this.ts.offset(), this.token);
    }

    static final class TokenInfo {
        public int offset;
        public Token token;

        public TokenInfo(int offset, Token token) {
            this.offset = offset;
            this.token = token;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TokenInfo other = (TokenInfo)obj;
            if (this.offset != other.offset) {
                return false;
            }
            return this.token == other.token || this.token != null && this.token.equals((Object)other.token);
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + this.offset;
            hash = 37 * hash + (this.token != null ? this.token.hashCode() : 0);
            return hash;
        }
    }
}

