/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.ProjectGroup;
import org.netbeans.api.project.ui.ProjectGroupChangeListener;
import org.netbeans.modules.project.uiapi.OpenProjectsTrampoline;
import org.openide.explorer.ExplorerManager;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class BaseUtilities {
    private static final Logger LOG = Logger.getLogger(BaseUtilities.class.getName());
    @SuppressWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static ProjectGroupAccessor ACCESSOR = null;

    public static OpenProjectsTrampoline getOpenProjectsTrampoline() {
        OpenProjectsTrampoline instance = (OpenProjectsTrampoline)Lookup.getDefault().lookup(OpenProjectsTrampoline.class);
        return instance != null ? instance : DefaultOpenProjectsTrampoline.getInstance();
    }

    static {
        Class<ProjectGroup> c = ProjectGroup.class;
        try {
            Class.forName(c.getName(), true, c.getClassLoader());
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "very wrong, very wrong, yes indeed", ex);
        }
    }

    private static final class DefaultOpenProjectsTrampoline
    implements OpenProjectsTrampoline {
        private static final AtomicReference<DefaultOpenProjectsTrampoline> INSTANCE = new AtomicReference();
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final Collection<Project> open = new ArrayList<Project>();
        private Project main;

        private DefaultOpenProjectsTrampoline() {
        }

        @Override
        public Project[] getOpenProjectsAPI() {
            return this.open.toArray(new Project[this.open.size()]);
        }

        @Override
        public void openAPI(Project[] projects, boolean openRequiredProjects, boolean showProgress) {
            this.open.addAll(Arrays.asList(projects));
            this.pcs.firePropertyChange("openProjects", null, null);
        }

        @Override
        public void closeAPI(Project[] projects) {
            this.open.removeAll(Arrays.asList(projects));
            this.pcs.firePropertyChange("openProjects", null, null);
        }

        @Override
        public Future<Project[]> openProjectsAPI() {
            return RequestProcessor.getDefault().submit((Callable)new Callable<Project[]>(){

                @Override
                public Project[] call() {
                    return this.getOpenProjectsAPI();
                }
            });
        }

        @Override
        public Project getMainProject() {
            return this.main;
        }

        @Override
        public void setMainProject(Project project) {
            this.main = project;
            this.pcs.firePropertyChange("MainProject", null, null);
        }

        @Override
        public void addPropertyChangeListenerAPI(PropertyChangeListener listener, Object source) {
            this.pcs.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListenerAPI(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        @Override
        public void addProjectGroupChangeListenerAPI(ProjectGroupChangeListener listener) {
        }

        @Override
        public void removeProjectGroupChangeListenerAPI(ProjectGroupChangeListener listener) {
        }

        @Override
        public ProjectGroup getActiveProjectGroupAPI() {
            return null;
        }

        @NonNull
        static DefaultOpenProjectsTrampoline getInstance() {
            DefaultOpenProjectsTrampoline res = INSTANCE.get();
            if (res == null && !INSTANCE.compareAndSet(null, res = new DefaultOpenProjectsTrampoline())) {
                res = INSTANCE.get();
            }
            assert (res != null);
            return res;
        }

        @Override
        public ExplorerManager createLogicalView() {
            return new ExplorerManager();
        }

        @Override
        public ExplorerManager createPhysicalView() {
            return new ExplorerManager();
        }
    }

    public static abstract class ProjectGroupAccessor {
        public abstract ProjectGroup createGroup(String var1, Preferences var2);
    }
}

