/**
 * The CSSPrimitiveValue interface represents a single CSS value. This interface may be used to determine the value of a specific style property currently set in a block or to set a specific style property explicitly within the block. An instance of this interface might be obtained from the getPropertyCSSValue method of the CSSStyleDeclaration interface. A CSSPrimitiveValue object only occurs in a context of a CSS property.Conversions are allowed between absolute values (from millimeters to centimeters, from degrees to radians, and so on) but not between relative values. (For example, a pixel value cannot be converted to a centimeter value.) Percentage values can't be converted since they are relative to the parent value (or another property value). There is one exception for color percentage values: since a color percentage value is relative to the range 0-255, a color percentage value can be converted to a number; (see also the RGBColor interface).
 */
var CSSPrimitiveValue = {
}
/**
 * The value is a length (cm). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_CM
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_CM = new Number();

/**
 * The value is an identifier. The value can be obtained by using the getStringValue method.
 * @syntax CSSPrimitiveValue.CSS_IDENT
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_IDENT = new Number();

/**
 * The value is a number with an unknown dimension. The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_DIMENSION
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_DIMENSION = new Number();

/**
 * The value is not a recognized CSS2 value. The value can only be obtained by using the cssText attribute.
 * @syntax CSSPrimitiveValue.CSS_UNKNOWN
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_UNKNOWN = new Number();

/**
 * The value is a counter or counters function. The value can be obtained by using the getCounterValue method.
 * @syntax CSSPrimitiveValue.CSS_COUNTER
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_COUNTER = new Number();

/**
 * The value is an angle (rad). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_RAD
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_RAD = new Number();

/**
 * The value is a time (s). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_S
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_S = new Number();

/**
 * This method is used to get a float value in a specified unit. If this CSS value doesn't contain a float value or can't be converted into the specified unit, a DOMException is raised.
 * @syntax cSSPrimitiveValue.getFloatValue(unitType)
 * @param {Number} unitType A unit code to get the float value. The unit code can only be a float unit type (i.e. CSS_NUMBER, CSS_PERCENTAGE, CSS_EMS, CSS_EXS, CSS_PX, CSS_CM, CSS_MM, CSS_IN, CSS_PT, CSS_PC, CSS_DEG, CSS_RAD, CSS_GRAD, CSS_MS, CSS_S, CSS_HZ, CSS_KHZ, CSS_DIMENSION).
 * @returns {float} The float value in the specified unit.
 */
CSSPrimitiveValue.prototype.getFloatValue = function(unitType) {};

/**
 * The value is a length (in). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_IN
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_IN = new Number();

/**
 * The value is a length (pc). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_PC
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_PC = new Number();

/**
 * The value is a length (ems). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_EMS
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_EMS = new Number();

/**
 * The value is a frequency (kHz). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_KHZ
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_KHZ = new Number();

/**
 * The value is a time (ms). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_MS
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_MS = new Number();

/**
 * The value is a STRING. The value can be obtained by using the getStringValue method.
 * @syntax CSSPrimitiveValue.CSS_STRING
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_STRING = new Number();

/**
 * The value is a rect function. The value can be obtained by using the getRectValue method.
 * @syntax CSSPrimitiveValue.CSS_RECT
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_RECT = new Number();

/**
 * The value is a frequency (Hz). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_HZ
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_HZ = new Number();

/**
 * The value is an angle (grad). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_GRAD
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_GRAD = new Number();

/**
 * This method is used to get the Rect value. If this CSS value doesn't contain a rect value, a DOMException is raised. Modification to the corresponding style property can be achieved using the Rect interface.
 * @syntax cSSPrimitiveValue.getRectValue()
 * @returns {Rect} The Rect value.
 */
CSSPrimitiveValue.prototype.getRectValue = function() {};

/**
 * The value is a length (mm). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_MM
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_MM = new Number();

/**
 * A method to set the float value with a specified unit. If the property attached with this value can not accept the specified unit or the float value, the value will be unchanged and a DOMException will be raised.
 * @syntax cSSPrimitiveValue.setFloatValue(unitType, floatValue)
 * @param {Number} unitType A unit code as defined above. The unit code can only be a float unit type (i.e. CSS_NUMBER, CSS_PERCENTAGE, CSS_EMS, CSS_EXS, CSS_PX, CSS_CM, CSS_MM, CSS_IN, CSS_PT, CSS_PC, CSS_DEG, CSS_RAD, CSS_GRAD, CSS_MS, CSS_S, CSS_HZ, CSS_KHZ, CSS_DIMENSION).
 * @param {float} floatValue The new float value.
 * @returns {undefined} 
 */
CSSPrimitiveValue.prototype.setFloatValue = function(unitType,  floatValue) {};

/**
 * This method is used to get the RGB color. If this CSS value doesn't contain a RGB color value, a DOMException is raised. Modification to the corresponding style property can be achieved using the RGBColor interface.
 * @syntax cSSPrimitiveValue.getRGBColorValue()
 * @returns {RGBColor} the RGB color value.
 */
CSSPrimitiveValue.prototype.getRGBColorValue = function() {};

/**
 * The value is a length (exs). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_EXS
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_EXS = new Number();

/**
 * A method to set the string value with the specified unit. If the property attached to this value can't accept the specified unit or the string value, the value will be unchanged and a DOMException will be raised.
 * @syntax cSSPrimitiveValue.setStringValue(stringType, stringValue)
 * @param {Number} stringType A string code as defined above. The string code can only be a string unit type (i.e. CSS_STRING, CSS_URI, CSS_IDENT, and CSS_ATTR).
 * @param {String} stringValue The new string value.
 * @returns {undefined} 
 */
CSSPrimitiveValue.prototype.setStringValue = function(stringType,  stringValue) {};

/**
 * The value is a URI. The value can be obtained by using the getStringValue method.
 * @syntax CSSPrimitiveValue.CSS_URI
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_URI = new Number();

/**
 * The value is an angle (deg). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_DEG
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_DEG = new Number();

/**
 * The value is a RGB color. The value can be obtained by using the getRGBColorValue method.
 * @syntax CSSPrimitiveValue.CSS_RGBCOLOR
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_RGBCOLOR = new Number();

/**
 * The type of the value as defined by the constants specified above.
 * @syntax cSSPrimitiveValue.primitiveType
 * @returns {Number} 
 */
CSSPrimitiveValue.prototype.primitiveType = new Number();

/**
 * The value is a simple number. The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_NUMBER
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_NUMBER = new Number();

/**
 * The value is a length (px). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_PX
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_PX = new Number();

/**
 * This method is used to get the Counter value. If this CSS value doesn't contain a counter value, a DOMException is raised. Modification to the corresponding style property can be achieved using the Counter interface.
 * @syntax cSSPrimitiveValue.getCounterValue()
 * @returns {Counter} The Counter value.
 */
CSSPrimitiveValue.prototype.getCounterValue = function() {};

/**
 * The value is a attribute function. The value can be obtained by using the getStringValue method.
 * @syntax CSSPrimitiveValue.CSS_ATTR
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_ATTR = new Number();

/**
 * The value is a percentage. The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_PERCENTAGE
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_PERCENTAGE = new Number();

/**
 * This method is used to get the string value. If the CSS value doesn't contain a string value, a DOMException is raised. Note: Some properties (like 'font-family' or 'voice-family') convert a whitespace separated list of idents to a string.
 * @syntax cSSPrimitiveValue.getStringValue()
 * @returns {String} The string value in the current unit. The current primitiveType can only be a string unit type (i.e. CSS_STRING, CSS_URI, CSS_IDENT and CSS_ATTR).
 */
CSSPrimitiveValue.prototype.getStringValue = function() {};

/**
 * The value is a length (pt). The value can be obtained by using the getFloatValue method.
 * @syntax CSSPrimitiveValue.CSS_PT
 * @returns {Number} 
 * @static
 */
CSSPrimitiveValue.CSS_PT = new Number();

/**
 * Represents the CSSPrimitiveValue prototype object.
 * @syntax CSSPrimitiveValue.prototype
 * @static
 */
CSSPrimitiveValue.prototype;

