/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.glassfish.javaee.Hk2JaxRpcStack;
import org.netbeans.modules.glassfish.javaee.Hk2JaxWsStack;
import org.netbeans.modules.j2ee.deployment.common.api.J2eeLibraryTypeProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl2;
import org.netbeans.modules.j2ee.deployment.plugins.spi.support.LookupProviderSupport;
import org.netbeans.modules.javaee.specs.support.api.JaxRpc;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.javaee.specs.support.spi.JaxRsStackSupportImplementation;
import org.netbeans.modules.payara.jakartaee.Hk2DeploymentManager;
import org.netbeans.modules.payara.jakartaee.Hk2JpaSupportImpl;
import org.netbeans.modules.payara.jakartaee.Hk2LibraryProvider;
import org.netbeans.modules.payara.spi.ServerUtilities;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersionAPI;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.server.config.JavaEEProfile;
import org.netbeans.modules.payara.tooling.server.config.JavaSEPlatform;
import org.netbeans.modules.payara.tooling.server.config.ModuleType;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class Hk2JavaEEPlatformImpl
extends J2eePlatformImpl2 {
    private final Hk2DeploymentManager dm;
    private final LibraryImplementation lib = new J2eeLibraryTypeProvider().createLibrary();
    private final LibraryImplementation[] libraries = new LibraryImplementation[]{this.lib};
    private final String[] platforms;
    private final Profile[] profiles;
    private final J2eeModule.Type[] types;
    private final String displayName;
    private final String libraryName;
    private final String lookupKey;
    private FileChangeListener fcl;
    private final Lookup lkp;
    private final Hk2LibraryProvider libraryProvider;
    private static final String PERSISTENCE_PROV_ECLIPSELINK = "org.eclipse.persistence.jpa.PersistenceProvider";
    private static final String TOOL_WSCOMPILE = "wscompile";
    private static final String TOOL_JSR109 = "jsr109";
    private static final String TOOL_WSIMPORT = "wsimport";
    private static final String TOOL_WSGEN = "wsgen";
    private static final String TOOL_KEYSTORE = "keystore";
    private static final String TOOL_KEYSTORECLIENT = "keystoreClient";
    private static final String TOOL_TRUSTSTORE = "truststore";
    private static final String TOOL_TRUSTSTORECLIENT = "truststoreClient";
    private static final String TOOL_WSIT = "wsit";
    private static final String TOOL_JAXWSTESTER = "jaxws-tester";
    private static final String TOOL_APPCLIENTRUNTIME = "appClientRuntime";
    private static final String KEYSTORE_LOCATION = "config/keystore.jks";
    private static final String TRUSTSTORE_LOCATION = "config/cacerts.jks";
    private static final String EMBEDDED_EJB_CONTAINER_PATH = "lib/embedded/glassfish-embedded-static-shell.jar";
    private static final String SUN_ACC_XML = "sun-acc.xml";
    private static final String GF_ACC_XML = "glassfish-acc.xml";
    private static final RequestProcessor libInitThread = new RequestProcessor("init libs -- Hk2JavaEEPlatformImpl");

    private Lookup initLocalLookup() {
        String gfRootStr = this.dm.getProperties().getPayaraRoot();
        WSStack wsStack = WSStackFactory.createWSStack(JaxWs.class, (WSStackImplementation)new Hk2JaxWsStack(gfRootStr, (J2eePlatformImpl)this), (WSStack.Source)WSStack.Source.SERVER);
        WSStack rpcStack = WSStackFactory.createWSStack(JaxRpc.class, (WSStackImplementation)new Hk2JaxRpcStack(gfRootStr), (WSStack.Source)WSStack.Source.SERVER);
        PayaraServer server = this.dm.getCommonServerSupport().getInstance();
        Lookup baseLookup = Lookups.fixed((Object[])new Object[]{gfRootStr, new JaxRsStackSupportImpl(), wsStack, rpcStack, server, new Hk2JpaSupportImpl(server)});
        return LookupProviderSupport.createCompositeLookup((Lookup)baseLookup, (String)this.lookupKey);
    }

    public static String[] nbJavaSEProfiles(Set<JavaSEPlatform> sdkPlatforms) {
        int size = sdkPlatforms != null ? sdkPlatforms.size() : 0;
        String[] platforms = new String[size];
        if (size > 0) {
            int index = 0;
            for (JavaSEPlatform platform : sdkPlatforms) {
                platforms[index++] = platform.toString();
            }
        }
        return platforms;
    }

    public static Profile[] nbJavaEEProfiles(Set<JavaEEProfile> sdkProfiles) {
        Profile[] profiles;
        int sdkSize;
        int size = sdkSize = sdkProfiles != null ? sdkProfiles.size() : 0;
        for (JavaEEProfile sdkProfile : sdkProfiles) {
            switch (sdkProfile) {
                case v1_2: {
                    --size;
                }
            }
        }
        if (sdkSize > 0) {
            profiles = new Profile[size];
            int index = 0;
            for (JavaEEProfile sdkProfile : sdkProfiles) {
                switch (sdkProfile) {
                    case v1_3: {
                        profiles[index++] = Profile.J2EE_13;
                        break;
                    }
                    case v1_4: {
                        profiles[index++] = Profile.J2EE_14;
                        break;
                    }
                    case v1_5: {
                        profiles[index++] = Profile.JAVA_EE_5;
                        break;
                    }
                    case v1_6_web: {
                        profiles[index++] = Profile.JAVA_EE_6_WEB;
                        break;
                    }
                    case v1_6: {
                        profiles[index++] = Profile.JAVA_EE_6_FULL;
                        break;
                    }
                    case v1_7_web: {
                        profiles[index++] = Profile.JAVA_EE_7_WEB;
                        break;
                    }
                    case v1_7: {
                        profiles[index++] = Profile.JAVA_EE_7_FULL;
                        break;
                    }
                    case v1_8_web: {
                        profiles[index++] = Profile.JAVA_EE_8_WEB;
                        break;
                    }
                    case v1_8: {
                        profiles[index++] = Profile.JAVA_EE_8_FULL;
                        break;
                    }
                    case v8_0_0_web: {
                        profiles[index++] = Profile.JAKARTA_EE_8_WEB;
                        break;
                    }
                    case v8_0_0: {
                        profiles[index++] = Profile.JAKARTA_EE_8_FULL;
                        break;
                    }
                    case v9_0_0_web: {
                        profiles[index++] = Profile.JAKARTA_EE_9_WEB;
                        break;
                    }
                    case v9_0_0: {
                        profiles[index++] = Profile.JAKARTA_EE_9_FULL;
                        break;
                    }
                    case v9_1_0_web: {
                        profiles[index++] = Profile.JAKARTA_EE_9_1_WEB;
                        break;
                    }
                    case v9_1_0: {
                        profiles[index++] = Profile.JAKARTA_EE_9_1_FULL;
                    }
                }
            }
        } else {
            profiles = new Profile[]{};
        }
        return profiles;
    }

    public static J2eeModule.Type[] nbModuleTypes(Set<ModuleType> sdkModuleTypes) {
        int size = sdkModuleTypes != null ? sdkModuleTypes.size() : 0;
        J2eeModule.Type[] types = new J2eeModule.Type[size];
        if (size > 0) {
            int index = 0;
            for (ModuleType sdkType : sdkModuleTypes) {
                switch (sdkType) {
                    case EAR: {
                        types[index++] = J2eeModule.Type.EAR;
                        break;
                    }
                    case EJB: {
                        types[index++] = J2eeModule.Type.EJB;
                        break;
                    }
                    case CAR: {
                        types[index++] = J2eeModule.Type.CAR;
                        break;
                    }
                    case RAR: {
                        types[index++] = J2eeModule.Type.RAR;
                        break;
                    }
                    case WAR: {
                        types[index++] = J2eeModule.Type.WAR;
                    }
                }
            }
        }
        return types;
    }

    Set<String> platformsSetFromArray(String[] platforms) {
        int size = platforms != null ? platforms.length : 0;
        HashSet<String> platformSet = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            platformSet.add(platforms[i]);
        }
        return platformSet;
    }

    Set<Profile> profilesSetFromArray(Profile[] profiles) {
        int size = profiles != null ? profiles.length : 0;
        HashSet<Profile> profileSet = new HashSet<Profile>(size);
        for (int i = 0; i < size; ++i) {
            profileSet.add(profiles[i]);
        }
        return profileSet;
    }

    Set<J2eeModule.Type> moduleTypesSetFromArray(J2eeModule.Type[] moduleTypes) {
        int size = moduleTypes != null ? moduleTypes.length : 0;
        HashSet<J2eeModule.Type> moduleTypeSet = new HashSet<J2eeModule.Type>(size);
        for (int i = 0; i < size; ++i) {
            moduleTypeSet.add(moduleTypes[i]);
        }
        return moduleTypeSet;
    }

    public Hk2JavaEEPlatformImpl(Hk2DeploymentManager dm, String[] platforms, Profile[] profiles, J2eeModule.Type[] types, String displayName, String libraryName, String lookupKey) {
        this.dm = dm;
        this.platforms = platforms;
        this.profiles = profiles;
        this.types = types;
        this.displayName = displayName;
        this.libraryName = libraryName;
        this.lookupKey = lookupKey;
        this.lkp = this.initLocalLookup();
        this.libraryProvider = Hk2LibraryProvider.getProvider(dm.getCommonServerSupport().getInstance());
        this.addFcl();
        this.initLibraries();
    }

    private void addFcl() {
        if (null == this.fcl) {
            String path = (String)this.dm.getCommonServerSupport().getInstanceProperties().get("homefolder");
            File f = new File(path, "modules");
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
            if (null == fo) {
                Logger.getLogger("payara-jakartaee").log(Level.WARNING, "{0} did not exist but should", f.getAbsolutePath());
                return;
            }
            this.fcl = new FileChangeListener(){

                public void fileFolderCreated(FileEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileDataCreated(FileEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileChanged(FileEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileDeleted(FileEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileRenamed(FileRenameEvent fe) {
                    Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
                }

                public void fileAttributeChanged(FileAttributeEvent fe) {
                }
            };
            fo.addFileChangeListener(this.fcl);
        }
    }

    public boolean isToolSupported(String toolName) {
        if (PERSISTENCE_PROV_ECLIPSELINK.equals(toolName)) {
            return true;
        }
        if ("org.hibernate.ejb.HibernatePersistence".equals(toolName) || "oracle.toplink.essentials.PersistenceProvider".equals(toolName) || "kodo.persistence.PersistenceProviderImpl".equals(toolName) || "org.apache.openjpa.persistence.PersistenceProviderImpl".equals(toolName)) {
            return true;
        }
        if ("defaultPersistenceProviderJavaEE5".equals(toolName)) {
            return true;
        }
        if ("eclipseLinkPersistenceProviderIsDefault2.0".equals(toolName)) {
            return true;
        }
        String gfRootStr = this.dm.getProperties().getPayaraRoot();
        if ("embeddableejb".equals(toolName)) {
            File jar = new File(gfRootStr, EMBEDDED_EJB_CONTAINER_PATH);
            return jar.exists() && jar.isFile() && jar.canRead();
        }
        File wsLib = null;
        if (gfRootStr != null) {
            wsLib = ServerUtilities.getJarName((String)gfRootStr, (String)"webservices(|-osgi).jar");
        }
        if (wsLib != null && wsLib.exists()) {
            if (TOOL_WSGEN.equals(toolName)) {
                return true;
            }
            if (TOOL_WSIMPORT.equals(toolName)) {
                return true;
            }
            if (TOOL_WSIT.equals(toolName)) {
                return true;
            }
            if (TOOL_JAXWSTESTER.equals(toolName)) {
                return true;
            }
            if (TOOL_JSR109.equals(toolName)) {
                return true;
            }
            if (TOOL_KEYSTORE.equals(toolName)) {
                return true;
            }
            if (TOOL_KEYSTORECLIENT.equals(toolName)) {
                return true;
            }
            if (TOOL_TRUSTSTORE.equals(toolName)) {
                return true;
            }
            if (TOOL_TRUSTSTORECLIENT.equals(toolName)) {
                return true;
            }
            if (TOOL_WSCOMPILE.equals(toolName)) {
                return true;
            }
            if (TOOL_APPCLIENTRUNTIME.equals(toolName)) {
                return true;
            }
        }
        return false;
    }

    public File[] getToolClasspathEntries(String toolName) {
        String gfRootStr = this.dm.getProperties().getPayaraRoot();
        if (null != gfRootStr) {
            String domainDirName;
            if ("embeddableejb".equals(toolName)) {
                return new File[]{new File(gfRootStr, EMBEDDED_EJB_CONTAINER_PATH)};
            }
            if (TOOL_WSGEN.equals(toolName) || TOOL_WSIMPORT.equals(toolName)) {
                String[] entries = new String[]{"webservices(|-osgi).jar", "webservices-api(|-osgi).jar", "jaxb(|-osgi).jar", "jaxb-api(|-osgi).jar", "javax.activation.jar"};
                ArrayList<File> cPath = new ArrayList<File>();
                for (String entry : entries) {
                    File f = ServerUtilities.getWsJarName((String)gfRootStr, (String)entry);
                    if (f == null || !f.exists()) continue;
                    cPath.add(f);
                }
                return cPath.toArray(new File[cPath.size()]);
            }
            if (TOOL_WSCOMPILE.equals(toolName)) {
                String[] entries = new String[]{"webservices(|-osgi).jar"};
                ArrayList<File> cPath = new ArrayList<File>();
                for (String entry : entries) {
                    File f = ServerUtilities.getWsJarName((String)gfRootStr, (String)entry);
                    if (f == null || !f.exists()) continue;
                    cPath.add(f);
                }
                return cPath.toArray(new File[cPath.size()]);
            }
            File gfRoot = new File(gfRootStr);
            if (gfRoot.exists() && (domainDirName = this.dm.getProperties().getDomainDir()) != null) {
                File domainDir = new File(domainDirName);
                if (TOOL_KEYSTORE.equals(toolName) || TOOL_KEYSTORECLIENT.equals(toolName)) {
                    return new File[]{new File(domainDir, KEYSTORE_LOCATION)};
                }
                if (TOOL_TRUSTSTORE.equals(toolName) || TOOL_TRUSTSTORECLIENT.equals(toolName)) {
                    return new File[]{new File(domainDir, TRUSTSTORE_LOCATION)};
                }
            }
        } else {
            Logger.getLogger("payara-jakartaee").log(Level.INFO, "dm has no root???", new Exception());
        }
        return new File[0];
    }

    public Set<Profile> getSupportedProfiles() {
        return this.profilesSetFromArray(this.profiles);
    }

    public Set<Profile> getSupportedProfiles(J2eeModule.Type type) {
        return this.profilesSetFromArray(this.profiles);
    }

    public Set<J2eeModule.Type> getSupportedTypes() {
        return this.moduleTypesSetFromArray(this.types);
    }

    public File[] getPlatformRoots() {
        File server = this.getServerHome();
        if (server != null) {
            return new File[]{server};
        }
        return new File[0];
    }

    public File getServerHome() {
        return this.getExistingFolder(this.dm.getProperties().getPayaraRoot());
    }

    public File getDomainHome() {
        return this.getExistingFolder(this.dm.getProperties().getDomainDir());
    }

    public File getMiddlewareHome() {
        return this.getExistingFolder(this.dm.getProperties().getInstallRoot());
    }

    public LibraryImplementation[] getLibraries() {
        this.addFcl();
        return (LibraryImplementation[])this.libraries.clone();
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/hk2/resources/server.gif");
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Set getSupportedJavaPlatformVersions() {
        return this.platformsSetFromArray(this.platforms);
    }

    public JavaPlatform getJavaPlatform() {
        return null;
    }

    public void notifyLibrariesChanged() {
        this.initLibraries();
    }

    private void initLibraries() {
        libInitThread.post(new Runnable(){

            @Override
            public void run() {
                Hk2JavaEEPlatformImpl.this.libraryProvider.setJavaEELibraryImplementation(Hk2JavaEEPlatformImpl.this.lib, Hk2JavaEEPlatformImpl.this.libraryName);
                Hk2JavaEEPlatformImpl.this.firePropertyChange("libraries", null, Hk2JavaEEPlatformImpl.this.libraries.clone());
            }
        });
    }

    public Lookup getLookup() {
        return this.lkp;
    }

    private File getExistingFolder(String path) {
        File returnedElement;
        if (path != null && (returnedElement = new File(path)).exists()) {
            return returnedElement;
        }
        return null;
    }

    private String quotedString(String s) {
        return "\"" + s + "\"";
    }

    private PayaraPlatformVersionAPI getPFVersion() {
        PayaraPlatformVersionAPI version = null;
        try {
            version = this.dm.getCommonServerSupport().getInstance().getPlatformVersion();
        }
        catch (NullPointerException npe) {
            Logger.getLogger("payara-jakartaee").log(Level.INFO, "Caught NullPointerException in Hk2JavaEEPlatformImpl while checking Payara version", npe);
        }
        return version;
    }

    private String getAccConfigFile() {
        PayaraPlatformVersionAPI version = this.getPFVersion();
        String accConfigFile = version != null && version.isMinimumSupportedVersion() ? GF_ACC_XML : SUN_ACC_XML;
        StringBuilder sb = new StringBuilder("config".length() + 1 + accConfigFile.length());
        sb.append("config");
        sb.append(File.separatorChar);
        sb.append(accConfigFile);
        return sb.toString();
    }

    public String getToolProperty(String toolName, String propertyName) {
        if (TOOL_APPCLIENTRUNTIME.equals(toolName)) {
            File root = new File(this.dm.getProperties().getPayaraRoot());
            String domainPath = this.dm.getProperties().getDomainDir();
            if ("main.class".equals(propertyName)) {
                return "org.glassfish.appclient.client.AppClientFacade";
            }
            if ("main.class.args".equals(propertyName)) {
                return "${j2ee.appclient.tool.args}";
            }
            if ("jvm.opts".equals(propertyName)) {
                if (domainPath != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("-Djava.endorsed.dirs=");
                    sb.append(this.quotedString(new File(root, "lib/endorsed").getAbsolutePath()));
                    sb.append(File.pathSeparator);
                    sb.append(this.quotedString(new File(root, "modules/endorsed").getAbsolutePath()));
                    sb.append(" -javaagent:");
                    String url = (String)this.dm.getCommonServerSupport().getInstanceProperties().get("url");
                    File f = new File(root, "lib/gf-client.jar");
                    if (f.exists()) {
                        sb.append(this.quotedString(f.getAbsolutePath()));
                    } else {
                        sb.append(this.quotedString(new File(root, "modules/gf-client.jar").getAbsolutePath()));
                    }
                    sb.append("=mode=acscript,arg=-configxml,arg=");
                    sb.append(this.quotedString(new File(domainPath, this.getAccConfigFile()).getAbsolutePath()));
                    sb.append(",client=jar=");
                    return sb.toString();
                }
                return null;
            }
            if ("client.jar.location".equals(propertyName)) {
                if (domainPath != null) {
                    FileObject location = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(domainPath)));
                    if (location == null) {
                        return null;
                    }
                    return FileUtil.toFile((FileObject)location).getAbsolutePath() + File.separator + "generated" + File.separator + "xml";
                }
                return null;
            }
            if ("j2ee.appclient.args".equals(propertyName)) {
                return null;
            }
        }
        return null;
    }

    public Hk2LibraryProvider getLibraryProvider() {
        return this.libraryProvider;
    }

    private class JaxRsStackSupportImpl
    implements JaxRsStackSupportImplementation {
        private JaxRsStackSupportImpl() {
        }

        public boolean addJsr311Api(Project project) {
            Library library = Hk2JavaEEPlatformImpl.this.libraryProvider.getJaxRsLibrary();
            FileObject sourceRoot = this.getSourceRoot(project);
            if (library != null && sourceRoot != null) {
                try {
                    String classPathType = this.hasJee6Profile() ? "classpath/compile_only" : "classpath/compile";
                    return ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)sourceRoot, (String)classPathType);
                }
                catch (IOException | UnsupportedOperationException ex) {
                    return false;
                }
            }
            PayaraPlatformVersionAPI version = this.getPFVersion();
            try {
                if (version == null) {
                    return false;
                }
                if (version.getMajor() == 4) {
                    File javaxWsRs = ServerUtilities.getJarName((String)Hk2JavaEEPlatformImpl.this.dm.getProperties().getPayaraRoot(), (String)"javax.ws.rs-api.jar");
                    if (javaxWsRs == null || !javaxWsRs.exists()) {
                        return false;
                    }
                    return this.addJars(project, Collections.singletonList(Utilities.toURI((File)javaxWsRs).toURL()));
                }
            }
            catch (MalformedURLException ex) {
                return false;
            }
            return false;
        }

        public boolean extendsJerseyProjectClasspath(Project project) {
            Library library = Hk2JavaEEPlatformImpl.this.libraryProvider.getJerseyLibrary();
            FileObject sourceRoot = this.getSourceRoot(project);
            if (sourceRoot == null) {
                return false;
            }
            try {
                String classPathType = this.hasJee6Profile() ? "classpath/compile_only" : "classpath/compile";
                return ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)sourceRoot, (String)classPathType);
            }
            catch (IOException | UnsupportedOperationException ex) {
                return false;
            }
        }

        public void removeJaxRsLibraries(Project project) {
            Library library = Hk2JavaEEPlatformImpl.this.libraryProvider.getJerseyLibrary();
            FileObject sourceRoot = this.getSourceRoot(project);
            if (sourceRoot != null) {
                String[] classPathTypes;
                for (String type : classPathTypes = new String[]{"classpath/compile", "classpath/compile_only"}) {
                    try {
                        ProjectClassPathModifier.removeLibraries((Library[])new Library[]{library}, (FileObject)sourceRoot, (String)type);
                    }
                    catch (IOException | UnsupportedOperationException ex) {
                        Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, null, ex);
                    }
                }
            }
        }

        public void configureCustomJersey(Project project) {
        }

        public boolean isBundled(String classFqn) {
            List<URL> urls = Hk2JavaEEPlatformImpl.this.libraryProvider.getJerseyClassPathURLs();
            for (URL url : urls) {
                String path;
                FileObject root = URLMapper.findFileObject((URL)url);
                if (FileUtil.isArchiveFile((FileObject)root)) {
                    root = FileUtil.getArchiveRoot((FileObject)root);
                }
                if (root.getFileObject(path = classFqn.replace('.', '/') + ".class") == null) continue;
                return true;
            }
            return false;
        }

        private FileObject getSourceRoot(Project project) {
            SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            if (sourceGroups == null || sourceGroups.length < 1) {
                return null;
            }
            return sourceGroups[0].getRootFolder();
        }

        private boolean hasJee6Profile() {
            Set<Profile> profiles = Hk2JavaEEPlatformImpl.this.getSupportedProfiles();
            return profiles.contains(Profile.JAVA_EE_6_FULL) || profiles.contains(Profile.JAVA_EE_6_WEB);
        }

        private void addURL(Collection<URL> urls, File file) {
            if (file == null || !file.exists()) {
                return;
            }
            try {
                urls.add(Utilities.toURI((File)file).toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        private boolean addJars(Project project, Collection<URL> jars) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (URL url : jars) {
                if (!FileUtil.isArchiveFile((URL)url)) continue;
                urls.add(FileUtil.getArchiveRoot((URL)url));
            }
            SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            if (sourceGroups == null || sourceGroups.length < 1) {
                return false;
            }
            FileObject sourceRoot = sourceGroups[0].getRootFolder();
            try {
                String classPathType = this.hasJee6Profile() ? "classpath/compile_only" : "classpath/compile";
                ProjectClassPathModifier.addRoots((URL[])urls.toArray(new URL[urls.size()]), (FileObject)sourceRoot, (String)classPathType);
            }
            catch (IOException | UnsupportedOperationException ex) {
                return false;
            }
            return true;
        }

        private PayaraPlatformVersionAPI getPFVersion() {
            PayaraPlatformVersionAPI version = null;
            try {
                version = Hk2JavaEEPlatformImpl.this.dm.getCommonServerSupport().getInstance().getPlatformVersion();
            }
            catch (NullPointerException npe) {
                Logger.getLogger("payara-jakartaee").log(Level.INFO, "Caught NullPointerException in Hk2JavaEEPlatformImpl while checking Payara version", npe);
            }
            return version;
        }
    }
}

