/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.modules.projectimport.eclipse.core.ClassPathContainerResolver;
import org.netbeans.modules.projectimport.eclipse.core.DotClassPath;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.Link;
import org.netbeans.modules.projectimport.eclipse.core.Util;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.spi.DotClassPathEntry;
import org.netbeans.modules.projectimport.eclipse.core.spi.Facets;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeFactory;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class EclipseProject
implements Comparable {
    private static final Logger logger = Logger.getLogger(EclipseProject.class.getName());
    private static final Lookup.Result<? extends ProjectTypeFactory> projectTypeFactories = Lookup.getDefault().lookupResult(ProjectTypeFactory.class);
    private Boolean importSupported;
    private ProjectTypeFactory projectFactory;
    private Set<EclipseProject> projectsWeDependOn;
    static final String PROJECT_FILE = ".project";
    static final String CLASSPATH_FILE = ".classpath";
    private Workspace workspace;
    private String name;
    private boolean internal = true;
    private DotClassPath cp;
    private Set<String> natures;
    private List<Link> links;
    private final File projectDir;
    private final File cpFile;
    private final File prjFile;
    private String jdkDirectory;
    private List<String> importProblems = new ArrayList<String>();
    private Facets projectFacets;

    static EclipseProject createProject(File projectDir) {
        if (!EclipseUtils.isRegularProject(projectDir)) {
            logger.fine(projectDir + " doesn't contain regular Eclipse project.");
            return null;
        }
        return new EclipseProject(projectDir);
    }

    EclipseProject(File projectDir) {
        this.projectDir = projectDir;
        File f = new File(projectDir, CLASSPATH_FILE);
        this.cpFile = f.exists() ? f : null;
        this.prjFile = new File(projectDir, PROJECT_FILE);
    }

    void removeInvalidSourceRoots(List<String> projectImportProblems) {
        ArrayList<DotClassPathEntry> projectSources = new ArrayList<DotClassPathEntry>();
        for (DotClassPathEntry e : this.getSourceRoots()) {
            if (new File(e.getAbsolutePath()).exists()) {
                projectSources.add(e);
                continue;
            }
            projectImportProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_InvalidSourceRoot", (Object)e.getRawPath()));
        }
        this.cp.updateSourceRoots(projectSources);
    }

    void setFacets(Facets projectFacets) {
        this.projectFacets = projectFacets;
    }

    public Facets getFacets() {
        return this.projectFacets;
    }

    void setLinks(List<Link> links) {
        this.links = links;
    }

    List<Link> getLinks() {
        return this.links;
    }

    void setNatures(Set<String> natures) {
        this.natures = natures;
    }

    void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    void setClassPath(DotClassPath cp) {
        this.cp = cp;
        this.calculateAbsolutePaths();
        this.convertFileVariablesToFolderVariables();
        this.updateSourcePathAttribute();
        this.updateJavadocLocationAttribute();
        try {
            this.resolveContainers(new ArrayList<String>(), false);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public List<DotClassPathEntry> getClassPathEntries() {
        return this.cp.getClassPathEntries();
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    void setInternal(boolean internal) {
        this.internal = internal;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public File getDirectory() {
        return this.projectDir;
    }

    File getProjectFile() {
        return this.prjFile;
    }

    File getClassPathFile() {
        return this.cpFile;
    }

    public Set<String> getNatures() {
        return this.natures;
    }

    public boolean isImportSupported() {
        this.performRecognitionIfNeeded();
        return this.importSupported;
    }

    public ProjectTypeFactory getProjectTypeFactory() {
        this.performRecognitionIfNeeded();
        return this.projectFactory;
    }

    private ProjectTypeFactory.ProjectDescriptor getProjectDescriptor() {
        return new ProjectTypeFactory.ProjectDescriptor(this.getDirectory(), this.natures, this.projectFacets);
    }

    File getProjectFileLocation(String token) {
        if (!this.isImportSupported()) {
            return null;
        }
        return this.getProjectTypeFactory().getProjectFileLocation(this.getProjectDescriptor(), token);
    }

    private void performRecognitionIfNeeded() {
        if (this.importSupported == null) {
            this.importSupported = Boolean.FALSE;
            for (ProjectTypeFactory factory : projectTypeFactories.allInstances()) {
                if (!factory.canHandle(this.getProjectDescriptor())) continue;
                this.projectFactory = factory;
                this.importSupported = Boolean.TRUE;
                break;
            }
        }
    }

    public String getJDKDirectory() {
        if (this.jdkDirectory == null && this.workspace != null && this.cp.getJREContainer() != null) {
            logger.finest("Getting JDK directory for project " + this.getName());
            this.jdkDirectory = this.workspace.getJDKDirectory(this.cp.getJREContainer().getRawPath());
            logger.finest("Resolved JDK directory: " + this.jdkDirectory);
        }
        return this.jdkDirectory;
    }

    public List<DotClassPathEntry> getSourceRoots() {
        return this.cp.getSourceRoots();
    }

    public Set<EclipseProject> getProjects() {
        if (this.workspace != null && this.projectsWeDependOn == null) {
            this.projectsWeDependOn = new HashSet<EclipseProject>();
            for (DotClassPathEntry entry : this.getClassPathEntries()) {
                EclipseProject prj;
                if (entry.getKind() != DotClassPathEntry.Kind.PROJECT || (prj = this.workspace.getProjectByRawPath(entry.getRawPath())) == null) continue;
                this.projectsWeDependOn.add(prj);
            }
        }
        return this.projectsWeDependOn == null ? Collections.emptySet() : this.projectsWeDependOn;
    }

    void resolveContainers(List<String> importProblems, boolean importInProgress) throws IOException {
        for (DotClassPathEntry entry : this.cp.getClassPathEntries()) {
            if (entry.getKind() != DotClassPathEntry.Kind.CONTAINER) continue;
            ClassPathContainerResolver.resolve(this.workspace, entry, importProblems, importInProgress);
        }
    }

    void replaceContainers() {
        ArrayList<DotClassPathEntry> newCp = new ArrayList<DotClassPathEntry>();
        for (DotClassPathEntry entry : this.cp.getClassPathEntries()) {
            if (entry.getKind() != DotClassPathEntry.Kind.CONTAINER) {
                newCp.add(entry);
                continue;
            }
            List<DotClassPathEntry> repl = ClassPathContainerResolver.replaceContainerEntry(this, this.workspace, entry, this.importProblems);
            if (repl != null) {
                newCp.addAll(repl);
                continue;
            }
            newCp.add(entry);
        }
        this.cp.updateClasspath(newCp);
    }

    void setupEnvironmentVariables(List<String> importProblems) throws IOException {
        if (this.workspace == null) {
            return;
        }
        EditableProperties ep = PropertyUtils.getGlobalProperties();
        boolean changed = false;
        for (DotClassPathEntry entry : this.cp.getClassPathEntries()) {
            if (entry.getKind() != DotClassPathEntry.Kind.VARIABLE) continue;
            String s = EclipseUtils.splitVariable(entry.getRawPath())[0];
            Workspace.Variable v = this.getVariable(s);
            if (v != null) {
                s = "var." + PropertyUtils.getUsablePropertyName((String)s);
                if (ep.getProperty(s) == null) {
                    ep.setProperty(s, v.getLocation());
                    changed = true;
                    continue;
                }
                if (ep.getProperty(s).equals(v.getLocation())) continue;
                importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_IDEVariableMismatch", (Object)s, (Object)ep.getProperty(s), (Object)v.getLocation()));
                continue;
            }
            importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_IDEVariableNotFound", (Object)s));
            ep.setProperty(s, "");
            changed = true;
        }
        if (changed) {
            PropertyUtils.putGlobalProperties((EditableProperties)ep);
        }
    }

    void convertFileVariablesToFolderVariables() {
        if (this.workspace == null) {
            return;
        }
        for (DotClassPathEntry entry : this.cp.getClassPathEntries()) {
            String s;
            Workspace.Variable v;
            if (entry.getKind() != DotClassPathEntry.Kind.VARIABLE || (v = this.getVariable(s = EclipseUtils.splitVariable(entry.getRawPath())[0])) == null || !v.isFileVariable()) continue;
            entry.updateVariableValue(v.getName() + '/' + v.getFileName());
        }
    }

    private void updateSourcePathAttribute() {
        if (this.workspace == null) {
            return;
        }
        for (DotClassPathEntry entry : this.cp.getClassPathEntries()) {
            String resolvedPath;
            String sourcePath = entry.getProperty("sourcepath");
            if (sourcePath == null || (resolvedPath = EclipseProject.resolveSourcePathAttribute(sourcePath, this.workspace, true)) == null) continue;
            entry.updateSourcePath(resolvedPath);
        }
    }

    static String resolveSourcePathAttribute(String sourcePath, Workspace workspace, boolean useVariables) {
        String resolvedPath = EclipseProject.resolvePath(sourcePath, workspace);
        if (resolvedPath != null) {
            return resolvedPath;
        }
        for (Workspace.Variable v : workspace.getVariables()) {
            if (!sourcePath.startsWith(v.getName())) continue;
            String[] s = EclipseUtils.splitVariable(sourcePath);
            if (useVariables) {
                return "${" + s[0] + "}" + s[1];
            }
            return v.getLocation() + s[1];
        }
        return null;
    }

    private void updateJavadocLocationAttribute() {
        for (DotClassPathEntry entry : this.cp.getClassPathEntries()) {
            String javadoc = entry.getProperty("javadoc_location");
            if (javadoc == null) continue;
            entry.updateJavadoc(EclipseProject.resolveJavadocLocationAttribute(javadoc, this.workspace, this.importProblems, false));
        }
    }

    static String resolveJavadocLocationAttribute(String javadoc, Workspace workspace, List<String> importProblems, boolean returnURL) {
        URL u;
        String jarPath = null;
        if (javadoc.startsWith("jar:")) {
            jarPath = javadoc.substring(javadoc.indexOf("!/"));
            if (!jarPath.endsWith("/")) {
                jarPath = jarPath + "/";
            }
            javadoc = javadoc.substring(4, javadoc.indexOf("!/"));
        }
        if (javadoc.startsWith("platform:/resource")) {
            if (workspace == null) {
                importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_WorkspaceDependentProtocol", (Object)javadoc));
                return null;
            }
            String s = EclipseProject.resolvePath(javadoc.substring(18), workspace);
            if (s != null) {
                if (returnURL) {
                    try {
                        s = Utilities.toURI((File)new File(s)).toURL().toExternalForm();
                        if (jarPath != null) {
                            s = "jar:" + s + jarPath;
                        }
                        return s;
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return null;
                    }
                }
                if (jarPath != null) {
                    s = s + jarPath;
                }
                return s;
            }
        }
        if (javadoc.startsWith("platform")) {
            importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_UnsupportedProtocol", (Object)javadoc));
            return null;
        }
        if (javadoc.indexOf("file://") > -1 && javadoc.indexOf("file:////") == -1) {
            javadoc = javadoc.replaceFirst("file://", "file:////");
        }
        try {
            u = new URL(javadoc);
        }
        catch (MalformedURLException ex) {
            importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_UnsupportedJavadocLocation", (Object)javadoc));
            return null;
        }
        if (!"file".equals(u.getProtocol())) {
            importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_UnsupportedProtocol", (Object)u.toExternalForm()));
            return null;
        }
        try {
            if (returnURL) {
                if (jarPath != null) {
                    return "jar:" + u.toExternalForm() + jarPath;
                }
                return u.toExternalForm();
            }
            File f = Utilities.toFile((URI)u.toURI());
            String path = f.getPath();
            if (jarPath != null) {
                path = path + jarPath;
            }
            return path;
        }
        catch (URISyntaxException ex) {
            importProblems.add(NbBundle.getMessage(EclipseProject.class, (String)"MSG_JavadocCannotBeResolved", (Object)u.toExternalForm()));
            return null;
        }
    }

    public List<String> getImportProblems() {
        return this.importProblems;
    }

    private void calculateAbsolutePaths() {
        for (DotClassPathEntry entry : this.cp.getClassPathEntries()) {
            this.setAbsolutePathForEntry(entry);
        }
        for (DotClassPathEntry entry : this.cp.getSourceRoots()) {
            this.setAbsolutePathForEntry(entry);
        }
        this.setAbsolutePathForEntry(this.cp.getOutput());
    }

    public DotClassPathEntry getOutput() {
        return this.cp.getOutput();
    }

    private void setAbsolutePathForEntry(DotClassPathEntry entry) {
        String s;
        if (entry == null) {
            return;
        }
        entry.setAbsolutePath(null);
        if (entry.getKind() == DotClassPathEntry.Kind.CONTAINER) {
            return;
        }
        if (entry.getKind() == DotClassPathEntry.Kind.VARIABLE) {
            String[] var = EclipseUtils.splitVariable(entry.getRawPath());
            Workspace.Variable variable = this.getVariable(var[0]);
            if (variable != null) {
                entry.setAbsolutePath(variable.getLocation() + var[1]);
            } else {
                logger.warning("cannot resolve variable '" + var[0] + "'. used in project " + this.getProjectFile().getPath() + " in entry " + entry);
            }
            return;
        }
        if (entry.getKind() == DotClassPathEntry.Kind.PROJECT) {
            EclipseProject ep;
            if (this.workspace != null && (ep = this.workspace.getProjectByName(entry.getRawPath().substring(1))) != null) {
                entry.setAbsolutePath(ep.getDirectory().getAbsolutePath());
            }
            return;
        }
        boolean resolved = false;
        String path = entry.getRawPath();
        if (entry.getKind() == DotClassPathEntry.Kind.LIBRARY && this.workspace != null && (s = EclipseProject.resolvePath(path, this.workspace)) != null) {
            path = s;
            resolved = true;
        }
        if (!resolved && !Util.isAbsolutePath(path)) {
            path = this.projectDir.getAbsolutePath() + File.separator + path;
            resolved = true;
        }
        entry.setAbsolutePath(path);
    }

    private static String resolvePath(String path, Workspace workspace) {
        String[] s;
        EclipseProject ep;
        File f = new File(path);
        if (path.startsWith("/") && !f.exists() && (ep = workspace.getProjectByName((s = EclipseUtils.splitProject(path))[0])) != null) {
            String projectPath = ep.getDirectory().getAbsolutePath();
            String resolvedPath = EclipseProject.resolveLinkPath(s[1], ep.links);
            if (resolvedPath != null) {
                return resolvedPath;
            }
            return projectPath + s[1];
        }
        return null;
    }

    private static String resolveLinkPath(String path, List<Link> links) {
        if (path.startsWith("/") || path.startsWith("\\")) {
            path = path.substring(1);
        }
        for (Link l : links) {
            if (!path.startsWith(l.getName())) continue;
            return l.getLocation() + path.substring(l.getName().length());
        }
        return null;
    }

    private Workspace.Variable getVariable(String rawPath) {
        if (this.workspace == null) {
            logger.fine("Workspace wasn't set for the project \"" + this.getName() + "\"");
            return null;
        }
        return this.workspace.getVariable(rawPath);
    }

    public String toString() {
        return "EclipseProject[" + this.getName() + ", " + this.getDirectory() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EclipseProject)) {
            return false;
        }
        EclipseProject ePrj = (EclipseProject)obj;
        return this.name.equals(ePrj.name);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + System.identityHashCode(this.name);
        return result;
    }

    public int compareTo(Object o) {
        String name1 = this.getName();
        String name2 = null;
        if (o instanceof EclipseProject) {
            name2 = ((EclipseProject)o).getName();
        }
        if (name2 == null) {
            return name1 == null ? 0 : -1;
        }
        return name1 == null ? 1 : name1.compareToIgnoreCase(name2);
    }
}

