/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.WorkspaceParser;

public final class WorkspaceFactory {
    private static Map<File, WeakReference<Workspace>> cache = new HashMap<File, WeakReference<Workspace>>();
    private static WorkspaceFactory instance = new WorkspaceFactory();

    private WorkspaceFactory() {
    }

    public static WorkspaceFactory getInstance() {
        return instance;
    }

    public void resetCache() {
        cache = new HashMap<File, WeakReference<Workspace>>();
    }

    public Workspace load(File workspaceDir) throws ProjectImporterException {
        Workspace workspace;
        Workspace w;
        WeakReference<Workspace> wr = cache.get(workspaceDir);
        Workspace workspace2 = w = wr != null ? (Workspace)wr.get() : null;
        if (w == null && (workspace = Workspace.createWorkspace(workspaceDir)) != null) {
            WorkspaceParser parser = new WorkspaceParser(workspace);
            parser.parse();
            cache.put(workspaceDir, new WeakReference<Workspace>(workspace));
            w = workspace;
        }
        return w;
    }
}

