/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.actions.DownloadWalletDialog;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;

public class DownloadWalletAction
implements ActionListener {
    private static final String URL_TEMPLATE = "jdbc:oracle:thin:@{0}?TNS_ADMIN=\"{1}\"";
    private final DatabaseItem context;

    public DownloadWalletAction(DatabaseItem context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Optional<DownloadWalletDialog.WalletInfo> result = DownloadWalletDialog.showDialog(this.context);
        result.ifPresent(p -> {
            try {
                Path walletPath = OCIManager.getDefault().downloadWallet(this.context, new String(p.getWalletPassword()), p.getPath());
                if (p.getDbUser() != null && p.getDbPassword() != null) {
                    JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers("oracle.jdbc.OracleDriver");
                    if (drivers.length > 0) {
                        String connectionName = this.context.getConnectionName();
                        if (connectionName == null) {
                            Optional n = this.parseConnectionNames(walletPath).stream().findFirst();
                            if (n.isPresent()) {
                                connectionName = (String)n.get();
                            } else {
                                StatusDisplayer.getDefault().setStatusText(Bundle.MSG_WalletNoConnection());
                                return;
                            }
                        }
                        String dbUrl = MessageFormat.format(URL_TEMPLATE, connectionName, walletPath);
                        DatabaseConnection dbConn = DatabaseConnection.create((JDBCDriver)drivers[0], (String)dbUrl, (String)p.getDbUser(), (String)p.getDbUser(), (String)new String(p.getDbPassword()), (boolean)true, (String)this.context.getName());
                        ConnectionManager.getDefault().addConnection(dbConn);
                    }
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_WalletDownloadedPassword(new String(p.getWalletPassword()))));
                } else {
                    StatusDisplayer.getDefault().setStatusText(Bundle.MSG_WalletDownloaded(walletPath.toString()));
                }
            }
            catch (IOException | DatabaseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    protected List<String> parseConnectionNames(Path wallet) {
        Path tns = wallet.resolve("tnsnames.ora");
        try {
            return Files.newBufferedReader(tns).lines().filter(l -> l.contains("=")).map(l -> l.substring(0, l.indexOf("=")).trim()).collect(Collectors.toList());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }
}

