/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.FrameDescriptorProvider;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.interop.ScopeMembers;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayList;
import java.util.List;

@ExportLibrary(value=InteropLibrary.class)
public final class ScopeVariables
implements TruffleObject {
    public static final String RECEIVER_MEMBER = "this";
    static final int LIMIT = 4;
    final Frame frame;
    final boolean nodeEnter;
    final Node blockOrRoot;

    public ScopeVariables(Frame frame, boolean nodeEnter, Node blockOrRoot) {
        this.frame = frame;
        this.nodeEnter = nodeEnter;
        this.blockOrRoot = blockOrRoot;
    }

    @ExportMessage
    boolean accepts(@Cached(value="this.blockOrRoot", adopt=false) Node cachedNode, @Cached(value="this.nodeEnter") boolean cachedNodeEnter) {
        return this.blockOrRoot == cachedNode && this.nodeEnter == cachedNodeEnter;
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return JavaScriptLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasScopeParent() {
        if (this.blockOrRoot instanceof RootNode) {
            if (this.frame == null) {
                return false;
            }
            if (ScopeFrameNode.isBlockScopeFrame(this.frame)) {
                return true;
            }
            MaterializedFrame parentFrame = JSFrameUtil.getParentFrame(this.frame);
            return parentFrame != null && parentFrame != JSFrameUtil.NULL_MATERIALIZED_FRAME;
        }
        Node parentNode = JavaScriptNode.findBlockScopeNode(this.blockOrRoot.getParent());
        return parentNode != null && (this.frame == null || this.getParentFrame() != null);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getScopeParent() throws UnsupportedMessageException {
        if (this.blockOrRoot instanceof RootNode) {
            if (this.frame != null) {
                if (ScopeFrameNode.isBlockScopeFrame(this.frame)) {
                    return new ScopeVariables(ScopeFrameNode.getBlockScopeParentFrame(this.frame), true, this.blockOrRoot);
                }
                MaterializedFrame parentFrame = JSFrameUtil.getParentFrame(this.frame);
                if (parentFrame != null && parentFrame != JSFrameUtil.NULL_MATERIALIZED_FRAME) {
                    RootNode rootNode = ((RootCallTarget)JSFunction.getCallTarget(JSFrameUtil.getFunctionObject((Frame)parentFrame))).getRootNode();
                    return new ScopeVariables((Frame)parentFrame, true, (Node)rootNode);
                }
            }
        } else {
            Node parentBlock = JavaScriptNode.findBlockScopeNode(this.blockOrRoot.getParent());
            if (parentBlock != null) {
                Frame enclosingFrame;
                if (this.frame != null) {
                    enclosingFrame = this.getParentFrame();
                    if (enclosingFrame == null) {
                        throw UnsupportedMessageException.create();
                    }
                } else {
                    enclosingFrame = null;
                }
                return new ScopeVariables(enclosingFrame, true, parentBlock);
            }
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    private Frame getParentFrame() {
        FrameSlot parentSlot = this.frame.getFrameDescriptor().findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER);
        if (parentSlot != null) {
            return (Frame)FrameUtil.getObjectSafe((Frame)this.frame, (FrameSlot)parentSlot);
        }
        return null;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        return new ScopeMembers(this.frame, this.blockOrRoot);
    }

    @ExportMessage
    boolean isMemberInsertable(String member) {
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasSourceLocation() {
        return this.blockOrRoot.getEncapsulatingSourceSection() != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    SourceSection getSourceLocation() throws UnsupportedMessageException {
        SourceSection sourceLocation = this.blockOrRoot.getEncapsulatingSourceSection();
        if (sourceLocation == null) {
            throw UnsupportedMessageException.create();
        }
        return sourceLocation;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        if (this.blockOrRoot instanceof RootNode) {
            return ((RootNode)this.blockOrRoot).getName();
        }
        return "block";
    }

    static ResolvedSlot findSlot(String member, Frame frame, Node blockOrRootNode) {
        CompilerAsserts.neverPartOfCompilation();
        if (frame == null) {
            return ScopeVariables.findSlotWithoutFrame(member, blockOrRootNode);
        }
        Frame outerFrame = frame;
        int frameLevel = 0;
        while (true) {
            Frame outerScope = outerFrame;
            ArrayList<FrameSlot> parentSlotList = new ArrayList<FrameSlot>();
            int scopeLevel = 0;
            while (true) {
                FrameDescriptor frameDescriptor;
                FrameSlot slot;
                if ((slot = (frameDescriptor = outerScope.getFrameDescriptor()).findFrameSlot((Object)member)) != null) {
                    if (JSFrameUtil.isInternal(slot)) {
                        return null;
                    }
                    return new ResolvedSlot(slot, frameLevel, scopeLevel, frameDescriptor, parentSlotList);
                }
                FrameSlot parentSlot = frameDescriptor.findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER);
                if (parentSlot == null) break;
                outerScope = (Frame)FrameUtil.getObjectSafe((Frame)outerScope, (FrameSlot)parentSlot);
                parentSlotList.add(parentSlot);
                ++scopeLevel;
            }
            outerFrame = JSArguments.getEnclosingFrame(outerFrame.getArguments());
            if (outerFrame == JSFrameUtil.NULL_MATERIALIZED_FRAME) break;
            ++frameLevel;
        }
        return null;
    }

    private static ResolvedSlot findSlotWithoutFrame(String member, Node blockOrRootNode) {
        Node descNode = blockOrRootNode;
        while (descNode != null && descNode instanceof FrameDescriptorProvider) {
            FrameDescriptor desc = ((FrameDescriptorProvider)descNode).getFrameDescriptor();
            FrameSlot slot = desc.findFrameSlot((Object)member);
            if (slot != null) {
                if (JSFrameUtil.isInternal(slot)) {
                    return null;
                }
                return new ResolvedSlot();
            }
            descNode = JavaScriptNode.findBlockScopeNode(descNode.getParent());
        }
        return null;
    }

    static boolean hasSlot(String member, Frame frame, Node blockOrRoot) {
        return ScopeVariables.findSlot(member, frame, blockOrRoot) != null;
    }

    static JavaScriptNode findReadNode(String member, Frame frame, Node blockOrRoot) {
        ResolvedSlot slot = ScopeVariables.findSlot(member, frame, blockOrRoot);
        if (slot != null) {
            return slot.createReadNode();
        }
        return null;
    }

    static WriteNode findWriteNode(String member, Frame frame, Node blockOrRoot) {
        if (RECEIVER_MEMBER.equals(member)) {
            return null;
        }
        ResolvedSlot slot = ScopeVariables.findSlot(member, frame, blockOrRoot);
        if (slot != null && slot.isModifiable()) {
            return slot.createWriteNode();
        }
        return null;
    }

    static Object getThis(Frame frame) {
        Object[] args;
        Object function;
        FrameSlot thisSlot = JSFrameUtil.getThisSlot(frame.getFrameDescriptor());
        if (thisSlot == null) {
            return ScopeVariables.thisFromArguments(frame.getArguments());
        }
        Object thiz = frame.getValue(thisSlot);
        if (thiz == Undefined.instance && JSFunction.isJSFunction(function = JSArguments.getFunctionObject(args = frame.getArguments()))) {
            DynamicObject jsFunction = (DynamicObject)function;
            thiz = ScopeVariables.isArrowFunctionWithThisCaptured(jsFunction) ? JSFunction.getLexicalThis(jsFunction) : ScopeVariables.thisFromArguments(args);
        }
        return thiz;
    }

    private static Object thisFromArguments(Object[] args) {
        Object thisObject = JSArguments.getThisObject(args);
        Object function = JSArguments.getFunctionObject(args);
        if (JSFunction.isJSFunction(function) && !JSFunction.isStrict((DynamicObject)function)) {
            JSRealm realm = JavaScriptLanguage.getCurrentJSRealm();
            thisObject = thisObject == Undefined.instance || thisObject == Null.instance ? realm.getGlobalObject() : JSRuntime.toObject(realm.getContext(), thisObject);
        }
        return thisObject;
    }

    private static boolean isArrowFunctionWithThisCaptured(DynamicObject function) {
        return !JSFunction.isConstructor(function) && JSFunction.isClassPrototypeInitialized(function);
    }

    static final class ResolvedSlot {
        final FrameSlot slot;
        final int frameLevel;
        final int scopeLevel;
        final FrameDescriptor descriptor;
        final List<FrameSlot> parentSlotList;

        ResolvedSlot(FrameSlot slot, int frameLevel, int scopeLevel, FrameDescriptor descriptor, List<FrameSlot> parentSlotList) {
            this.slot = slot;
            this.frameLevel = frameLevel;
            this.scopeLevel = scopeLevel;
            this.descriptor = descriptor;
            this.parentSlotList = parentSlotList;
        }

        ResolvedSlot() {
            this(null, -1, -1, null, null);
        }

        JavaScriptNode createReadNode() {
            if (this.slot == null) {
                return JSConstantNode.createUndefined();
            }
            FrameSlot[] parentSlots = this.parentSlotList.toArray(ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY);
            return JSReadFrameSlotNode.create(this.slot, this.frameLevel, this.scopeLevel, parentSlots, JSFrameUtil.hasTemporalDeadZone(this.slot));
        }

        WriteNode createWriteNode() {
            if (this.slot == null) {
                return null;
            }
            FrameSlot[] parentSlots = this.parentSlotList.toArray(ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY);
            return JSWriteFrameSlotNode.create(this.slot, this.frameLevel, this.scopeLevel, this.descriptor, parentSlots, null, JSFrameUtil.hasTemporalDeadZone(this.slot));
        }

        public boolean isModifiable() {
            return this.slot != null && !JSFrameUtil.isConst(this.slot);
        }
    }

    @ExportMessage
    static final class WriteMember {
        WriteMember() {
        }

        @Specialization(guards={"cachedMember.equals(member)"}, limit="LIMIT")
        static void doCached(ScopeVariables receiver, String member, Object value, @Cached(value="member") String cachedMember, @Cached(value="findWriteNode(member, receiver.frame, receiver.blockOrRoot)", adopt=false) WriteNode writeNode) throws UnknownIdentifierException {
            WriteMember.doWrite(receiver, cachedMember, value, writeNode);
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static void doGeneric(ScopeVariables receiver, String member, Object value) throws UnknownIdentifierException {
            WriteNode writeNode = ScopeVariables.findWriteNode(member, receiver.frame, receiver.blockOrRoot);
            WriteMember.doWrite(receiver, member, value, writeNode);
        }

        private static void doWrite(ScopeVariables receiver, String member, Object value, WriteNode writeNode) throws UnknownIdentifierException {
            if (writeNode == null || receiver.frame == null) {
                throw UnknownIdentifierException.create((String)member);
            }
            writeNode.executeWrite((VirtualFrame)receiver.frame, value);
        }
    }

    @ExportMessage
    static final class ReadMember {
        ReadMember() {
        }

        @Specialization(guards={"RECEIVER_MEMBER.equals(member)"})
        @CompilerDirectives.TruffleBoundary
        static Object doReadThis(ScopeVariables receiver, String member) throws UnknownIdentifierException {
            if (receiver.frame != null) {
                return ScopeVariables.getThis(receiver.frame);
            }
            throw UnknownIdentifierException.create((String)member);
        }

        @Specialization(guards={"cachedMember.equals(member)", "!RECEIVER_MEMBER.equals(cachedMember)"}, limit="LIMIT")
        static Object doCached(ScopeVariables receiver, String member, @Cached(value="member") String cachedMember, @Cached(value="findReadNode(member, receiver.frame, receiver.blockOrRoot)", adopt=false) JavaScriptNode readNode) throws UnknownIdentifierException {
            return ReadMember.doRead(receiver, cachedMember, readNode);
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static Object doGeneric(ScopeVariables receiver, String member) throws UnknownIdentifierException {
            JavaScriptNode readNode = ScopeVariables.findReadNode(member, receiver.frame, receiver.blockOrRoot);
            return ReadMember.doRead(receiver, member, readNode);
        }

        private static Object doRead(ScopeVariables receiver, String member, JavaScriptNode readNode) throws UnknownIdentifierException {
            if (readNode == null) {
                throw UnknownIdentifierException.create((String)member);
            }
            if (receiver.frame == null) {
                return Undefined.instance;
            }
            return readNode.execute((VirtualFrame)receiver.frame);
        }
    }

    @ExportMessage
    static final class IsMemberModifiable {
        IsMemberModifiable() {
        }

        @Specialization(guards={"RECEIVER_MEMBER.equals(member)"})
        static boolean doReadThis(ScopeVariables receiver, String member) {
            return receiver.frame != null;
        }

        @Specialization(guards={"cachedMember.equals(member)", "!RECEIVER_MEMBER.equals(cachedMember)"}, limit="LIMIT")
        static boolean doCached(ScopeVariables receiver, String member, @Cached(value="member") String cachedMember, @Cached(value="doGeneric(receiver, member)") boolean cachedResult) {
            assert (cachedResult == IsMemberModifiable.doGeneric(receiver, member));
            return cachedResult;
        }

        @Specialization(guards={"!RECEIVER_MEMBER.equals(member)"}, replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static boolean doGeneric(ScopeVariables receiver, String member) {
            ResolvedSlot slot = ScopeVariables.findSlot(member, receiver.frame, receiver.blockOrRoot);
            return slot != null && slot.isModifiable();
        }
    }

    @ExportMessage
    static final class IsMemberReadable {
        IsMemberReadable() {
        }

        @Specialization(guards={"RECEIVER_MEMBER.equals(member)"})
        static boolean doReadThis(ScopeVariables receiver, String member) {
            return receiver.frame != null;
        }

        @Specialization(guards={"cachedMember.equals(member)", "!RECEIVER_MEMBER.equals(cachedMember)"}, limit="LIMIT")
        static boolean doCached(ScopeVariables receiver, String member, @Cached(value="member") String cachedMember, @Cached(value="doGeneric(receiver, member)") boolean cachedResult) {
            assert (cachedResult == IsMemberReadable.doGeneric(receiver, member));
            return cachedResult;
        }

        @Specialization(guards={"!RECEIVER_MEMBER.equals(member)"}, replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static boolean doGeneric(ScopeVariables receiver, String member) {
            return ScopeVariables.hasSlot(member, receiver.frame, receiver.blockOrRoot);
        }
    }
}

