/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.InternalActionDelegate;
import org.netbeans.modules.maven.NbArtifactFixer;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.actions.OpenPOMAction;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.modelcache.MavenProjectCache;
import org.netbeans.modules.maven.problems.Bundle;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.modules.maven.problems.SanityBuildAction;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class MavenModelProblemsProvider
implements ProjectProblemsProvider,
InternalActionDelegate {
    static final ScheduledExecutorService RP = new RequestProcessor(MavenModelProblemsProvider.class);
    private static final Logger LOG = Logger.getLogger(MavenModelProblemsProvider.class.getName());
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final Project project;
    private final AtomicBoolean projectListenerSet = new AtomicBoolean(false);
    private final AtomicReference<Collection<ProjectProblemsProvider.ProjectProblem>> problemsCache = new AtomicReference();
    private final PrimingActionProvider primingProvider = new PrimingActionProvider();
    private ProblemReporterImpl problemReporter;
    private final PropertyChangeListener projectListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                MavenModelProblemsProvider.this.firePropertyChange();
            }
        }
    };
    private Reference<SanityBuildAction> cachedSanityBuild = new WeakReference<Object>(null);
    private static final String[] PROBLEM_ACTIONS = new String[]{"prime"};

    public MavenModelProblemsProvider(Project project) {
        this.project = project;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        Collection<? extends ProjectProblemsProvider.ProjectProblem> prbs = this.doGetProblems(false);
        return prbs != null ? prbs : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<? extends ProjectProblemsProvider.ProjectProblem> doGetProblems(boolean sync) {
        final MavenProject prj = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
        MavenModelProblemsProvider mavenModelProblemsProvider = this;
        synchronized (mavenModelProblemsProvider) {
            Object wasprocessed;
            LOG.log(Level.FINER, "Called getProblems for {0}", this.project);
            if (this.projectListenerSet.compareAndSet(false, true)) {
                this.problemReporter = ((NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class)).getProblemReporter();
                assert (this.problemReporter != null);
                ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this.projectListener);
            }
            if ((wasprocessed = prj.getContextValue(MavenModelProblemsProvider.class.getName())) != null) {
                Collection<ProjectProblemsProvider.ProjectProblem> cached = this.problemsCache.get();
                LOG.log(Level.FINER, "Project was processed, cached is: {0}", cached);
                if (cached != null) {
                    return cached;
                }
            }
            Callable<Collection<? extends ProjectProblemsProvider.ProjectProblem>> c = new Callable<Collection<? extends ProjectProblemsProvider.ProjectProblem>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Collection<? extends ProjectProblemsProvider.ProjectProblem> call() throws Exception {
                    Object wasprocessed = prj.getContextValue(MavenModelProblemsProvider.class.getName());
                    if (wasprocessed != null) {
                        Collection cached = (Collection)MavenModelProblemsProvider.this.problemsCache.get();
                        LOG.log(Level.FINER, "Project was processed #2, cached is: {0}", cached);
                        if (cached != null) {
                            return cached;
                        }
                    }
                    ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
                    MavenExecutionResult res = MavenProjectCache.getExecutionResult(prj);
                    if (res != null && res.hasExceptions()) {
                        toRet.addAll(MavenModelProblemsProvider.this.reportExceptions(res));
                    }
                    toRet.addAll(MavenModelProblemsProvider.this.doArtifactChecks(prj));
                    prj.setContextValue(MavenModelProblemsProvider.class.getName(), new Object());
                    MavenModelProblemsProvider mavenModelProblemsProvider = MavenModelProblemsProvider.this;
                    synchronized (mavenModelProblemsProvider) {
                        LOG.log(Level.FINER, "Project processing finished, result is: {0}", toRet);
                        MavenModelProblemsProvider.this.problemsCache.set(toRet);
                    }
                    MavenModelProblemsProvider.this.firePropertyChange();
                    return toRet;
                }
            };
            if (sync || Boolean.getBoolean("test.reload.sync")) {
                try {
                    return (Collection)c.call();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                RP.submit(c);
            }
        }
        return null;
    }

    private void firePropertyChange() {
        this.support.firePropertyChange("problems", null, null);
    }

    public Collection<ProjectProblemsProvider.ProjectProblem> doArtifactChecks(@NonNull MavenProject project) {
        ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
        if (MavenProjectCache.unknownBuildParticipantObserved(project)) {
            StringBuilder sb = new StringBuilder();
            for (String string : MavenProjectCache.getUnknownBuildParticipantsClassNames(project)) {
                sb.append(string).append("\n");
            }
            toRet.add(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.ERR_Participant(), (String)Bundle.MSG_Participant(sb.toString())));
        }
        toRet.addAll(this.checkParents(project));
        boolean missingNonSibling = false;
        ArrayList<Artifact> missingJars = new ArrayList<Artifact>();
        for (Artifact art : project.getArtifacts()) {
            File file = art.getFile();
            if (file == null || !file.exists()) {
                if ("system".equals(art.getScope())) {
                    toRet.add(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.ERR_SystemScope(), (String)Bundle.MSG_SystemScope(), (ProjectProblemResolver)new ProblemReporterImpl.MavenProblemResolver(OpenPOMAction.instance().createContextAwareInstance(Lookups.fixed((Object[])new Object[]{project})), "SCOPE_DEPENDENCY")));
                    continue;
                }
                this.problemReporter.addMissingArtifact(art);
                if (file == null) {
                    missingNonSibling = true;
                } else {
                    SourceForBinaryQuery.Result2 result;
                    URL archiveUrl = FileUtil.urlForArchiveOrDir((File)file);
                    if (!(archiveUrl == null || (result = SourceForBinaryQuery.findSourceRoots2((URL)archiveUrl)).preferSources() && result.getRoots().length != 0)) {
                        missingNonSibling = true;
                    }
                }
                missingJars.add(art);
                continue;
            }
            if (!NbArtifactFixer.isFallbackFile(file)) continue;
            this.problemReporter.addMissingArtifact(art);
            missingJars.add(art);
            missingNonSibling = true;
        }
        if (!missingJars.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Artifact art : missingJars) {
                stringBuilder.append(art.getId()).append('\n');
            }
            if (missingNonSibling) {
                toRet.add(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.ERR_NonLocal(), (String)Bundle.MSG_NonLocal(stringBuilder), (ProjectProblemResolver)this.createSanityBuildAction()));
            }
        }
        return toRet;
    }

    private Collection<ProjectProblemsProvider.ProjectProblem> checkParents(@NonNull MavenProject project) {
        List mdls = MavenEmbedder.getModelDescriptors((MavenProject)project);
        boolean first = true;
        if (mdls == null) {
            return Collections.emptyList();
        }
        ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
        for (MavenEmbedder.ModelDescription m : mdls) {
            if (first) {
                first = false;
                continue;
            }
            if (!"F@LLB@CK".equals(m.getName())) continue;
            toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ERR_NoParent(), (String)Bundle.MSG_NoParent(m.getId()), (ProjectProblemResolver)this.createSanityBuildAction()));
            this.problemReporter.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createArtifact(m.getGroupId(), m.getArtifactId(), m.getVersion(), "pom"));
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SanityBuildAction createSanityBuildAction() {
        MavenModelProblemsProvider mavenModelProblemsProvider = this;
        synchronized (mavenModelProblemsProvider) {
            Future<ProjectProblemsProvider.Result> r;
            SanityBuildAction a = this.cachedSanityBuild.get();
            if (a != null && (r = a.getPendingResult()) != null) {
                return a;
            }
            a = new SanityBuildAction(this.project);
            this.cachedSanityBuild = new WeakReference<SanityBuildAction>(a);
            return a;
        }
    }

    private Collection<ProjectProblemsProvider.ProjectProblem> reportExceptions(MavenExecutionResult res) {
        ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
        for (Throwable e : res.getExceptions()) {
            LOG.log(Level.FINE, "Error on loading project " + this.project.getProjectDirectory(), e);
            if (e instanceof ArtifactResolutionException) {
                toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Artifact_Resolution_problem(), (String)this.getDescriptionText(e)));
                this.problemReporter.addMissingArtifact(((ArtifactResolutionException)e).getArtifact());
                continue;
            }
            if (e instanceof ArtifactNotFoundException) {
                toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Artifact_Not_Found(), (String)this.getDescriptionText(e)));
                this.problemReporter.addMissingArtifact(((ArtifactNotFoundException)e).getArtifact());
                continue;
            }
            if (e instanceof ProjectBuildingException) {
                LOG.log(Level.FINE, "Creating sanity build action for {0}", this.project.getProjectDirectory());
                toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Cannot_Load_Project(), (String)this.getDescriptionText(e), (ProjectProblemResolver)this.createSanityBuildAction()));
                if (!(e.getCause() instanceof ModelBuildingException)) continue;
                ModelBuildingException mbe = (ModelBuildingException)e.getCause();
                for (ModelProblem mp : mbe.getProblems()) {
                    LOG.log(Level.FINE, mp.toString(), mp.getException());
                    if (mp.getException() instanceof UnresolvableModelException) {
                        UnresolvableModelException ume = (UnresolvableModelException)mp.getException();
                        this.problemReporter.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createProjectArtifact(ume.getGroupId(), ume.getArtifactId(), ume.getVersion()));
                        continue;
                    }
                    if (mp.getException() instanceof PluginResolutionException) {
                        Plugin plugin = ((PluginResolutionException)mp.getException()).getPlugin();
                        this.problemReporter.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), "jar"));
                        continue;
                    }
                    if (!(mp.getException() instanceof PluginManagerException)) continue;
                    PluginManagerException ex = (PluginManagerException)mp.getException();
                    this.problemReporter.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createArtifact(ex.getPluginGroupId(), ex.getPluginArtifactId(), ex.getPluginVersion(), "jar"));
                }
                continue;
            }
            String msg = e.getMessage();
            if (msg != null) {
                LOG.log(Level.INFO, "Exception thrown while loading maven project at " + this.project.getProjectDirectory(), e);
                toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Cannot_read_model(), (String)msg));
                continue;
            }
            String path = this.project.getProjectDirectory().getPath();
            toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Cannot_read_model(), (String)Bundle.TXT_NoMsg(path)));
            LOG.log(Level.WARNING, "Exception thrown while loading maven project at " + path, e);
        }
        return toRet;
    }

    private String getDescriptionText(Throwable e) {
        String msg = e.getMessage();
        if (msg != null) {
            return msg;
        }
        String path = this.project.getProjectDirectory().getPath();
        return Bundle.TXT_NoMsg(path);
    }

    @Override
    public ActionProvider getActionProvider() {
        return this.primingProvider;
    }

    private class PrimingActionProvider
    implements ActionProvider {
        private PrimingActionProvider() {
        }

        public String[] getSupportedActions() {
            return PROBLEM_ACTIONS;
        }

        public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
            ActionProgress listener = ActionProgress.start((Lookup)context);
            if (!PROBLEM_ACTIONS[0].equals(command)) {
                throw new IllegalArgumentException(command);
            }
            Collection<? extends ProjectProblemsProvider.ProjectProblem> probs = MavenModelProblemsProvider.this.doGetProblems(true);
            SanityBuildAction saba = (SanityBuildAction)MavenModelProblemsProvider.this.cachedSanityBuild.get();
            if (saba == null) {
                LOG.log(Level.FINE, "Sanity build action does not exist");
                listener.finished(true);
            } else {
                LOG.log(Level.FINE, "Resolving sanity build action");
                Future r = saba.resolve();
                ((CompletableFuture)r).whenComplete((a, e) -> listener.finished(e == null));
            }
        }

        public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
            if (!PROBLEM_ACTIONS[0].equals(command)) {
                return false;
            }
            Collection<? extends ProjectProblemsProvider.ProjectProblem> probs = MavenModelProblemsProvider.this.doGetProblems(false);
            if (probs == null) {
                LOG.log(Level.FINE, "Priming action enabled because problems are not yet evaluated.");
                return true;
            }
            if (probs.isEmpty()) {
                LOG.log(Level.FINE, "Priming action disabled, no problems found.");
                return false;
            }
            SanityBuildAction saba = (SanityBuildAction)MavenModelProblemsProvider.this.cachedSanityBuild.get();
            if (saba == null) {
                LOG.log(Level.FINE, "Problems present, but no SanityBuildAction created");
                return false;
            }
            Future<ProjectProblemsProvider.Result> res = saba.getPendingResult();
            LOG.log(Level.FINE, "Sanity build state is: {0}", res == null || res.isDone());
            return res == null || !res.isDone();
        }
    }
}

