/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.toml;

import java.util.Collection;
import java.util.EnumSet;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.languages.toml.TomlLexer;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum TomlTokenId implements TokenId
{
    COMMENT("comment"),
    ERROR("error"),
    KEY("key"),
    BOOLEAN("boolean"),
    DATE("date"),
    NUMBER("number"),
    EQUALS("operator"),
    DOT("separator"),
    TABLE_MARK("table-mark"),
    STRING("string"),
    ML_STRING_START("string"),
    ML_STRING_END("string"),
    ESCAPE_SEQUENCE("string-escape"),
    WHITESPACE("whitespace");

    private final String category;
    private static final Language<TomlTokenId> LANGUAGE;
    public static final String TOML_MIME_TYPE = "text/x-toml";

    private TomlTokenId(String category) {
        this.category = category;
    }

    public String primaryCategory() {
        return this.category;
    }

    public static final Language<?> language() {
        return LANGUAGE;
    }

    static {
        LANGUAGE = new LanguageHierarchy<TomlTokenId>(){

            protected Collection<TomlTokenId> createTokenIds() {
                return EnumSet.allOf(TomlTokenId.class);
            }

            protected Lexer<TomlTokenId> createLexer(LexerRestartInfo<TomlTokenId> info) {
                return new TomlLexer(info);
            }

            protected String mimeType() {
                return TomlTokenId.TOML_MIME_TYPE;
            }
        }.language();
    }
}

