/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.concurrent.Callable;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.javafx2.editor.completion.impl.AbstractCompletionItem;
import org.netbeans.modules.javafx2.editor.completion.impl.Bundle;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.openide.util.ImageUtilities;

final class FxInstructionItem
extends AbstractCompletionItem {
    private static final String ICON_RESOURCE = "org/netbeans/modules/javafx2/editor/resources/instruction.png";
    private String instruction;
    private Callable<String> fxNamespaceDecl;
    private static ImageIcon ICON;

    public FxInstructionItem(String instruction, CompletionContext ctx, String text, Callable<String> declarator) {
        super(ctx, text);
        this.instruction = instruction;
        this.fxNamespaceDecl = declarator;
    }

    @Override
    protected String getLeftHtmlText() {
        return Bundle.FMT_fxmlInstructionItem(this.instruction);
    }

    @Override
    protected int getCaretShift(Document d) {
        int index = this.getSubstituteText().indexOf(34);
        if (index == -1) {
            return super.getCaretShift(d);
        }
        return index + 1;
    }

    @Override
    protected void doSubstituteText(JTextComponent c, BaseDocument d, String text) throws BadLocationException {
        String prefix = "fx";
        if (this.fxNamespaceDecl != null) {
            try {
                prefix = this.fxNamespaceDecl.call();
            }
            catch (Exception ex) {
                throw new BadLocationException("", 0);
            }
        }
        if (!"fx".equals(prefix)) {
            text = text.replace("fx:", prefix + ":");
        }
        super.doSubstituteText(c, d, text);
    }

    @Override
    protected ImageIcon getIcon() {
        if (ICON == null) {
            ICON = ImageUtilities.loadImageIcon((String)ICON_RESOURCE, (boolean)false);
        }
        return ICON;
    }

    public String toString() {
        return "instruction[" + this.instruction + "]";
    }
}

