/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.hints.declarative.Condition;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintTokenId;
import org.netbeans.modules.java.hints.declarative.Hacks;
import org.netbeans.modules.java.hints.declarative.MethodInvocationContext;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class DeclarativeHintsParser {
    public static boolean disableCustomCode = false;
    static Class<?>[] auxConditionClasses;
    private static final Pattern OPTION;
    private static volatile Reference<ClassPath> javacApiClasspath;
    private static final Reference<ClassPath> NONE;
    private static volatile Reference<Holder> cache;

    static void parseOptions(String options, Map<String, String> to) {
        Matcher m = OPTION.matcher(options);
        int end = 0;
        while (m.find()) {
            to.put(m.group(1), DeclarativeHintsParser.unquote(m.group(2)));
            end = m.end();
        }
        String[] keyValue = options.substring(end).split("=");
        if (keyValue.length == 1) {
            to.put(keyValue[0], "");
        } else {
            to.put(keyValue[0], DeclarativeHintsParser.unquote(keyValue[1]));
        }
    }

    private static String unquote(String what) {
        if (what.length() > 2 && what.charAt(0) == '\"' && what.charAt(what.length() - 1) == '\"') {
            return what.substring(1, what.length() - 1);
        }
        return what;
    }

    public Result parse(@NullAllowed FileObject file, CharSequence text, TokenSequence<DeclarativeHintTokenId> ts) {
        Impl i = new Impl(file, text, ts);
        i.parseInput();
        return new Result(i.options, i.importsBlockSpan, i.hints, i.blocksSpan, i.errors);
    }

    private static ClassPath getJavacApiJarClasspath() {
        URL javacApiJar;
        Reference<ClassPath> r = javacApiClasspath;
        ClassPath res = r.get();
        if (res != null) {
            return res;
        }
        if (r == NONE) {
            return null;
        }
        CodeSource codeSource = Modifier.class.getProtectionDomain().getCodeSource();
        URL uRL = javacApiJar = codeSource != null ? codeSource.getLocation() : null;
        if (javacApiJar != null) {
            Logger.getLogger(DeclarativeHintsParser.class.getName()).log(Level.FINE, "javacApiJar={0}", javacApiJar);
            File aj = FileUtil.archiveOrDirForURL((URL)javacApiJar);
            if (aj != null) {
                res = ClassPathSupport.createClassPath((URL[])new URL[]{FileUtil.urlForArchiveOrDir((File)aj)});
                javacApiClasspath = new WeakReference<ClassPath>(res);
                return res;
            }
        }
        javacApiClasspath = NONE;
        return null;
    }

    @NonNull
    private static Condition resolve(MethodInvocationContext mic, String invocation, boolean not, int offset, FileObject file, List<ErrorDescription> errors) throws IOException {
        String[] methodName = new String[1];
        LinkedHashMap params = new LinkedHashMap();
        ClasspathInfo cpInfo = Hacks.createUniversalCPInfo();
        ClassPath javacPath = DeclarativeHintsParser.getJavacApiJarClasspath();
        if (javacPath != null) {
            Holder holder;
            ClasspathInfo result = null;
            Reference<Holder> h = cache;
            if (h != null && (holder = h.get()) != null && holder.universalPath == cpInfo) {
                result = holder.cachedInfo.get();
            }
            if (result == null) {
                result = ClasspathInfo.create((ClassPath)ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{javacPath, cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT)}), (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY);
                cache = new WeakReference<Holder>(new Holder(result, cpInfo));
            }
            cpInfo = result;
        }
        JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]).runUserActionTask(parameter -> {
            parameter.toPhase(JavaSource.Phase.RESOLVED);
            if (invocation == null || invocation.isEmpty()) {
                return;
            }
            SourcePositions[] positions = new SourcePositions[1];
            ExpressionTree et = parameter.getTreeUtilities().parseExpression(invocation, positions);
            if (et.getKind() != Tree.Kind.METHOD_INVOCATION) {
                return;
            }
            MethodInvocationTree mit = (MethodInvocationTree)et;
            if (mit.getMethodSelect().getKind() != Tree.Kind.IDENTIFIER) {
                return;
            }
            Scope s = Hacks.constructScope((CompilationInfo)parameter, "javax.lang.model.SourceVersion", "javax.lang.model.element.Modifier", "javax.lang.model.element.ElementKind");
            parameter.getTreeUtilities().attributeTree((Tree)et, s);
            methodName[0] = ((IdentifierTree)mit.getMethodSelect()).getName().toString();
            for (ExpressionTree expressionTree : mit.getArguments()) {
                switch (expressionTree.getKind()) {
                    case STRING_LITERAL: {
                        params.put(((LiteralTree)expressionTree).getValue().toString(), Condition.MethodInvocation.ParameterKind.STRING_LITERAL);
                        break;
                    }
                    case INT_LITERAL: {
                        params.put(((LiteralTree)expressionTree).getValue().toString(), Condition.MethodInvocation.ParameterKind.INT_LITERAL);
                        break;
                    }
                    case IDENTIFIER: {
                        String name = ((IdentifierTree)expressionTree).getName().toString();
                        if (name.startsWith("$")) {
                            params.put(name, Condition.MethodInvocation.ParameterKind.VARIABLE);
                            break;
                        }
                    }
                    case MEMBER_SELECT: {
                        TreePath tp = parameter.getTrees().getPath(s.getEnclosingClass());
                        Element e = parameter.getTrees().getElement(new TreePath(tp, expressionTree));
                        if (e.getKind() != ElementKind.ENUM_CONSTANT) {
                            int start = (int)positions[0].getStartPosition(null, expressionTree) + offset;
                            int end = (int)positions[0].getEndPosition(null, expressionTree) + offset;
                            errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)"Cannot resolve enum constant", (FileObject)file, (int)start, (int)end));
                            break;
                        }
                        String name = ((TypeElement)e.getEnclosingElement()).getQualifiedName() + "." + e.getSimpleName();
                        params.put(name, Condition.MethodInvocation.ParameterKind.ENUM_CONSTANT);
                    }
                }
            }
        }, true);
        if (methodName[0] == null) {
            return new Condition.False();
        }
        return new Condition.MethodInvocation(not, methodName[0], params, mic);
    }

    static {
        OPTION = Pattern.compile("([^=]+)=(([^\"].*?)|(\".*?\")),");
        javacApiClasspath = new WeakReference<Object>(null);
        NONE = new WeakReference<Object>(null);
        cache = new WeakReference<Object>(null);
    }

    public static final class FixTextDescription {
        public final String displayName;
        public final int[] fixSpan;
        public final List<Condition> conditions;
        public final List<int[]> conditionSpans;
        public final Map<String, String> options;

        public FixTextDescription(String displayName, int[] fixSpan, List<Condition> conditions, List<int[]> conditionSpans, Map<String, String> options) {
            this.displayName = displayName;
            this.fixSpan = fixSpan;
            this.conditions = conditions;
            this.conditionSpans = conditionSpans;
            this.options = options;
        }
    }

    public static final class HintTextDescription {
        public final String displayName;
        public final int textStart;
        public final int textEnd;
        public final int hintEnd;
        public final List<Condition> conditions;
        public final List<int[]> conditionSpans;
        public final List<FixTextDescription> fixes;
        public final Map<String, String> options;

        public HintTextDescription(String displayName, int textStart, int textEnd, int hintEnd, List<Condition> conditions, List<int[]> conditionSpans, List<FixTextDescription> fixes, Map<String, String> options) {
            this.displayName = displayName;
            this.textStart = textStart;
            this.textEnd = textEnd;
            this.hintEnd = hintEnd;
            this.conditions = conditions;
            this.conditionSpans = conditionSpans;
            this.fixes = fixes;
            this.options = options;
        }
    }

    public static final class Result {
        public final Map<String, String> options;
        public final int[] importsBlock;
        public final List<HintTextDescription> hints;
        public final List<int[]> blocks;
        public final List<ErrorDescription> errors;

        public Result(Map<String, String> options, int[] importsBlock, List<HintTextDescription> hints, List<int[]> blocks, List<ErrorDescription> errors) {
            this.options = options;
            this.importsBlock = importsBlock;
            this.hints = hints;
            this.blocks = blocks;
            this.errors = errors;
        }
    }

    private static class Holder
    implements ChangeListener {
        final Reference<ClasspathInfo> cachedInfo;
        final ClasspathInfo universalPath;

        public Holder(ClasspathInfo cachedInfo, ClasspathInfo universalPath) {
            this.cachedInfo = new WeakReference<ClasspathInfo>(cachedInfo);
            this.universalPath = universalPath;
            cachedInfo.addChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
        }
    }

    private static final class Impl {
        private final FileObject file;
        private final CharSequence text;
        private final TokenSequence<DeclarativeHintTokenId> input;
        private final Map<String, String> options = new HashMap<String, String>();
        private String importsBlockCode;
        private int[] importsBlockSpan;
        private final List<HintTextDescription> hints = new LinkedList<HintTextDescription>();
        private final List<String> blocksCode = new LinkedList<String>();
        private final List<int[]> blocksSpan = new LinkedList<int[]>();
        private final List<ErrorDescription> errors = new LinkedList<ErrorDescription>();
        private final MethodInvocationContext mic;
        private boolean eof;

        private Impl(FileObject file, CharSequence text, TokenSequence<DeclarativeHintTokenId> input) {
            this.file = file;
            this.text = text;
            this.input = input;
            this.mic = new MethodInvocationContext();
            if (auxConditionClasses != null) {
                this.mic.ruleUtilities.addAll(Arrays.asList(auxConditionClasses));
            }
        }

        private boolean nextToken() {
            while (this.input.moveNext()) {
                if (this.id() == DeclarativeHintTokenId.WHITESPACE || this.id() == DeclarativeHintTokenId.BLOCK_COMMENT || this.id() == DeclarativeHintTokenId.LINE_COMMENT) continue;
                return true;
            }
            this.eof = true;
            return false;
        }

        private Token<DeclarativeHintTokenId> token() {
            return this.input.token();
        }

        private DeclarativeHintTokenId id() {
            return (DeclarativeHintTokenId)this.token().id();
        }

        private boolean readToken(DeclarativeHintTokenId id) {
            if (this.id() == id) {
                this.nextToken();
                return true;
            }
            return false;
        }

        private void parseInput() {
            boolean wasFirstRule = false;
            while (this.nextToken()) {
                if (this.id() == DeclarativeHintTokenId.JAVA_BLOCK) {
                    if (disableCustomCode) {
                        int pos = this.token().offset(null);
                        this.errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)"Custom code not allowed", (FileObject)this.file, (int)pos, (int)(pos + 2)));
                        break;
                    }
                    String block = this.token().text().toString();
                    int soffs = block.startsWith("<?") ? 2 : 0;
                    int eoffs = block.endsWith("?>") ? Math.max(soffs, block.length() - 2) : block.length();
                    block = block.substring(soffs, eoffs);
                    int[] span = new int[]{this.token().offset(null) + soffs, this.token().offset(null) + eoffs};
                    if (this.importsBlockCode == null && !wasFirstRule) {
                        this.importsBlockCode = block;
                        this.importsBlockSpan = span;
                    } else {
                        this.blocksCode.add(block);
                        this.blocksSpan.add(span);
                    }
                }
                wasFirstRule = true;
            }
            this.mic.setCode(this.importsBlockCode, this.blocksCode);
            this.input.moveStart();
            this.eof = false;
            while (this.nextToken()) {
                if (this.id() == DeclarativeHintTokenId.JAVA_BLOCK) continue;
                this.maybeParseOptions(this.options);
                this.parseRule();
            }
        }

        private void parseRule() {
            String displayName = this.parseDisplayName();
            int patternStart = this.input.offset();
            while (this.id() != DeclarativeHintTokenId.LEADS_TO && this.id() != DeclarativeHintTokenId.DOUBLE_COLON && this.id() != DeclarativeHintTokenId.DOUBLE_SEMICOLON && this.id() != DeclarativeHintTokenId.OPTIONS && !this.eof) {
                this.nextToken();
            }
            if (this.eof) {
                return;
            }
            int patternEnd = this.input.offset();
            HashMap<String, String> ruleOptions = new HashMap<String, String>();
            this.maybeParseOptions(ruleOptions);
            LinkedList<Condition> conditions = new LinkedList<Condition>();
            LinkedList<int[]> conditionsSpans = new LinkedList<int[]>();
            if (this.id() == DeclarativeHintTokenId.DOUBLE_COLON) {
                this.parseConditions(conditions, conditionsSpans);
            }
            LinkedList<FixTextDescription> targets = new LinkedList<FixTextDescription>();
            while (this.id() == DeclarativeHintTokenId.LEADS_TO && !this.eof) {
                this.nextToken();
                String fixDisplayName = this.parseDisplayName();
                int targetStart = this.input.offset();
                while (this.id() != DeclarativeHintTokenId.LEADS_TO && this.id() != DeclarativeHintTokenId.DOUBLE_COLON && this.id() != DeclarativeHintTokenId.DOUBLE_SEMICOLON && this.id() != DeclarativeHintTokenId.OPTIONS && !this.eof) {
                    this.nextToken();
                }
                int targetEnd = this.input.offset();
                HashMap<String, String> fixOptions = new HashMap<String, String>();
                this.maybeParseOptions(fixOptions);
                int[] span = new int[]{targetStart, targetEnd};
                LinkedList<Condition> fixConditions = new LinkedList<Condition>();
                LinkedList<int[]> fixConditionSpans = new LinkedList<int[]>();
                if (this.id() == DeclarativeHintTokenId.DOUBLE_COLON) {
                    this.parseConditions(fixConditions, fixConditionSpans);
                }
                targets.add(new FixTextDescription(fixDisplayName, span, fixConditions, fixConditionSpans, fixOptions));
            }
            this.hints.add(new HintTextDescription(displayName, patternStart, patternEnd, this.input.offset() + this.input.token().length(), conditions, conditionsSpans, targets, ruleOptions));
        }

        private void parseConditions(List<Condition> conditions, List<int[]> spans) {
            do {
                this.nextToken();
                this.parseCondition(conditions, spans);
            } while (this.id() == DeclarativeHintTokenId.AND && !this.eof);
        }

        private void parseCondition(List<Condition> conditions, List<int[]> spans) {
            int conditionStart = this.input.offset();
            if (this.id() == DeclarativeHintTokenId.OTHERWISE) {
                this.nextToken();
                conditions.add(new Condition.Otherwise());
                spans.add(new int[]{conditionStart, this.input.offset()});
                return;
            }
            boolean not = false;
            if (this.id() == DeclarativeHintTokenId.NOT) {
                not = true;
                this.nextToken();
            }
            if (this.id() == DeclarativeHintTokenId.VARIABLE) {
                String name = this.token().text().toString();
                this.nextToken();
                if (this.id() != DeclarativeHintTokenId.INSTANCEOF) {
                    return;
                }
                this.nextToken();
                int typeStart = this.input.offset();
                this.nextToken();
                int typeEnd = this.input.offset();
                conditions.add(new Condition.Instanceof(not, name, this.text.subSequence(typeStart, typeEnd).toString(), new int[]{typeStart, typeEnd}));
                spans.add(new int[]{conditionStart, typeEnd});
                return;
            }
            int start = this.input.offset();
            while (this.id() != DeclarativeHintTokenId.AND && this.id() != DeclarativeHintTokenId.LEADS_TO && this.id() != DeclarativeHintTokenId.DOUBLE_SEMICOLON && !this.eof) {
                this.nextToken();
            }
            int end = this.input.offset();
            try {
                Condition mi = DeclarativeHintsParser.resolve(this.mic, this.text.subSequence(start, end).toString(), not, conditionStart, this.file, this.errors);
                int[] span = new int[]{conditionStart, end};
                if (mi instanceof Condition.MethodInvocation && !((Condition.MethodInvocation)mi).link()) {
                    if (this.file != null) {
                        this.errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)"Cannot resolve method", (FileObject)this.file, (int)span[0], (int)span[1]));
                    }
                    mi = new Condition.False();
                }
                conditions.add(mi);
                spans.add(span);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void maybeParseOptions(Map<String, String> to) {
            if (this.id() != DeclarativeHintTokenId.OPTIONS) {
                return;
            }
            String opts = this.token().text().toString();
            if (opts.length() > 2) {
                DeclarativeHintsParser.parseOptions(opts.substring(2, opts.length() - 1), to);
            }
            this.nextToken();
        }

        private String parseDisplayName() {
            if (this.token().id() == DeclarativeHintTokenId.CHAR_LITERAL || this.token().id() == DeclarativeHintTokenId.STRING_LITERAL) {
                Token<DeclarativeHintTokenId> t = this.token();
                if (this.input.moveNext()) {
                    if (this.input.token().id() == DeclarativeHintTokenId.COLON) {
                        String displayName = t.text().subSequence(1, t.text().length() - 1).toString();
                        this.nextToken();
                        return displayName;
                    }
                    this.input.movePrevious();
                }
            }
            return null;
        }
    }
}

