/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.modules;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.openide.modules.ConstructorDelegate;
import org.openide.modules.PatchFor;
import org.openide.modules.PatchedPublic;

public class PatchedPublicProcessor
extends AbstractProcessor {
    private static final Set<String> ANNOTATIONS = new HashSet<String>(Arrays.asList(PatchedPublic.class.getCanonicalName(), PatchFor.class.getCanonicalName(), ConstructorDelegate.class.getCanonicalName()));
    private List<Element> originatingElements;
    private Map<String, String> superclasses = new HashMap<String, String>();
    private TypeElement implForElement;
    private Element valueElement;
    private boolean reported;
    private static final String IMPL_FOR_NAME = PatchFor.class.getName();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ANNOTATIONS;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.originatingElements = new ArrayList<Element>();
    }

    private void flush(RoundEnvironment roundEnv) {
        if (!this.originatingElements.isEmpty()) {
            try (OutputStream os = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/.bytecodePatched", this.originatingElements.toArray(new Element[this.originatingElements.size()])).openOutputStream();){
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
                for (Map.Entry<String, String> exEntry : this.superclasses.entrySet()) {
                    String api = exEntry.getKey();
                    String sup = exEntry.getValue();
                    bw.append("extend.").append(api).append("=").append(sup);
                    bw.newLine();
                }
                bw.flush();
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, x.getMessage());
            }
        }
    }

    private TypeElement getImplFor() {
        this.implForElement = this.processingEnv.getElementUtils().getTypeElement(IMPL_FOR_NAME);
        if (this.implForElement == null) {
            if (!this.reported) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot find @ImplementationFor annotation");
                this.reported = true;
            }
            return null;
        }
        for (Element element : this.implForElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals("value")) continue;
            this.valueElement = element;
            break;
        }
        return this.implForElement;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.flush(roundEnv);
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(PatchedPublic.class)) {
            if (element.getAnnotationMirrors().size() > 1) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot currently mix @PatchedPublic with other annotations", element);
                continue;
            }
            if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@PatchedPublic cannot be applied to what is already public", element);
                continue;
            }
            this.originatingElements.add(element);
        }
        block1: for (Element element : roundEnv.getElementsAnnotatedWith(PatchFor.class)) {
            List<? extends AnnotationMirror> mirrors = element.getAnnotationMirrors();
            String apiName = null;
            TypeElement target = null;
            for (AnnotationMirror annotationMirror : mirrors) {
                Element me = annotationMirror.getAnnotationType().asElement();
                if (me != this.getImplFor()) continue;
                AnnotationValue annotationValue = annotationMirror.getElementValues().get(this.valueElement);
                if (!(annotationValue.getValue() instanceof DeclaredType)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Value for @PatchFor must be a valid class", element);
                    continue block1;
                }
                Element x = ((DeclaredType)annotationValue.getValue()).asElement();
                if (!(x instanceof TypeElement)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Value for @PatchFor must be a valid class", element);
                    continue block1;
                }
                target = (TypeElement)x;
                if (target.getKind() != ElementKind.CLASS) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@PatchFor can be only applied on classes", element);
                    continue block1;
                }
                apiName = this.processingEnv.getElementUtils().getBinaryName(target).toString();
                break;
            }
            if (target == null) {
                throw new IllegalStateException();
            }
            TypeElement t = (TypeElement)element;
            boolean bl = false;
            for (Element element2 : t.getEnclosedElements()) {
                if (element2.getKind() != ElementKind.CONSTRUCTOR || !((ExecutableElement)element2).getParameters().isEmpty()) continue;
                boolean bl2 = true;
                break;
            }
            String superName = this.processingEnv.getElementUtils().getBinaryName(t).toString();
            TypeMirror typeMirror = t.getSuperclass();
            TypeMirror targetSuperClass = target.getSuperclass();
            if (!this.processingEnv.getTypeUtils().isSameType(typeMirror, targetSuperClass)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "API class and the substitue differ in their superclasses", element);
                continue;
            }
            this.superclasses.put(apiName, superName);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Adding injection of " + superName + " as a superclass of API " + apiName);
            this.originatingElements.add(element);
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

