/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.dd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DDHelper {
    private static final String RESOURCE_FOLDER = "/org/netbeans/modules/j2ee/common/dd/resources/";

    private DDHelper() {
    }

    public static FileObject createWebXml(Profile j2eeProfile, FileObject dir) throws IOException {
        return DDHelper.createWebXml(j2eeProfile, true, dir);
    }

    public static FileObject createWebXml(Profile j2eeProfile, boolean webXmlRequired, FileObject dir) throws IOException {
        String template = null;
        if ((Profile.JAKARTA_EE_10_FULL == j2eeProfile || Profile.JAKARTA_EE_10_WEB == j2eeProfile) && webXmlRequired) {
            template = "web-6.0.xml";
        } else if ((Profile.JAKARTA_EE_9_1_FULL == j2eeProfile || Profile.JAKARTA_EE_9_1_WEB == j2eeProfile || Profile.JAKARTA_EE_9_FULL == j2eeProfile || Profile.JAKARTA_EE_9_WEB == j2eeProfile) && webXmlRequired) {
            template = "web-5.0.xml";
        } else if ((Profile.JAKARTA_EE_8_FULL == j2eeProfile || Profile.JAKARTA_EE_8_WEB == j2eeProfile || Profile.JAVA_EE_8_FULL == j2eeProfile || Profile.JAVA_EE_8_WEB == j2eeProfile) && webXmlRequired) {
            template = "web-4.0.xml";
        } else if ((Profile.JAVA_EE_7_FULL == j2eeProfile || Profile.JAVA_EE_7_WEB == j2eeProfile) && webXmlRequired) {
            template = "web-3.1.xml";
        } else if ((Profile.JAVA_EE_6_FULL == j2eeProfile || Profile.JAVA_EE_6_WEB == j2eeProfile) && webXmlRequired) {
            template = "web-3.0.xml";
        } else if (Profile.JAVA_EE_5 == j2eeProfile) {
            template = "web-2.5.xml";
        } else if (Profile.J2EE_14 == j2eeProfile) {
            template = "web-2.4.xml";
        } else if (Profile.J2EE_13 == j2eeProfile) {
            template = "web-2.3.xml";
        }
        if (template == null) {
            return null;
        }
        MakeFileCopy action = new MakeFileCopy(RESOURCE_FOLDER + template, dir, "web.xml");
        FileUtil.runAtomicAction((Runnable)action);
        if (action.getException() != null) {
            throw action.getException();
        }
        return action.getResult();
    }

    public static FileObject createWebFragmentXml(Profile j2eeProfile, FileObject dir) throws IOException {
        String template = null;
        if (Profile.JAKARTA_EE_10_FULL == j2eeProfile || Profile.JAKARTA_EE_10_WEB == j2eeProfile) {
            template = "web-fragment-6.0.xml";
        } else if (Profile.JAKARTA_EE_9_1_FULL == j2eeProfile || Profile.JAKARTA_EE_9_1_WEB == j2eeProfile || Profile.JAKARTA_EE_9_FULL == j2eeProfile || Profile.JAKARTA_EE_9_WEB == j2eeProfile) {
            template = "web-fragment-5.0.xml";
        } else if (Profile.JAKARTA_EE_8_FULL == j2eeProfile || Profile.JAKARTA_EE_8_WEB == j2eeProfile || Profile.JAVA_EE_8_FULL == j2eeProfile || Profile.JAVA_EE_8_WEB == j2eeProfile) {
            template = "web-fragment-4.0.xml";
        } else if (Profile.JAVA_EE_7_FULL == j2eeProfile || Profile.JAVA_EE_7_WEB == j2eeProfile) {
            template = "web-fragment-3.1.xml";
        } else if (Profile.JAVA_EE_6_FULL == j2eeProfile || Profile.JAVA_EE_6_WEB == j2eeProfile) {
            template = "web-fragment-3.0.xml";
        }
        if (template == null) {
            return null;
        }
        MakeFileCopy action = new MakeFileCopy(RESOURCE_FOLDER + template, dir, "web-fragment.xml");
        FileUtil.runAtomicAction((Runnable)action);
        if (action.getException() != null) {
            throw action.getException();
        }
        return action.getResult();
    }

    public static FileObject createBeansXml(Profile j2eeProfile, FileObject dir) throws IOException {
        return DDHelper.createBeansXml(j2eeProfile, dir, "beans");
    }

    public static FileObject createBeansXml(Profile j2eeProfile, FileObject dir, String name) throws IOException {
        String template = null;
        if (Profile.JAKARTA_EE_10_FULL == j2eeProfile || Profile.JAKARTA_EE_10_WEB == j2eeProfile) {
            template = "beans-4.0.xml";
        } else if (Profile.JAKARTA_EE_9_1_FULL == j2eeProfile || Profile.JAKARTA_EE_9_1_WEB == j2eeProfile || Profile.JAKARTA_EE_9_FULL == j2eeProfile || Profile.JAKARTA_EE_9_WEB == j2eeProfile) {
            template = "beans-3.0.xml";
        } else if (Profile.JAKARTA_EE_8_FULL == j2eeProfile || Profile.JAKARTA_EE_8_WEB == j2eeProfile || Profile.JAVA_EE_8_FULL == j2eeProfile || Profile.JAVA_EE_8_WEB == j2eeProfile) {
            template = "beans-2.0.xml";
        } else if (Profile.JAVA_EE_7_FULL == j2eeProfile || Profile.JAVA_EE_7_WEB == j2eeProfile) {
            template = "beans-1.1.xml";
        } else if (Profile.JAVA_EE_6_FULL == j2eeProfile || Profile.JAVA_EE_6_WEB == j2eeProfile) {
            template = "beans-1.0.xml";
        }
        if (template == null) {
            return null;
        }
        MakeFileCopy action = new MakeFileCopy(RESOURCE_FOLDER + template, dir, name + ".xml");
        FileUtil.runAtomicAction((Runnable)action);
        if (action.getException() != null) {
            throw action.getException();
        }
        return action.getResult();
    }

    public static FileObject createValidationXml(Profile j2eeProfile, FileObject dir) throws IOException {
        return DDHelper.createValidationXml(j2eeProfile, dir, "validation");
    }

    public static FileObject createValidationXml(Profile j2eeProfile, FileObject dir, String name) throws IOException {
        String template = null;
        if (Profile.JAVA_EE_6_FULL == j2eeProfile || Profile.JAVA_EE_6_WEB == j2eeProfile) {
            template = "validation.xml";
        } else if (Profile.JAVA_EE_7_FULL == j2eeProfile || Profile.JAVA_EE_7_WEB == j2eeProfile) {
            template = "validation-1.1.xml";
        } else if (Profile.JAVA_EE_8_FULL == j2eeProfile || Profile.JAVA_EE_8_WEB == j2eeProfile || Profile.JAKARTA_EE_8_FULL == j2eeProfile || Profile.JAKARTA_EE_8_WEB == j2eeProfile) {
            template = "validation-2.0.xml";
        } else if (Profile.JAKARTA_EE_9_FULL == j2eeProfile || Profile.JAKARTA_EE_9_WEB == j2eeProfile || Profile.JAKARTA_EE_9_1_FULL == j2eeProfile || Profile.JAKARTA_EE_9_1_WEB == j2eeProfile || Profile.JAKARTA_EE_10_FULL == j2eeProfile || Profile.JAKARTA_EE_10_WEB == j2eeProfile) {
            template = "validation-3.0.xml";
        }
        if (template == null) {
            return null;
        }
        MakeFileCopy action = new MakeFileCopy(RESOURCE_FOLDER + template, dir, name + ".xml");
        FileUtil.runAtomicAction((Runnable)action);
        if (action.getException() != null) {
            throw action.getException();
        }
        return action.getResult();
    }

    public static FileObject createConstraintXml(Profile j2eeProfile, FileObject dir) throws IOException {
        return DDHelper.createValidationXml(j2eeProfile, dir, "constraint");
    }

    public static FileObject createConstraintXml(Profile j2eeProfile, FileObject dir, String name) throws IOException {
        String template = null;
        if (Profile.JAVA_EE_6_FULL == j2eeProfile || Profile.JAVA_EE_6_WEB == j2eeProfile) {
            template = "constraint.xml";
        } else if (Profile.JAVA_EE_7_FULL == j2eeProfile || Profile.JAVA_EE_7_WEB == j2eeProfile) {
            template = "constraint-1.1.xml";
        } else if (Profile.JAVA_EE_8_FULL == j2eeProfile || Profile.JAVA_EE_8_WEB == j2eeProfile || Profile.JAKARTA_EE_8_FULL == j2eeProfile || Profile.JAKARTA_EE_8_WEB == j2eeProfile) {
            template = "constraint-2.0.xml";
        } else if (Profile.JAKARTA_EE_9_FULL == j2eeProfile || Profile.JAKARTA_EE_9_WEB == j2eeProfile || Profile.JAKARTA_EE_9_1_FULL == j2eeProfile || Profile.JAKARTA_EE_9_1_WEB == j2eeProfile || Profile.JAKARTA_EE_10_FULL == j2eeProfile || Profile.JAKARTA_EE_10_WEB == j2eeProfile) {
            template = "constraint-3.0.xml";
        }
        if (template == null) {
            return null;
        }
        MakeFileCopy action = new MakeFileCopy(RESOURCE_FOLDER + template, dir, name + ".xml");
        FileUtil.runAtomicAction((Runnable)action);
        if (action.getException() != null) {
            throw action.getException();
        }
        return action.getResult();
    }

    public static FileObject createApplicationXml(Profile profile, FileObject dir, boolean forceCreation) throws IOException {
        String template = null;
        if (profile != null && profile.equals(Profile.JAKARTA_EE_10_FULL) && forceCreation) {
            template = "ear-10.xml";
        } else if (profile != null && (profile.equals(Profile.JAKARTA_EE_9_FULL) || profile.equals(Profile.JAKARTA_EE_9_1_FULL)) && forceCreation) {
            template = "ear-9.xml";
        } else if (profile != null && (profile.equals(Profile.JAKARTA_EE_8_FULL) || profile.equals(Profile.JAVA_EE_8_FULL)) && forceCreation) {
            template = "ear-8.xml";
        } else if (profile != null && profile.equals(Profile.JAVA_EE_7_FULL) && forceCreation) {
            template = "ear-7.xml";
        } else if (profile != null && profile.equals(Profile.JAVA_EE_6_FULL) && forceCreation) {
            template = "ear-6.xml";
        } else if (Profile.JAVA_EE_5.equals(profile) && forceCreation) {
            template = "ear-5.xml";
        } else if (Profile.J2EE_14.equals(profile) || Profile.J2EE_13.equals(profile)) {
            template = "ear-1.4.xml";
        }
        if (template == null) {
            return null;
        }
        MakeFileCopy action = new MakeFileCopy(RESOURCE_FOLDER + template, dir, "application.xml");
        FileUtil.runAtomicAction((Runnable)action);
        if (action.getException() != null) {
            throw action.getException();
        }
        return action.getResult();
    }

    public static boolean isApplicationXMLCompulsory(Project project) {
        assert (project != null);
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null && provider.getJ2eeModule().getType() == J2eeModule.Type.EAR && provider.getConfigSupport().isDescriptorRequired()) {
            return true;
        }
        Ear ear = Ear.getEar((FileObject)project.getProjectDirectory());
        return ear != null && Profile.J2EE_14.equals(ear.getJ2eeProfile());
    }

    private static class MakeFileCopy
    implements Runnable {
        private String fromFile;
        private FileObject toDir;
        private String toFile;
        private IOException exception;
        private FileObject result;

        MakeFileCopy(String fromFile, FileObject toDir, String toFile) {
            this.fromFile = fromFile;
            this.toDir = toDir;
            this.toFile = toFile;
        }

        IOException getException() {
            return this.exception;
        }

        FileObject getResult() {
            return this.result;
        }

        @Override
        public void run() {
            try {
                if (this.toDir.getFileObject(this.toFile) != null) {
                    return;
                }
                FileObject xml = FileUtil.createData((FileObject)this.toDir, (String)this.toFile);
                String content = this.readResource(DDHelper.class.getResourceAsStream(this.fromFile));
                if (content != null) {
                    try (FileLock lock = xml.lock();
                         BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(xml.getOutputStream(lock)));){
                        bw.write(content);
                    }
                }
                this.result = xml;
            }
            catch (IOException e) {
                this.exception = e;
            }
        }

        private String readResource(InputStream is) throws IOException {
            StringBuilder sb = new StringBuilder();
            String lineSep = System.getProperty("line.separator");
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    sb.append(lineSep);
                    line = br.readLine();
                }
            }
            return sb.toString();
        }
    }
}

